/*
 * Decompiled with CFR 0.152.
 */
package io.kalp.athang.durg.kirtimukh.throttling.strategies.window;

import io.kalp.athang.durg.kirtimukh.throttling.config.ThrottlingStrategyConfig;
import io.kalp.athang.durg.kirtimukh.throttling.config.impl.QuotaThrottlingStrategyConfig;
import io.kalp.athang.durg.kirtimukh.throttling.enums.ThrottlingStrategyType;
import io.kalp.athang.durg.kirtimukh.throttling.enums.ThrottlingWindowUnit;
import io.kalp.athang.durg.kirtimukh.throttling.exception.ThrottlingException;
import io.kalp.athang.durg.kirtimukh.throttling.strategies.tick.Tick;
import io.kalp.athang.durg.kirtimukh.throttling.strategies.tick.impl.LocationTick;
import io.kalp.athang.durg.kirtimukh.throttling.strategies.window.Window;
import io.kalp.athang.durg.kirtimukh.throttling.strategies.window.WindowChecker;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimedWindowChecker
implements WindowChecker {
    private static final Logger log = LoggerFactory.getLogger(TimedWindowChecker.class);
    private static final long MIN_INACTIVE_WINDOWS_TO_CLEAR = 5L;
    private final String commandName;
    private final ThrottlingStrategyType strategyType;
    private final ThrottlingWindowUnit unit;
    private final int threshold;
    private final long clearAfterInactiveWindows;
    private long prevWindow;
    private long liveWindow;
    private final Window window;

    public TimedWindowChecker(String commandName, final ThrottlingStrategyConfig strategyConfig) {
        this.commandName = commandName;
        this.strategyType = strategyConfig.getType();
        this.unit = strategyConfig.getUnit();
        this.threshold = strategyConfig.getThreshold();
        this.liveWindow = this.getWindow();
        this.clearAfterInactiveWindows = strategyConfig.getType().accept(new ThrottlingStrategyType.ThrottlingStrategyTypeVisitor<Long>(){

            @Override
            public Long visitQuota() {
                return ((QuotaThrottlingStrategyConfig)strategyConfig).getWindows();
            }

            @Override
            public Long visitLeakyBucket() {
                return 5L;
            }

            @Override
            public Long visitPriorityBuckets() {
                return 5L;
            }

            @Override
            public Long visitNg() {
                return null;
            }
        });
        this.window = Window.builder().threshold(this.threshold).build();
    }

    private long getWindow() {
        return this.unit.accept(new ThrottlingWindowUnit.ThrottlingWindowVisitor<Long>(){

            @Override
            public Long visitMillisecond() {
                return System.currentTimeMillis();
            }

            @Override
            public Long visitSecond() {
                return TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis());
            }

            @Override
            public Long visitMinute() {
                return TimeUnit.MILLISECONDS.toMinutes(System.currentTimeMillis());
            }
        });
    }

    private boolean isChangeInWindow() {
        long currentWindow = this.getWindow();
        if (this.liveWindow != currentWindow) {
            this.prevWindow = this.liveWindow;
            this.liveWindow = currentWindow;
            return true;
        }
        return false;
    }

    private boolean isOkayToClear() {
        return this.liveWindow - this.prevWindow >= this.clearAfterInactiveWindows;
    }

    private void precheck() {
        if (this.isChangeInWindow() && this.isOkayToClear()) {
            log.debug("[{}] Clearing bitset", (Object)this.commandName);
            this.window.clear();
        }
    }

    @Override
    public synchronized boolean release(Tick tick) {
        return this.window.remove(tick.getLocation());
    }

    @Override
    public synchronized Tick acquire() {
        this.precheck();
        int location = this.window.add();
        if (location < 0) {
            throw ThrottlingException.builder().commandName(this.commandName).strategyType(this.strategyType).cardinality(this.window.cardinality()).unit(this.unit).threshold(this.threshold).message("Threshold limits exhausted").build();
        }
        log.debug("[{}] Cardinality {} allowed limit {}", new Object[]{this.commandName, this.window.cardinality(), this.threshold});
        return LocationTick.builder().location(location).build();
    }

    public static TimedWindowCheckerBuilder builder() {
        return new TimedWindowCheckerBuilder();
    }

    public static class TimedWindowCheckerBuilder {
        private String commandName;
        private ThrottlingStrategyConfig strategyConfig;

        TimedWindowCheckerBuilder() {
        }

        public TimedWindowCheckerBuilder commandName(String commandName) {
            this.commandName = commandName;
            return this;
        }

        public TimedWindowCheckerBuilder strategyConfig(ThrottlingStrategyConfig strategyConfig) {
            this.strategyConfig = strategyConfig;
            return this;
        }

        public TimedWindowChecker build() {
            return new TimedWindowChecker(this.commandName, this.strategyConfig);
        }

        public String toString() {
            return "TimedWindowChecker.TimedWindowCheckerBuilder(commandName=" + this.commandName + ", strategyConfig=" + this.strategyConfig + ")";
        }
    }
}

