/*
 * Decompiled with CFR 0.152.
 */
package io.kalp.athang.durg.kirtimukh.throttling.exception;

import io.kalp.athang.durg.kirtimukh.throttling.enums.ThrottlingStrategyType;
import io.kalp.athang.durg.kirtimukh.throttling.enums.ThrottlingWindowUnit;
import java.beans.ConstructorProperties;

public class ThrottlingException
extends RuntimeException {
    private final String commandName;
    private final ThrottlingStrategyType strategyType;
    private final ThrottlingWindowUnit unit;
    private final int cardinality;
    private final int threshold;
    private final String message;

    @ConstructorProperties(value={"commandName", "strategyType", "unit", "cardinality", "threshold", "message"})
    ThrottlingException(String commandName, ThrottlingStrategyType strategyType, ThrottlingWindowUnit unit, int cardinality, int threshold, String message) {
        this.commandName = commandName;
        this.strategyType = strategyType;
        this.unit = unit;
        this.cardinality = cardinality;
        this.threshold = threshold;
        this.message = message;
    }

    public static ThrottlingExceptionBuilder builder() {
        return new ThrottlingExceptionBuilder();
    }

    public String getCommandName() {
        return this.commandName;
    }

    public ThrottlingStrategyType getStrategyType() {
        return this.strategyType;
    }

    public ThrottlingWindowUnit getUnit() {
        return this.unit;
    }

    public int getCardinality() {
        return this.cardinality;
    }

    public int getThreshold() {
        return this.threshold;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public String toString() {
        return "ThrottlingException(commandName=" + this.getCommandName() + ", strategyType=" + (Object)((Object)this.getStrategyType()) + ", unit=" + (Object)((Object)this.getUnit()) + ", cardinality=" + this.getCardinality() + ", threshold=" + this.getThreshold() + ", message=" + this.getMessage() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ThrottlingException)) {
            return false;
        }
        ThrottlingException other = (ThrottlingException)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$commandName = this.getCommandName();
        String other$commandName = other.getCommandName();
        if (this$commandName == null ? other$commandName != null : !this$commandName.equals(other$commandName)) {
            return false;
        }
        ThrottlingStrategyType this$strategyType = this.getStrategyType();
        ThrottlingStrategyType other$strategyType = other.getStrategyType();
        if (this$strategyType == null ? other$strategyType != null : !((Object)((Object)this$strategyType)).equals((Object)other$strategyType)) {
            return false;
        }
        ThrottlingWindowUnit this$unit = this.getUnit();
        ThrottlingWindowUnit other$unit = other.getUnit();
        if (this$unit == null ? other$unit != null : !((Object)((Object)this$unit)).equals((Object)other$unit)) {
            return false;
        }
        if (this.getCardinality() != other.getCardinality()) {
            return false;
        }
        if (this.getThreshold() != other.getThreshold()) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        return !(this$message == null ? other$message != null : !this$message.equals(other$message));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ThrottlingException;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        String $commandName = this.getCommandName();
        result = result * 59 + ($commandName == null ? 43 : $commandName.hashCode());
        ThrottlingStrategyType $strategyType = this.getStrategyType();
        result = result * 59 + ($strategyType == null ? 43 : ((Object)((Object)$strategyType)).hashCode());
        ThrottlingWindowUnit $unit = this.getUnit();
        result = result * 59 + ($unit == null ? 43 : ((Object)((Object)$unit)).hashCode());
        result = result * 59 + this.getCardinality();
        result = result * 59 + this.getThreshold();
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        return result;
    }

    public static class ThrottlingExceptionBuilder {
        private String commandName;
        private ThrottlingStrategyType strategyType;
        private ThrottlingWindowUnit unit;
        private int cardinality;
        private int threshold;
        private String message;

        ThrottlingExceptionBuilder() {
        }

        public ThrottlingExceptionBuilder commandName(String commandName) {
            this.commandName = commandName;
            return this;
        }

        public ThrottlingExceptionBuilder strategyType(ThrottlingStrategyType strategyType) {
            this.strategyType = strategyType;
            return this;
        }

        public ThrottlingExceptionBuilder unit(ThrottlingWindowUnit unit) {
            this.unit = unit;
            return this;
        }

        public ThrottlingExceptionBuilder cardinality(int cardinality) {
            this.cardinality = cardinality;
            return this;
        }

        public ThrottlingExceptionBuilder threshold(int threshold) {
            this.threshold = threshold;
            return this;
        }

        public ThrottlingExceptionBuilder message(String message) {
            this.message = message;
            return this;
        }

        public ThrottlingException build() {
            return new ThrottlingException(this.commandName, this.strategyType, this.unit, this.cardinality, this.threshold, this.message);
        }

        public String toString() {
            return "ThrottlingException.ThrottlingExceptionBuilder(commandName=" + this.commandName + ", strategyType=" + (Object)((Object)this.strategyType) + ", unit=" + (Object)((Object)this.unit) + ", cardinality=" + this.cardinality + ", threshold=" + this.threshold + ", message=" + this.message + ")";
        }
    }
}

