/*
 * Decompiled with CFR 0.152.
 */
package io.kalp.athang.durg.kirtimukh.throttling.config.impl;

import io.kalp.athang.durg.kirtimukh.throttling.config.ThrottlingStrategyConfig;
import io.kalp.athang.durg.kirtimukh.throttling.enums.ThrottlingStrategyType;
import io.kalp.athang.durg.kirtimukh.throttling.enums.ThrottlingWindowUnit;
import javax.validation.Valid;
import javax.validation.constraints.Min;

public class QuotaThrottlingStrategyConfig
extends ThrottlingStrategyConfig {
    @Valid
    @Min(value=1L)
    private long windows;

    public QuotaThrottlingStrategyConfig(ThrottlingWindowUnit unit, int threshold, long windows) {
        super(ThrottlingStrategyType.QUOTA, unit, threshold);
        this.windows = windows;
    }

    public static QuotaThrottlingStrategyConfigBuilder builder() {
        return new QuotaThrottlingStrategyConfigBuilder();
    }

    public long getWindows() {
        return this.windows;
    }

    public void setWindows(long windows) {
        this.windows = windows;
    }

    @Override
    public String toString() {
        return "QuotaThrottlingStrategyConfig(windows=" + this.getWindows() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QuotaThrottlingStrategyConfig)) {
            return false;
        }
        QuotaThrottlingStrategyConfig other = (QuotaThrottlingStrategyConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return this.getWindows() == other.getWindows();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof QuotaThrottlingStrategyConfig;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        long $windows = this.getWindows();
        result = result * 59 + (int)($windows >>> 32 ^ $windows);
        return result;
    }

    public static class QuotaThrottlingStrategyConfigBuilder {
        private ThrottlingWindowUnit unit;
        private int threshold;
        private long windows;

        QuotaThrottlingStrategyConfigBuilder() {
        }

        public QuotaThrottlingStrategyConfigBuilder unit(ThrottlingWindowUnit unit) {
            this.unit = unit;
            return this;
        }

        public QuotaThrottlingStrategyConfigBuilder threshold(int threshold) {
            this.threshold = threshold;
            return this;
        }

        public QuotaThrottlingStrategyConfigBuilder windows(long windows) {
            this.windows = windows;
            return this;
        }

        public QuotaThrottlingStrategyConfig build() {
            return new QuotaThrottlingStrategyConfig(this.unit, this.threshold, this.windows);
        }

        public String toString() {
            return "QuotaThrottlingStrategyConfig.QuotaThrottlingStrategyConfigBuilder(unit=" + (Object)((Object)this.unit) + ", threshold=" + this.threshold + ", windows=" + this.windows + ")";
        }
    }
}

