(ns dbscan.util)

(defn sqr
  "Computes the square value (aka pow2)"
  [x]
  (* x x))

(defn squared-distance
  "Computes the Euclidean squared distance between two sequences"
  [a b]
  (reduce + (map (comp sqr -) a b)))

(defn euclidean-distance
  "Computes the Euclidean distance between two sequences"
  [a b]
  (let [dist (squared-distance a b)]
    #?(:clj  (Math/sqrt dist)
       :cljs (js/Math.sqrt dist))))
