/*
 * Decompiled with CFR 0.152.
 */
package jepsen.history;

import clojure.lang.AFn;
import clojure.lang.AFunction;
import clojure.lang.IFn;
import clojure.lang.IObj;
import clojure.lang.RT;
import clojure.lang.Symbol;
import clojure.lang.Var;

public final class task$fn__1719
extends AFunction {
    public static final Var const__0 = RT.var((String)"clojure.core", (String)"commute");
    public static final Var const__1 = RT.var((String)"clojure.core", (String)"deref");
    public static final Var const__2 = RT.var((String)"clojure.core", (String)"*loaded-libs*");
    public static final Var const__3 = RT.var((String)"clojure.core", (String)"conj");
    public static final AFn const__4 = (AFn)((IObj)Symbol.intern(null, (String)"jepsen.history.task")).withMeta(RT.map((Object[])new Object[]{RT.keyword(null, (String)"doc"), "A transactional, dependency-graph oriented task scheduler. Provides a\n  stateful executor for CPU-bound tasks backed by a num-cores\n  ThreadPoolExecutor, and allows you to submit tasks to be run on that\n  executor.\n\n    (require '[jepsen.history.task :as task])\n    (def e (task/executor))\n\n  At a very high level, a task is a named function of optional dependencies\n  (inputs) which returns an output. Here's a task with no dependencies:\n\n    (def pet (task/submit! e :pet-dog (fn [_] :petting-dog)))\n\n  Tasks are derefable with the standard blocking and nonblocking calls.\n  Derefing a task returns its output. You can ask completion with `realized?`\n\n    @pet             ; :petting-dog\n    (realized? pet)  ; true\n\n  If a task throws, its output is the Throwable it threw. Derefing that\n  throwable also throws, like Clojure futures. Exceptions propagate to\n  dependencies: dependencies will never execute, and if derefed, will throw as\n  well.\n\n    (def doomed (task/submit! e :doomed (fn [_] (assert false))))\n    ; All fine, until\n    @doomed    ; throws Assert failed: false\n\n  Each task is assigned a unique long ID by its executor. Tasks should never be\n  used across executors; their hashcodes and equality semantics are, for\n  performance reasons, by ID *alone*.\n\n    (task/id pet)   ; 0\n\n  Tasks also have names, which can be any non-nil object, and are used for\n  debugging & observability. Tasks can also carry an arbitrary data object,\n  which can be anything you like. You can use this to build more sophisticated\n  task management systems around this executor.\n\n    (task/name pet)   ; :pet-dog\n\n    (def train (task/submit! e :train {:tricks [:down-stay :recall]} nil\n                 (fn [_] :training-dog)))\n    (task/data train)  ; {:tricks [:down-stay :recall]}\n\n  When submitted, tasks can depend on earlier tasks. When it executes, a task\n  receives a vector of the outputs of its dependencies. A task only executes\n  once its dependencies have completed, and will observe their memory effects.\n\n    (def dog-promise (promise))\n    (def dog-task    (task/submit! e :make-dog    (fn [_] @dog-promise)))\n    (def person-task (task/submit! e :make-person (fn [_] :nona)))\n    (def adopt-task  (task/submit! e :adopt [person-task dog-task]\n                       (fn [[person dog]]\n                         (prn person :adopts dog)\n                         :adopted!)))\n    ; Adopt pauses, waiting on dog, which in turn is waiting on our\n    ; dog-promise.\n    (realized? adopt-task)    ; false\n    (task/dep-ids adopt-task) ; [5 4]\n\n    ;Person completed immediately:\n    @person-task   ; :nona\n\n    ; Let's let the dog task run. Once it does, adopt can run too.\n    (deliver dog-promise :noodle)\n    ; Immediately prints :nona :adopts :noodle\n\n    ; Now we can deref the adoption task.\n    @adopt-task    ; :adopted!\n\n  Tasks may be cancelled. Cancelling a task also cancels all tasks which depend\n  on it. Unlike normal ThreadPoolExecutors, cancellation is *guaranteed* to be\n  safe: if a task is still pending, it will never run. Cancelling a task which\n  is running or has already run has no effect, other than removing it from the\n  executor state. This may not be right for all applications; it's important\n  for us.\n\n    (task/cancel! e adopt-task)\n\n  Tasks either run to completion or are cancelled; they are never interrupted.\n  If they are, who knows what could happen? Almost certainly the executor will\n  stall some tasks forever. Hopefully you're throwing away the executor and\n  moving on with your life.\n\n  Unlike standard j.u.c executors, tasks in this system may be created,\n  queried, and cancelled *transactionally*. The executor's state (`State`) is a\n  persistent, immutable structure. You perform a transaction with `(txn!\n  executor (fn [state] ...))`, which returns a new state. Any transformations\n  you apply to the state take place atomically. Note that these functions use\n  pure functions without `!`: `submit` instead of `submit!`, etc.\n\n    ; Create a task which blocks...\n    (def dog-promise (promise))\n    (def dog-task (task/submit! e :find-dog (fn [_] @dog-promise)))\n    ; And one that depends on it\n    (def adopt-task (task/submit! e :adopt-dog [dog-task]\n      (fn [dog] (println :adopting dog) [:adopted dog])))\n\n    ; adopt-task hasn't run because dog-task is still pending.\n    (task/txn! e (fn [state]\n      ; Make sure the adoption hasn't happened yet\n      (if-not (task/pending? state adopt-task)\n        state\n        ; If it hasn't happened yet, cancel the dog task. Adoption will be\n        ; cancelled automatically.\n        (let [state' (task/cancel state dog-task)\n              ; And do something else\n              [state' new-task] (task/submit state' :enter-tomb\n                                  (fn [_]\n                                    (prn :oh-no)\n                                    :tomb-entered))]\n          state'))))\n  ; prints :oh-no\n  (deliver dog-promise :noodle)\n  ; Adoption never happens!"}));

    public static Object invokeStatic() {
        return ((IFn)const__0.getRawRoot()).invoke(((IFn)const__1.getRawRoot()).invoke((Object)const__2), const__3.getRawRoot(), (Object)const__4);
    }

    public Object invoke() {
        return task$fn__1719.invokeStatic();
    }
}

