/*
 * Decompiled with CFR 0.152.
 */
package jepsen.history;

import clojure.lang.AFn;
import clojure.lang.AFunction;
import clojure.lang.IFn;
import clojure.lang.IObj;
import clojure.lang.RT;
import clojure.lang.Symbol;
import clojure.lang.Var;

public final class fold$fn__2488
extends AFunction {
    public static final Var const__0 = RT.var((String)"clojure.core", (String)"commute");
    public static final Var const__1 = RT.var((String)"clojure.core", (String)"deref");
    public static final Var const__2 = RT.var((String)"clojure.core", (String)"*loaded-libs*");
    public static final Var const__3 = RT.var((String)"clojure.core", (String)"conj");
    public static final AFn const__4 = (AFn)((IObj)Symbol.intern(null, (String)"jepsen.history.fold")).withMeta(RT.map((Object[])new Object[]{RT.keyword(null, (String)"doc"), "Provides a stateful folder for running folds (like `reduce`) over chunked,\n  immutable collections in linear and concurrent passes. Intended for systems\n  where the reduction over a chunk may involve expensive work, and not fit in\n  memory--for instance, deserializing values from disk. Provides sophisticated\n  optimizations for running folds in parallel, and automatically fusing\n  together multiple folds.\n\n  To build a folder, you need a chunkable collection: see\n  jepsen.history.core. Jepsen.history chunks vectors by default at 16384\n  elements per chunk, which is a bit big for a demonstration, so let's chunk\n  explicitly:\n\n    (require '[tesser.core :as t] '[jepsen.history [core :as hc] [fold :as f]])\n    (def dogs [{:legs 6, :name :noodle},\n               {:legs 4, :name :stop-it},\n               {:legs 4, :name :brown-one-by-the-fish-shop}])\n    (def chunked-dogs (hc/chunked 2 dogs))\n    (pprint (hc/chunks chunked-dogs))\n    ; ([{:legs 6, :name :noodle} {:legs 4, :name :stop-it}]\n    ;  [{:legs 4, :name :brown-one-by-the-fish-shop}])\n\n  In real use, chunks should be big enough to take a bit (a second or so?) to\n  reduce. We keep track of some state for each chunk, so millions is probably\n  too many. If you have fewer chunks than processors, we won't be able to\n  optimize as efficiently.\n\n  A folder wraps a chunked collection, like so:\n\n    (def f (f/folder chunked-dogs))\n\n  Now we can perform a reduction on the folder. This works just like Clojure\n  reduce:\n\n    (reduce (fn [max-legs dog]\n              (max max-legs (:legs dog)))\n            0\n            e)\n    ; => 6\n\n  Which means transducers and into work like you'd expect:\n\n    (into #{} (map :legs) f)\n    ; => #{4 6}\n\n  OK, great. What's the point? Imagine we had a collection where getting\n  elements was expensive--for instance, if they required IO or expensive\n  processing. Let's put ten million dogs on disk as JSON.\n\n    (require '[jepsen.history.fold-test :as ft])\n    (def dogs (ft/gen-dogs-file! 1e7))\n    (def f (f/folder dogs))\n\n  Reducing over ten million dogs as JSON takes about ten seconds on my\n  machine.\n\n    (time (into #{} (map :legs) dogs))\n    ; 10364 msecs\n\n  But with a folder, we can do something *neat*:\n\n    (def leg-set {:reducer-identity   (constantly #{})\n                  :reducer            (fn [legs dog] (conj legs (:legs dog)))\n                  :combiner           clojure.set/union})\n    (time (f/fold f leg-set))\n    ; 1660 msecs\n\n  This went roughly six times faster because the folder reduced each chunk in\n  parallel. Now let's run, say, ten reductions in parallel.\n\n    (time (doall (pmap (fn [_] (into #{} (map :legs) dogs)) (range 10))))\n    ; 28477 msecs\n\n  This 28 seconds is faster than running ten folds sequentially (which would\n  have been roughly 87 seconds), because we've got multiple cores to do the\n  reduction. But we're still paying a significant cost because each of those\n  reductions has to re-parse the file as it goes.\n\n    (time (doall (pmap (fn [_] (f/fold f leg-set)) (range 10))))\n    ; 2261 msecs\n\n  Twelve times faster than the parallel version! And roughly 45x faster than\n  doing the reductions naively in serial. How? Because when you ask a folder to\n  reduce something, and it's already running another reduction, it *joins* your\n  new reduction to the old one and performs most (or even all) of the work in\n  a single pass. The folder is smart enough to do this for both linear and\n  concurrent folds--and it does it while ensuring strict order and thread\n  safety for mutable accumulators. Let's replace that reduction with a mutable\n  HashSet, and convert it back to a Clojure set at the end.\n\n    (import java.util.HashSet)\n    (defn mut-hash-set [] (HashSet.))\n    (def fast-leg-set {:reducer-identity mut-hash-set\n                       :reducer          (fn [^HashSet s, dog]\n                                           (.add s (:legs dog)) s)\n                       :combiner-identity mut-hash-set\n                       :combiner         (fn [^HashSet s1, ^HashSet s2]\n                                           (.addAll s1 s2) s1)\n                       :post-combiner    set})\n    (time (doall (pmap (fn [_] (f/fold f fast-leg-set)) (range 10))))\n    ; 2197 msecs\n\n  # In general\n\n  A fold represents a reduction over a history, which can optionally be\n  executed over chunks concurrently. It's a map with the following fields:\n\n    ; Metadata\n\n    :name              The unique name of this fold. May be any object, but\n                       probably a keyword.\n\n    ; How to reduce a chunk\n\n    :reducer-identity  A function (f history) which generates an identity\n                       object for a reduction over a chunk.\n\n    :reducer           A function (f history acc op) which takes a history, a\n                       chunk accumulator, and an operation from the history,\n                       and returns a new accumulator.\n\n    :post-reducer      A function (f history acc) which takes the final\n                       accumulator from a chunk and transforms it before being\n                       passed to the combiner\n\n    ; How to combine chunks together\n\n    :combiner-identity A function (f history) which generates an identity\n                       object for combining chunk results together.\n\n    :combiner          A function (f history acc chunk-result) which folds\n                       the result of a chunk into the combiner's accumulator.\n                       If nil, performs a left fold linearly, and does not\n                       combine at all.\n\n    :post-combiner     A function (f history acc) which takes the final acc\n                       from merging all chunks and produces the fold's return\n                       value.\n\n    ; Execution hints\n\n    :associative?      If true, the combine function is associative, and can\n                       be applied in any order. If false, we must combine\n                       left-to-right. Right now this does nothing; we haven't\n                       implemented associative combine.\n\n    :asap?             Folders ramp up processing of concurrent folds gradually\n                       to give other folds a chance to join the pass. Setting\n                       this to `true` disables that optimization, which means a\n                       fold can complete more quickly--at the cost of slowing\n                       down other folds.\n\n  Folds should be pure functions of their histories, though reducers and\n  combiners are allowed to use in-memory mutability; each is guaranteed to be\n  single-threaded. We guarantee that reducers execute at most once per element,\n  and at most once per chunk. When not using `reduced`, they are exactly-once.\n  The final return value from a fold should be immutable so that other readers\n  or folds can use it safely in a concurrent context.\n\n  ## Early Termination\n\n  For linear folds (e.g. those with no combiner), we support the usual\n  `(reduced x)` early-return mechanism. This means reduce and transduce work as\n  you'd expect. Reduced values still go through the post-reducer function.\n\n  For concurrent folds, `(reduced x)` in a reducer terminates reduction of that\n  particular chunk. Other chunks are still reduced. Reduced values\n  go through post-reduce and are passed to the combiner unwrapped.\n  If the combiner returns a reduced value, that value passes immediately to the\n  post-combiner, without considering any other chunks.\n\n  Like transducers, post-reducers and post-combiners act on the values inside\n  Reduced wrappers; they cannot distinguish between reduced and non-reduced\n  values."}));

    public static Object invokeStatic() {
        return ((IFn)const__0.getRawRoot()).invoke(((IFn)const__1.getRawRoot()).invoke((Object)const__2), const__3.getRawRoot(), (Object)const__4);
    }

    public Object invoke() {
        return fold$fn__2488.invokeStatic();
    }
}

