/*
 * Decompiled with CFR 0.152.
 */
package zeph.ssl;

import java.nio.ByteBuffer;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import zeph.ssl.DirectBufferPool;

public class SslHandler {
    private final SSLEngine engine;
    private ByteBuffer netInBuffer;
    private ByteBuffer netOutBuffer;
    private ByteBuffer appInBuffer;
    private final ByteBuffer appOutBuffer;
    private ByteBuffer pendingCiphertext;
    private final ReentrantLock handshakeLock = new ReentrantLock();
    private volatile boolean handshakeComplete = false;
    private volatile boolean closed = false;
    private final int netBufferSize;
    private final int appBufferSize;
    private ByteBuffer encryptOutBuffer;
    private ByteBuffer decryptOutBuffer;
    private static final int LARGE_BUFFER_SIZE = 65536;
    private volatile boolean pendingWrap = false;

    public SslHandler(SSLEngine engine) {
        this.engine = engine;
        SSLSession session = engine.getSession();
        this.netBufferSize = session.getPacketBufferSize();
        this.appBufferSize = session.getApplicationBufferSize();
        this.netInBuffer = ByteBuffer.allocate(this.netBufferSize);
        this.netOutBuffer = ByteBuffer.allocate(this.netBufferSize);
        this.appInBuffer = ByteBuffer.allocate(this.appBufferSize);
        this.appOutBuffer = ByteBuffer.allocate(this.appBufferSize);
        this.encryptOutBuffer = ByteBuffer.allocateDirect(65536);
        this.decryptOutBuffer = ByteBuffer.allocateDirect(65536);
    }

    public void beginHandshake() throws SSLException {
        this.engine.beginHandshake();
    }

    public boolean isHandshakeComplete() {
        return this.handshakeComplete;
    }

    public boolean hasAccumulatedData() {
        return this.netInBuffer.position() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] processHandshake(byte[] input) throws SSLException {
        this.handshakeLock.lock();
        try {
            if (this.handshakeComplete) {
                byte[] byArray = null;
                return byArray;
            }
            this.netOutBuffer.clear();
            if (input != null && input.length > 0) {
                if (this.netInBuffer.remaining() < input.length) {
                    int newSize = this.netInBuffer.position() + input.length + this.netBufferSize;
                    ByteBuffer newBuf = ByteBuffer.allocate(newSize);
                    this.netInBuffer.flip();
                    newBuf.put(this.netInBuffer);
                    this.netInBuffer = newBuf;
                }
                this.netInBuffer.put(input);
            }
            byte[] byArray = this.doHandshake();
            return byArray;
        }
        finally {
            this.handshakeLock.unlock();
        }
    }

    private byte[] doHandshake() throws SSLException {
        SSLEngineResult.HandshakeStatus status = this.engine.getHandshakeStatus();
        while (true) {
            switch (status) {
                case NOT_HANDSHAKING: 
                case FINISHED: {
                    this.handshakeComplete = true;
                    return this.getNetOutData();
                }
                case NEED_WRAP: {
                    this.appOutBuffer.clear();
                    ByteBuffer wrapOut = ByteBuffer.allocate(this.netBufferSize);
                    SSLEngineResult result = this.engine.wrap(this.appOutBuffer, wrapOut);
                    if (result.bytesProduced() > 0) {
                        wrapOut.flip();
                        if (this.netOutBuffer.remaining() < wrapOut.remaining()) {
                            ByteBuffer newBuf = ByteBuffer.allocate(this.netOutBuffer.position() + wrapOut.remaining() + this.netBufferSize);
                            this.netOutBuffer.flip();
                            newBuf.put(this.netOutBuffer);
                            this.netOutBuffer = newBuf;
                        }
                        this.netOutBuffer.put(wrapOut);
                    }
                    status = result.getHandshakeStatus();
                    if (result.getStatus() == SSLEngineResult.Status.OK) {
                        if (status != SSLEngineResult.HandshakeStatus.NEED_UNWRAP) break;
                        return this.getNetOutData();
                    }
                    if (result.getStatus() != SSLEngineResult.Status.BUFFER_OVERFLOW) break;
                    throw new SSLException("Buffer overflow during handshake wrap");
                }
                case NEED_UNWRAP: {
                    this.netInBuffer.flip();
                    this.appInBuffer.clear();
                    SSLEngineResult result = this.engine.unwrap(this.netInBuffer, this.appInBuffer);
                    this.netInBuffer.compact();
                    status = result.getHandshakeStatus();
                    if (result.getStatus() == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                        return this.getNetOutData();
                    }
                    if (result.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                        this.appInBuffer = ByteBuffer.allocate(this.appInBuffer.capacity() * 2);
                        break;
                    }
                    if (result.getStatus() == SSLEngineResult.Status.OK || result.getStatus() != SSLEngineResult.Status.CLOSED) break;
                    this.closed = true;
                    return null;
                }
                case NEED_TASK: {
                    Runnable task;
                    while ((task = this.engine.getDelegatedTask()) != null) {
                        task.run();
                    }
                    status = this.engine.getHandshakeStatus();
                }
            }
        }
    }

    public byte[] encrypt(byte[] plaintext) throws SSLException {
        if (!this.handshakeComplete) {
            throw new SSLException("Handshake not complete");
        }
        ByteBuffer input = ByteBuffer.wrap(plaintext);
        int requiredSize = plaintext.length + this.netBufferSize;
        if (this.encryptOutBuffer.capacity() < requiredSize) {
            this.encryptOutBuffer = ByteBuffer.allocateDirect(requiredSize * 2);
        }
        this.encryptOutBuffer.clear();
        while (input.hasRemaining()) {
            Runnable task;
            SSLEngineResult result = this.engine.wrap(input, this.encryptOutBuffer);
            if (result.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                int newSize = this.encryptOutBuffer.capacity() * 2;
                ByteBuffer newBuffer = ByteBuffer.allocateDirect(newSize);
                this.encryptOutBuffer.flip();
                newBuffer.put(this.encryptOutBuffer);
                this.encryptOutBuffer = newBuffer;
            } else if (result.getStatus() == SSLEngineResult.Status.CLOSED) {
                this.closed = true;
                break;
            }
            if (result.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NEED_TASK) continue;
            while ((task = this.engine.getDelegatedTask()) != null) {
                task.run();
            }
        }
        this.encryptOutBuffer.flip();
        byte[] encrypted = new byte[this.encryptOutBuffer.remaining()];
        this.encryptOutBuffer.get(encrypted);
        return encrypted;
    }

    public byte[] decrypt(byte[] ciphertext) throws SSLException {
        ByteBuffer input;
        if (!this.handshakeComplete) {
            throw new SSLException("Handshake not complete");
        }
        if (this.pendingCiphertext != null && this.pendingCiphertext.hasRemaining()) {
            int totalSize = this.pendingCiphertext.remaining() + ciphertext.length;
            input = ByteBuffer.allocate(totalSize);
            input.put(this.pendingCiphertext);
            input.put(ciphertext);
            input.flip();
            this.pendingCiphertext = null;
        } else {
            input = ByteBuffer.wrap(ciphertext);
        }
        int requiredSize = this.appBufferSize + input.remaining();
        if (this.decryptOutBuffer.capacity() < requiredSize) {
            this.decryptOutBuffer = ByteBuffer.allocateDirect(requiredSize * 2);
        }
        this.decryptOutBuffer.clear();
        while (input.hasRemaining()) {
            SSLEngineResult result = this.engine.unwrap(input, this.decryptOutBuffer);
            if (result.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                int newSize = this.decryptOutBuffer.capacity() * 2;
                ByteBuffer newBuffer = ByteBuffer.allocateDirect(newSize);
                this.decryptOutBuffer.flip();
                newBuffer.put(this.decryptOutBuffer);
                this.decryptOutBuffer = newBuffer;
            } else {
                if (result.getStatus() == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                    if (!input.hasRemaining()) break;
                    this.pendingCiphertext = ByteBuffer.allocate(input.remaining());
                    this.pendingCiphertext.put(input);
                    this.pendingCiphertext.flip();
                    break;
                }
                if (result.getStatus() == SSLEngineResult.Status.CLOSED) {
                    this.closed = true;
                    break;
                }
            }
            SSLEngineResult.HandshakeStatus hsStatus = result.getHandshakeStatus();
            while (hsStatus == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                Runnable task;
                while ((task = this.engine.getDelegatedTask()) != null) {
                    task.run();
                }
                hsStatus = this.engine.getHandshakeStatus();
            }
            if (hsStatus != SSLEngineResult.HandshakeStatus.NEED_WRAP) continue;
            this.pendingWrap = true;
        }
        this.decryptOutBuffer.flip();
        byte[] decrypted = new byte[this.decryptOutBuffer.remaining()];
        this.decryptOutBuffer.get(decrypted);
        return decrypted;
    }

    public int encryptTo(byte[] plaintext, ByteBuffer dst) throws SSLException {
        if (!this.handshakeComplete) {
            throw new SSLException("Handshake not complete");
        }
        ByteBuffer input = ByteBuffer.wrap(plaintext);
        int startPos = dst.position();
        while (input.hasRemaining()) {
            Runnable task;
            SSLEngineResult result = this.engine.wrap(input, dst);
            if (result.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                return -1;
            }
            if (result.getStatus() == SSLEngineResult.Status.CLOSED) {
                this.closed = true;
                break;
            }
            if (result.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NEED_TASK) continue;
            while ((task = this.engine.getDelegatedTask()) != null) {
                task.run();
            }
        }
        return dst.position() - startPos;
    }

    public int decryptTo(ByteBuffer src, ByteBuffer dst) throws SSLException {
        ByteBuffer input;
        if (!this.handshakeComplete) {
            throw new SSLException("Handshake not complete");
        }
        if (this.pendingCiphertext != null && this.pendingCiphertext.hasRemaining()) {
            int totalSize = this.pendingCiphertext.remaining() + src.remaining();
            input = ByteBuffer.allocate(totalSize);
            input.put(this.pendingCiphertext);
            input.put(src);
            input.flip();
            this.pendingCiphertext = null;
        } else {
            input = src;
        }
        int startPos = dst.position();
        while (input.hasRemaining()) {
            SSLEngineResult result = this.engine.unwrap(input, dst);
            if (result.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                return -1;
            }
            if (result.getStatus() == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                if (!input.hasRemaining()) break;
                this.pendingCiphertext = ByteBuffer.allocate(input.remaining());
                this.pendingCiphertext.put(input);
                this.pendingCiphertext.flip();
                break;
            }
            if (result.getStatus() == SSLEngineResult.Status.CLOSED) {
                this.closed = true;
                break;
            }
            SSLEngineResult.HandshakeStatus hsStatus = result.getHandshakeStatus();
            while (hsStatus == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                Runnable task;
                while ((task = this.engine.getDelegatedTask()) != null) {
                    task.run();
                }
                hsStatus = this.engine.getHandshakeStatus();
            }
            if (hsStatus != SSLEngineResult.HandshakeStatus.NEED_WRAP) continue;
            this.pendingWrap = true;
        }
        return dst.position() - startPos;
    }

    public ByteBuffer getEncryptBuffer() {
        return this.encryptOutBuffer;
    }

    public ByteBuffer encryptDirect(byte[] plaintext) throws SSLException {
        if (!this.handshakeComplete) {
            throw new SSLException("Handshake not complete");
        }
        ByteBuffer input = ByteBuffer.wrap(plaintext);
        int requiredSize = plaintext.length + this.netBufferSize;
        if (this.encryptOutBuffer.capacity() < requiredSize) {
            this.encryptOutBuffer = ByteBuffer.allocateDirect(requiredSize * 2);
        }
        this.encryptOutBuffer.clear();
        while (input.hasRemaining()) {
            Runnable task;
            SSLEngineResult result = this.engine.wrap(input, this.encryptOutBuffer);
            if (result.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                int newSize = this.encryptOutBuffer.capacity() * 2;
                ByteBuffer newBuffer = ByteBuffer.allocateDirect(newSize);
                this.encryptOutBuffer.flip();
                newBuffer.put(this.encryptOutBuffer);
                this.encryptOutBuffer = newBuffer;
            } else if (result.getStatus() == SSLEngineResult.Status.CLOSED) {
                this.closed = true;
                break;
            }
            if (result.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NEED_TASK) continue;
            while ((task = this.engine.getDelegatedTask()) != null) {
                task.run();
            }
        }
        this.encryptOutBuffer.flip();
        return this.encryptOutBuffer;
    }

    public ByteBuffer encryptToDirectBuffer(byte[] plaintext) throws SSLException {
        ByteBuffer internal = this.encryptDirect(plaintext);
        int size = internal.remaining();
        ByteBuffer pooled = DirectBufferPool.acquire(size);
        pooled.put(internal);
        pooled.flip();
        return pooled;
    }

    public boolean hasPendingWrap() {
        return this.pendingWrap;
    }

    public byte[] processPendingWrap() throws SSLException {
        if (!this.pendingWrap) {
            return null;
        }
        ByteBuffer output = ByteBuffer.allocate(this.netBufferSize);
        ByteBuffer empty = ByteBuffer.allocate(0);
        SSLEngineResult result = this.engine.wrap(empty, output);
        this.pendingWrap = false;
        SSLEngineResult.HandshakeStatus hsStatus = result.getHandshakeStatus();
        while (hsStatus == SSLEngineResult.HandshakeStatus.NEED_TASK) {
            Runnable task;
            while ((task = this.engine.getDelegatedTask()) != null) {
                task.run();
            }
            hsStatus = this.engine.getHandshakeStatus();
        }
        if (hsStatus == SSLEngineResult.HandshakeStatus.NEED_WRAP) {
            this.pendingWrap = true;
        }
        if (result.bytesProduced() > 0) {
            output.flip();
            byte[] data = new byte[output.remaining()];
            output.get(data);
            return data;
        }
        return null;
    }

    public byte[] close() throws SSLException {
        this.engine.closeOutbound();
        ByteBuffer output = ByteBuffer.allocate(this.netBufferSize);
        SSLEngineResult result = this.engine.wrap(ByteBuffer.allocate(0), output);
        if (result.getStatus() == SSLEngineResult.Status.CLOSED || result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
            this.closed = true;
        }
        output.flip();
        byte[] closeData = new byte[output.remaining()];
        output.get(closeData);
        return closeData;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setPendingCiphertext(byte[] data) {
        if (data != null && data.length > 0) {
            this.pendingCiphertext = ByteBuffer.allocate(data.length);
            this.pendingCiphertext.put(data);
            this.pendingCiphertext.flip();
        }
    }

    public boolean hasPendingCiphertext() {
        return this.pendingCiphertext != null && this.pendingCiphertext.hasRemaining();
    }

    public byte[] getRemainingData() {
        this.netInBuffer.flip();
        if (this.netInBuffer.hasRemaining()) {
            byte[] data = new byte[this.netInBuffer.remaining()];
            this.netInBuffer.get(data);
            this.netInBuffer.clear();
            return data;
        }
        this.netInBuffer.clear();
        return null;
    }

    private byte[] getNetOutData() {
        this.netOutBuffer.flip();
        if (this.netOutBuffer.hasRemaining()) {
            byte[] data = new byte[this.netOutBuffer.remaining()];
            this.netOutBuffer.get(data);
            this.netOutBuffer.clear();
            return data;
        }
        this.netOutBuffer.clear();
        return null;
    }

    public String getApplicationProtocol() {
        return this.engine.getApplicationProtocol();
    }

    public SSLSession getSession() {
        return this.engine.getSession();
    }
}

