/*
 * Decompiled with CFR 0.152.
 */
package zeph.ssl;

import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentLinkedQueue;

public class DirectBufferPool {
    private static final int[] SIZE_CLASSES = new int[]{16384, 32768, 65536, 131072, 262144, 524288, 0x100000};
    private static final ConcurrentLinkedQueue<ByteBuffer>[] POOLS = new ConcurrentLinkedQueue[SIZE_CLASSES.length];
    private static final int MAX_POOLED_PER_CLASS = 64;

    public static ByteBuffer acquire(int minSize) {
        int classIndex = DirectBufferPool.findSizeClass(minSize);
        if (classIndex >= 0) {
            ByteBuffer pooled = POOLS[classIndex].poll();
            if (pooled != null) {
                pooled.clear();
                return pooled;
            }
            return ByteBuffer.allocateDirect(SIZE_CLASSES[classIndex]);
        }
        return ByteBuffer.allocateDirect(minSize);
    }

    public static void release(ByteBuffer buffer) {
        if (buffer == null || !buffer.isDirect()) {
            return;
        }
        int capacity = buffer.capacity();
        int classIndex = DirectBufferPool.findExactSizeClass(capacity);
        if (classIndex >= 0 && POOLS[classIndex].size() < 64) {
            buffer.clear();
            POOLS[classIndex].offer(buffer);
        }
    }

    private static int findSizeClass(int size) {
        for (int i = 0; i < SIZE_CLASSES.length; ++i) {
            if (SIZE_CLASSES[i] < size) continue;
            return i;
        }
        return -1;
    }

    private static int findExactSizeClass(int capacity) {
        for (int i = 0; i < SIZE_CLASSES.length; ++i) {
            if (SIZE_CLASSES[i] != capacity) continue;
            return i;
        }
        return -1;
    }

    public static String getStats() {
        StringBuilder sb = new StringBuilder("DirectBufferPool stats:\n");
        for (int i = 0; i < SIZE_CLASSES.length; ++i) {
            sb.append(String.format("  %dKB: %d pooled%n", SIZE_CLASSES[i] / 1024, POOLS[i].size()));
        }
        return sb.toString();
    }

    static {
        for (int i = 0; i < SIZE_CLASSES.length; ++i) {
            DirectBufferPool.POOLS[i] = new ConcurrentLinkedQueue();
        }
    }
}

