/*
 * Decompiled with CFR 0.152.
 */
package zeph.metrics;

import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Supplier;

public class Metrics {
    private static final Map<String, Counter> counters = new ConcurrentHashMap<String, Counter>();
    private static final Map<String, Gauge> gauges = new ConcurrentHashMap<String, Gauge>();
    private static final Map<String, Histogram> histograms = new ConcurrentHashMap<String, Histogram>();

    public static Counter counter(String name) {
        return counters.computeIfAbsent(name, k -> new Counter());
    }

    public static void gauge(String name, Supplier<Number> supplier) {
        gauges.put(name, new Gauge(supplier));
    }

    public static Histogram histogram(String name) {
        return histograms.computeIfAbsent(name, k -> new Histogram());
    }

    public static Map<String, Object> getAll() {
        ConcurrentHashMap<String, Object> result = new ConcurrentHashMap<String, Object>();
        counters.forEach((name, counter) -> result.put((String)name, counter.get()));
        gauges.forEach((name, gauge) -> result.put((String)name, gauge.get()));
        histograms.forEach((name, histogram) -> {
            Histogram.Stats stats = histogram.getStats();
            result.put(name + ".count", stats.count());
            result.put(name + ".min", stats.min());
            result.put(name + ".max", stats.max());
            result.put(name + ".mean", stats.mean());
            result.put(name + ".p50", stats.p50());
            result.put(name + ".p95", stats.p95());
            result.put(name + ".p99", stats.p99());
        });
        return result;
    }

    public static Map<String, Long> getCounters() {
        ConcurrentHashMap<String, Long> result = new ConcurrentHashMap<String, Long>();
        counters.forEach((name, counter) -> result.put((String)name, counter.get()));
        return result;
    }

    public static Map<String, Number> getGauges() {
        ConcurrentHashMap<String, Number> result = new ConcurrentHashMap<String, Number>();
        gauges.forEach((name, gauge) -> result.put((String)name, gauge.get()));
        return result;
    }

    public static Map<String, Histogram.Stats> getHistograms() {
        ConcurrentHashMap<String, Histogram.Stats> result = new ConcurrentHashMap<String, Histogram.Stats>();
        histograms.forEach((name, histogram) -> result.put((String)name, histogram.getStats()));
        return result;
    }

    public static void reset() {
        counters.values().forEach(Counter::reset);
        histograms.values().forEach(Histogram::reset);
    }

    public static void clear() {
        counters.clear();
        gauges.clear();
        histograms.clear();
    }

    public static class Counter {
        private final LongAdder value = new LongAdder();

        public void increment() {
            this.value.increment();
        }

        public void increment(long delta) {
            this.value.add(delta);
        }

        public void decrement() {
            this.value.decrement();
        }

        public long get() {
            return this.value.sum();
        }

        public void reset() {
            this.value.reset();
        }
    }

    public static class Gauge {
        private final Supplier<Number> supplier;

        public Gauge(Supplier<Number> supplier) {
            this.supplier = supplier;
        }

        public Number get() {
            return this.supplier.get();
        }
    }

    public static class Histogram {
        private static final int RESERVOIR_SIZE = 1024;
        private final LongAdder count = new LongAdder();
        private final LongAdder sum = new LongAdder();
        private final AtomicLong min = new AtomicLong(Long.MAX_VALUE);
        private final AtomicLong max = new AtomicLong(Long.MIN_VALUE);
        private final long[] reservoir = new long[1024];
        private final AtomicLong reservoirCount = new AtomicLong(0L);

        public void record(long value) {
            long currentMax;
            long currentMin;
            this.count.increment();
            this.sum.add(value);
            while (value < (currentMin = this.min.get()) && !this.min.compareAndSet(currentMin, value)) {
            }
            while (value > (currentMax = this.max.get()) && !this.max.compareAndSet(currentMax, value)) {
            }
            long n = this.reservoirCount.incrementAndGet();
            if (n <= 1024L) {
                this.reservoir[(int)(n - 1L)] = value;
            } else {
                long idx = (long)(Math.random() * (double)n);
                if (idx < 1024L) {
                    this.reservoir[(int)idx] = value;
                }
            }
        }

        public Stats getStats() {
            long c = this.count.sum();
            if (c == 0L) {
                return new Stats(0L, 0L, 0L, 0.0, 0L, 0L, 0L);
            }
            long[] sorted = this.getSortedReservoir();
            int len = sorted.length;
            return new Stats(c, this.min.get(), this.max.get(), (double)this.sum.sum() / (double)c, sorted[len / 2], sorted[(int)((double)len * 0.95)], sorted[(int)((double)len * 0.99)]);
        }

        private long[] getSortedReservoir() {
            int len = (int)Math.min(this.reservoirCount.get(), 1024L);
            if (len == 0) {
                return new long[]{0L};
            }
            long[] copy = new long[len];
            System.arraycopy(this.reservoir, 0, copy, 0, len);
            Arrays.sort(copy);
            return copy;
        }

        public void reset() {
            this.count.reset();
            this.sum.reset();
            this.min.set(Long.MAX_VALUE);
            this.max.set(Long.MIN_VALUE);
            this.reservoirCount.set(0L);
        }

        public record Stats(long count, long min, long max, double mean, long p50, long p95, long p99) {
        }
    }
}

