/*
 * Decompiled with CFR 0.152.
 */
package zeph.logging;

public class Logger {
    private static volatile LogHandler handler = Logger::defaultHandler;
    private final String component;

    public static void setHandler(LogHandler h) {
        handler = h != null ? h : Logger::defaultHandler;
    }

    public static void resetHandler() {
        handler = Logger::defaultHandler;
    }

    private static void defaultHandler(Level level, String component, String message, Throwable error) {
        String prefix = "[" + String.valueOf((Object)level) + "] ";
        if (component != null) {
            prefix = prefix + "[" + component + "] ";
        }
        if (level == Level.ERROR || level == Level.WARN) {
            System.err.println(prefix + message);
            if (error != null) {
                error.printStackTrace(System.err);
            }
        } else {
            System.out.println(prefix + message);
        }
    }

    public Logger(String component) {
        this.component = component;
    }

    public Logger(Class<?> clazz) {
        this.component = clazz.getSimpleName();
    }

    public void trace(String message) {
        handler.log(Level.TRACE, this.component, message, null);
    }

    public void debug(String message) {
        handler.log(Level.DEBUG, this.component, message, null);
    }

    public void info(String message) {
        handler.log(Level.INFO, this.component, message, null);
    }

    public void warn(String message) {
        handler.log(Level.WARN, this.component, message, null);
    }

    public void warn(String message, Throwable error) {
        handler.log(Level.WARN, this.component, message, error);
    }

    public void error(String message) {
        handler.log(Level.ERROR, this.component, message, null);
    }

    public void error(String message, Throwable error) {
        handler.log(Level.ERROR, this.component, message, error);
    }

    public static void log(Level level, String message) {
        handler.log(level, null, message, null);
    }

    public static void log(Level level, String message, Throwable error) {
        handler.log(level, null, message, error);
    }

    @FunctionalInterface
    public static interface LogHandler {
        public void log(Level var1, String var2, String var3, Throwable var4);
    }

    public static enum Level {
        TRACE,
        DEBUG,
        INFO,
        WARN,
        ERROR;

    }
}

