/*
 * Decompiled with CFR 0.152.
 */
package zeph.http2.hpack;

import java.io.ByteArrayOutputStream;
import java.util.List;
import zeph.http2.hpack.HpackDynamicTable;
import zeph.http2.hpack.HpackHuffman;
import zeph.http2.hpack.HpackStaticTable;

public class HpackEncoder {
    private final HpackDynamicTable dynamicTable;
    private final boolean useHuffman;
    private final boolean indexing;

    public HpackEncoder() {
        this(4096, true, true);
    }

    public HpackEncoder(int maxTableSize, boolean useHuffman, boolean indexing) {
        this.dynamicTable = new HpackDynamicTable(maxTableSize);
        this.useHuffman = useHuffman;
        this.indexing = indexing;
    }

    public byte[] encode(List<String[]> headers) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        for (String[] header : headers) {
            this.encodeHeader(out, header[0], header[1]);
        }
        return out.toByteArray();
    }

    public void encodeHeader(ByteArrayOutputStream out, String name, String value) {
        int index = this.findIndex(name, value);
        if (index > 0) {
            this.encodeInteger(out, index, 7, 128);
            return;
        }
        int nameIndex = this.findNameIndex(name);
        if (this.indexing && this.shouldIndex(name)) {
            if (nameIndex > 0) {
                this.encodeInteger(out, nameIndex, 6, 64);
            } else {
                out.write(64);
                this.encodeString(out, name);
            }
            this.encodeString(out, value);
            this.dynamicTable.add(name, value);
        } else {
            if (nameIndex > 0) {
                this.encodeInteger(out, nameIndex, 4, 0);
            } else {
                out.write(0);
                this.encodeString(out, name);
            }
            this.encodeString(out, value);
        }
    }

    private int findIndex(String name, String value) {
        int staticIndex = HpackStaticTable.findIndex(name, value);
        if (staticIndex > 0) {
            return staticIndex;
        }
        int dynamicIndex = this.dynamicTable.findIndex(name, value);
        if (dynamicIndex > 0) {
            return 61 + dynamicIndex;
        }
        return -1;
    }

    private int findNameIndex(String name) {
        int staticIndex = HpackStaticTable.findNameIndex(name);
        if (staticIndex > 0) {
            return staticIndex;
        }
        int dynamicIndex = this.dynamicTable.findNameIndex(name);
        if (dynamicIndex > 0) {
            return 61 + dynamicIndex;
        }
        return -1;
    }

    private boolean shouldIndex(String name) {
        return !name.equals("authorization") && !name.equals("cookie") && !name.equals("set-cookie") && !name.startsWith(":");
    }

    private void encodeInteger(ByteArrayOutputStream out, int value, int prefixBits, int prefix) {
        int mask = (1 << prefixBits) - 1;
        if (value < mask) {
            out.write(prefix | value);
        } else {
            out.write(prefix | mask);
            value -= mask;
            while (value >= 128) {
                out.write(value & 0x7F | 0x80);
                value >>= 7;
            }
            out.write(value);
        }
    }

    private void encodeString(ByteArrayOutputStream out, String str) {
        int huffmanLen;
        byte[] raw = str.getBytes();
        if (this.useHuffman && (huffmanLen = HpackHuffman.encodedLength(raw)) < raw.length) {
            byte[] huffman = HpackHuffman.encode(raw);
            this.encodeInteger(out, huffman.length, 7, 128);
            out.writeBytes(huffman);
            return;
        }
        this.encodeInteger(out, raw.length, 7, 0);
        out.writeBytes(raw);
    }

    public byte[] encodeTableSizeUpdate(int newSize) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.encodeInteger(out, newSize, 5, 32);
        this.dynamicTable.setMaxSize(newSize);
        return out.toByteArray();
    }

    public void setMaxTableSize(int maxSize) {
        this.dynamicTable.setMaxSize(maxSize);
    }

    public HpackDynamicTable getDynamicTable() {
        return this.dynamicTable;
    }
}

