/*
 * Decompiled with CFR 0.152.
 */
package zeph.http2.hpack;

public class HpackDynamicTable {
    private static final int ENTRY_OVERHEAD = 32;
    public static final int DEFAULT_MAX_SIZE = 4096;
    private String[] names;
    private String[] values;
    private int head;
    private int count;
    private int currentSize;
    private int maxSize;

    public HpackDynamicTable() {
        this(4096);
    }

    public HpackDynamicTable(int maxSize) {
        this.maxSize = maxSize;
        this.names = new String[16];
        this.values = new String[16];
        this.head = 0;
        this.count = 0;
        this.currentSize = 0;
    }

    public String[] getEntry(int index) {
        if (index < 1 || index > this.count) {
            return null;
        }
        int pos = (this.head + index - 1) % this.names.length;
        return new String[]{this.names[pos], this.values[pos]};
    }

    public String getName(int index) {
        if (index < 1 || index > this.count) {
            return null;
        }
        int pos = (this.head + index - 1) % this.names.length;
        return this.names[pos];
    }

    public String getValue(int index) {
        if (index < 1 || index > this.count) {
            return null;
        }
        int pos = (this.head + index - 1) % this.values.length;
        return this.values[pos];
    }

    public void add(String name, String value) {
        int entrySize = HpackDynamicTable.entrySize(name, value);
        if (entrySize > this.maxSize) {
            this.clear();
            return;
        }
        while (this.currentSize + entrySize > this.maxSize && this.count > 0) {
            this.evictOne();
        }
        this.ensureCapacity(this.count + 1);
        this.head = (this.head - 1 + this.names.length) % this.names.length;
        this.names[this.head] = name;
        this.values[this.head] = value;
        ++this.count;
        this.currentSize += entrySize;
    }

    public void setMaxSize(int newMaxSize) {
        this.maxSize = newMaxSize;
        while (this.currentSize > this.maxSize && this.count > 0) {
            this.evictOne();
        }
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public int getCurrentSize() {
        return this.currentSize;
    }

    public int size() {
        return this.count;
    }

    public void clear() {
        for (int i = 0; i < this.names.length; ++i) {
            this.names[i] = null;
            this.values[i] = null;
        }
        this.head = 0;
        this.count = 0;
        this.currentSize = 0;
    }

    public int findIndex(String name, String value) {
        for (int i = 0; i < this.count; ++i) {
            int pos = (this.head + i) % this.names.length;
            if (!this.names[pos].equals(name) || !this.values[pos].equals(value)) continue;
            return i + 1;
        }
        return -1;
    }

    public int findNameIndex(String name) {
        for (int i = 0; i < this.count; ++i) {
            int pos = (this.head + i) % this.names.length;
            if (!this.names[pos].equals(name)) continue;
            return i + 1;
        }
        return -1;
    }

    private static int entrySize(String name, String value) {
        return name.length() + value.length() + 32;
    }

    private void evictOne() {
        if (this.count == 0) {
            return;
        }
        int tail = (this.head + this.count - 1) % this.names.length;
        int entrySize = HpackDynamicTable.entrySize(this.names[tail], this.values[tail]);
        this.names[tail] = null;
        this.values[tail] = null;
        --this.count;
        this.currentSize -= entrySize;
    }

    private void ensureCapacity(int needed) {
        int newSize;
        if (needed <= this.names.length) {
            return;
        }
        for (newSize = this.names.length * 2; newSize < needed; newSize *= 2) {
        }
        String[] newNames = new String[newSize];
        String[] newValues = new String[newSize];
        for (int i = 0; i < this.count; ++i) {
            int oldPos = (this.head + i) % this.names.length;
            newNames[i] = this.names[oldPos];
            newValues[i] = this.values[oldPos];
        }
        this.names = newNames;
        this.values = newValues;
        this.head = 0;
    }
}

