/*
 * Decompiled with CFR 0.152.
 */
package zeph.http2.hpack;

import java.util.ArrayList;
import java.util.List;
import zeph.http2.hpack.HpackDynamicTable;
import zeph.http2.hpack.HpackHuffman;
import zeph.http2.hpack.HpackStaticTable;

public class HpackDecoder {
    private final HpackDynamicTable dynamicTable;
    private final int maxHeaderListSize;

    public HpackDecoder() {
        this(4096, 8192);
    }

    public HpackDecoder(int maxTableSize, int maxHeaderListSize) {
        this.dynamicTable = new HpackDynamicTable(maxTableSize);
        this.maxHeaderListSize = maxHeaderListSize;
    }

    public List<String[]> decode(byte[] data) throws HpackException {
        return this.decode(data, 0, data.length);
    }

    public List<String[]> decode(byte[] data, int offset, int length) throws HpackException {
        ArrayList<String[]> headers = new ArrayList<String[]>();
        int pos = offset;
        int end = offset + length;
        int headerListSize = 0;
        while (pos < end) {
            String value;
            String name;
            int b = data[pos] & 0xFF;
            boolean addToTable = false;
            if ((b & 0x80) != 0) {
                result = this.decodeInteger(data, pos, end, 7);
                index = result[0];
                pos = result[1];
                if (index == 0) {
                    throw new HpackException("Invalid index 0 in indexed header field");
                }
                entry = this.getEntry(index);
                if (entry == null) {
                    throw new HpackException("Invalid index " + index);
                }
                name = entry[0];
                value = entry[1];
            } else if ((b & 0xC0) == 64) {
                indexResult = this.decodeInteger(data, pos, end, 6);
                index = indexResult[0];
                pos = indexResult[1];
                if (index == 0) {
                    nameResult = this.decodeString(data, pos, end);
                    name = nameResult[0];
                    pos = Integer.parseInt(nameResult[1]);
                } else {
                    entry = this.getEntry(index);
                    if (entry == null) {
                        throw new HpackException("Invalid index " + index);
                    }
                    name = entry[0];
                }
                valueResult = this.decodeString(data, pos, end);
                value = valueResult[0];
                pos = Integer.parseInt(valueResult[1]);
                addToTable = true;
            } else if ((b & 0xF0) == 0) {
                indexResult = this.decodeInteger(data, pos, end, 4);
                index = indexResult[0];
                pos = indexResult[1];
                if (index == 0) {
                    nameResult = this.decodeString(data, pos, end);
                    name = nameResult[0];
                    pos = Integer.parseInt(nameResult[1]);
                } else {
                    entry = this.getEntry(index);
                    if (entry == null) {
                        throw new HpackException("Invalid index " + index);
                    }
                    name = entry[0];
                }
                valueResult = this.decodeString(data, pos, end);
                value = valueResult[0];
                pos = Integer.parseInt(valueResult[1]);
            } else if ((b & 0xF0) == 16) {
                indexResult = this.decodeInteger(data, pos, end, 4);
                index = indexResult[0];
                pos = indexResult[1];
                if (index == 0) {
                    nameResult = this.decodeString(data, pos, end);
                    name = nameResult[0];
                    pos = Integer.parseInt(nameResult[1]);
                } else {
                    entry = this.getEntry(index);
                    if (entry == null) {
                        throw new HpackException("Invalid index " + index);
                    }
                    name = entry[0];
                }
                valueResult = this.decodeString(data, pos, end);
                value = valueResult[0];
                pos = Integer.parseInt(valueResult[1]);
            } else {
                if ((b & 0xE0) == 32) {
                    result = this.decodeInteger(data, pos, end, 5);
                    int newSize = result[0];
                    pos = result[1];
                    this.dynamicTable.setMaxSize(newSize);
                    continue;
                }
                throw new HpackException("Invalid HPACK encoding at position " + pos);
            }
            if ((headerListSize += name.length() + value.length() + 32) > this.maxHeaderListSize) {
                throw new HpackException("Header list size exceeds limit");
            }
            headers.add(new String[]{name, value});
            if (!addToTable) continue;
            this.dynamicTable.add(name, value);
        }
        return headers;
    }

    private String[] getEntry(int index) {
        if (index <= 61) {
            return HpackStaticTable.getEntry(index);
        }
        int dynamicIndex = index - 61;
        return this.dynamicTable.getEntry(dynamicIndex);
    }

    private int[] decodeInteger(byte[] data, int pos, int end, int prefixBits) throws HpackException {
        int value;
        if (pos >= end) {
            throw new HpackException("Unexpected end of data");
        }
        int mask = (1 << prefixBits) - 1;
        if ((value = data[pos++] & mask) < mask) {
            return new int[]{value, pos};
        }
        int shift = 0;
        while (pos < end) {
            int b = data[pos++] & 0xFF;
            value += (b & 0x7F) << shift;
            if ((b & 0x80) == 0) {
                return new int[]{value, pos};
            }
            if ((shift += 7) <= 28) continue;
            throw new HpackException("Integer overflow");
        }
        throw new HpackException("Unexpected end of integer");
    }

    private String[] decodeString(byte[] data, int pos, int end) throws HpackException {
        int length;
        if (pos >= end) {
            throw new HpackException("Unexpected end of data");
        }
        boolean huffman = (data[pos] & 0x80) != 0;
        int[] lengthResult = this.decodeInteger(data, pos, end, 7);
        if ((pos = lengthResult[1]) + (length = lengthResult[0]) > end) {
            throw new HpackException("String length exceeds data");
        }
        String value = huffman ? HpackHuffman.decode(data, pos, length) : new String(data, pos, length);
        return new String[]{value, String.valueOf(pos + length)};
    }

    public void setMaxTableSize(int maxSize) {
        this.dynamicTable.setMaxSize(maxSize);
    }

    public HpackDynamicTable getDynamicTable() {
        return this.dynamicTable;
    }

    public static class HpackException
    extends Exception {
        public HpackException(String message) {
            super(message);
        }
    }
}

