/*
 * Decompiled with CFR 0.152.
 */
package zeph.http2;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import zeph.http.StreamingBodyInputStream;
import zeph.http2.Http2FrameReader;

public class Http2Stream {
    private final int streamId;
    private State state;
    private final AtomicInteger sendWindow = new AtomicInteger();
    private final AtomicInteger recvWindow = new AtomicInteger();
    private final AtomicInteger consumedRecvWindow = new AtomicInteger(0);
    private List<String[]> requestHeaders;
    private ByteArrayOutputStream requestBody;
    private boolean requestComplete;
    private boolean streamingMode = false;
    private StreamingBodyInputStream streamingBody;
    private List<String[]> responseHeaders;
    private ByteArrayOutputStream responseBody;
    private boolean responseComplete;
    private int errorCode;

    public Http2Stream(int streamId, int initialWindowSize) {
        this.streamId = streamId;
        this.state = State.IDLE;
        this.sendWindow.set(initialWindowSize);
        this.recvWindow.set(initialWindowSize);
        this.requestHeaders = new ArrayList<String[]>();
        this.requestBody = new ByteArrayOutputStream();
        this.responseHeaders = new ArrayList<String[]>();
        this.responseBody = new ByteArrayOutputStream();
    }

    public int getStreamId() {
        return this.streamId;
    }

    public State getState() {
        return this.state;
    }

    public boolean isOpen() {
        return this.state == State.OPEN || this.state == State.HALF_CLOSED_LOCAL || this.state == State.HALF_CLOSED_REMOTE;
    }

    public boolean isClosed() {
        return this.state == State.CLOSED;
    }

    public void sendHeaders(boolean endStream) throws Http2FrameReader.Http2Exception {
        switch (this.state) {
            case IDLE: {
                this.state = endStream ? State.HALF_CLOSED_LOCAL : State.OPEN;
                break;
            }
            case RESERVED_LOCAL: {
                this.state = endStream ? State.CLOSED : State.HALF_CLOSED_REMOTE;
                break;
            }
            case HALF_CLOSED_REMOTE: {
                if (!endStream) break;
                this.state = State.CLOSED;
                break;
            }
            case OPEN: {
                if (!endStream) break;
                this.state = State.HALF_CLOSED_LOCAL;
                break;
            }
            default: {
                throw new Http2FrameReader.Http2Exception(1, this.streamId, "Cannot send HEADERS in state " + String.valueOf((Object)this.state));
            }
        }
    }

    public void recvHeaders(boolean endStream) throws Http2FrameReader.Http2Exception {
        switch (this.state) {
            case IDLE: {
                this.state = endStream ? State.HALF_CLOSED_REMOTE : State.OPEN;
                break;
            }
            case RESERVED_REMOTE: {
                this.state = endStream ? State.CLOSED : State.HALF_CLOSED_LOCAL;
                break;
            }
            case HALF_CLOSED_LOCAL: {
                if (!endStream) break;
                this.state = State.CLOSED;
                break;
            }
            default: {
                throw new Http2FrameReader.Http2Exception(1, this.streamId, "Cannot receive HEADERS in state " + String.valueOf((Object)this.state));
            }
        }
    }

    public void sendData(boolean endStream) throws Http2FrameReader.Http2Exception {
        switch (this.state) {
            case OPEN: {
                if (!endStream) break;
                this.state = State.HALF_CLOSED_LOCAL;
                break;
            }
            case HALF_CLOSED_REMOTE: {
                if (!endStream) break;
                this.state = State.CLOSED;
                break;
            }
            default: {
                throw new Http2FrameReader.Http2Exception(1, this.streamId, "Cannot send DATA in state " + String.valueOf((Object)this.state));
            }
        }
    }

    public void recvData(boolean endStream) throws Http2FrameReader.Http2Exception {
        switch (this.state) {
            case OPEN: {
                if (!endStream) break;
                this.state = State.HALF_CLOSED_REMOTE;
                break;
            }
            case HALF_CLOSED_LOCAL: {
                if (!endStream) break;
                this.state = State.CLOSED;
                break;
            }
            default: {
                throw new Http2FrameReader.Http2Exception(5, this.streamId, "Cannot receive DATA in state " + String.valueOf((Object)this.state));
            }
        }
    }

    public void reset(int errorCode) {
        this.state = State.CLOSED;
        this.errorCode = errorCode;
    }

    public int getSendWindow() {
        return this.sendWindow.get();
    }

    public int getRecvWindow() {
        return this.recvWindow.get();
    }

    public void updateSendWindow(int delta) {
        this.sendWindow.addAndGet(delta);
    }

    public void updateRecvWindow(int delta) {
        this.recvWindow.addAndGet(delta);
    }

    public void consumeSendWindow(int bytes) {
        this.sendWindow.addAndGet(-bytes);
    }

    public void consumeRecvWindow(int bytes) {
        this.recvWindow.addAndGet(-bytes);
    }

    public void addConsumedRecvWindow(int bytes) {
        this.consumedRecvWindow.addAndGet(bytes);
    }

    public int getConsumedRecvWindow() {
        return this.consumedRecvWindow.get();
    }

    public void resetConsumedRecvWindow() {
        this.consumedRecvWindow.set(0);
    }

    public void addRequestHeader(String name, String value) {
        this.requestHeaders.add(new String[]{name, value});
    }

    public void addRequestHeaders(List<String[]> headers) {
        this.requestHeaders.addAll(headers);
    }

    public List<String[]> getRequestHeaders() {
        return this.requestHeaders;
    }

    public void appendRequestBody(byte[] data) {
        if (this.streamingMode && this.streamingBody != null) {
            this.streamingBody.feedData(data);
        } else {
            this.requestBody.writeBytes(data);
        }
    }

    public void appendRequestBody(byte[] data, int offset, int length) {
        if (this.streamingMode && this.streamingBody != null) {
            byte[] chunk = new byte[length];
            System.arraycopy(data, offset, chunk, 0, length);
            this.streamingBody.feedData(chunk);
        } else {
            this.requestBody.write(data, offset, length);
        }
    }

    public byte[] getRequestBody() {
        return this.requestBody.toByteArray();
    }

    public void setStreamingMode(boolean streaming) {
        this.streamingMode = streaming;
        if (streaming && this.streamingBody == null) {
            this.streamingBody = new StreamingBodyInputStream(-1L);
        }
    }

    public void setStreamingMode(boolean streaming, long contentLength) {
        this.streamingMode = streaming;
        if (streaming && this.streamingBody == null) {
            this.streamingBody = new StreamingBodyInputStream(contentLength);
        }
    }

    public boolean isStreamingMode() {
        return this.streamingMode;
    }

    public InputStream getStreamingBodyInputStream() {
        return this.streamingBody;
    }

    public void markBodyComplete() {
        if (this.streamingMode && this.streamingBody != null) {
            this.streamingBody.complete();
        }
    }

    public void setRequestComplete(boolean complete) {
        this.requestComplete = complete;
    }

    public boolean isRequestComplete() {
        return this.requestComplete;
    }

    public void addResponseHeader(String name, String value) {
        this.responseHeaders.add(new String[]{name, value});
    }

    public List<String[]> getResponseHeaders() {
        return this.responseHeaders;
    }

    public void appendResponseBody(byte[] data) {
        this.responseBody.writeBytes(data);
    }

    public byte[] getResponseBody() {
        return this.responseBody.toByteArray();
    }

    public void setResponseComplete(boolean complete) {
        this.responseComplete = complete;
    }

    public boolean isResponseComplete() {
        return this.responseComplete;
    }

    public String getMethod() {
        for (String[] h : this.requestHeaders) {
            if (!":method".equals(h[0])) continue;
            return h[1];
        }
        return null;
    }

    public String getPath() {
        for (String[] h : this.requestHeaders) {
            if (!":path".equals(h[0])) continue;
            return h[1];
        }
        return null;
    }

    public String getScheme() {
        for (String[] h : this.requestHeaders) {
            if (!":scheme".equals(h[0])) continue;
            return h[1];
        }
        return null;
    }

    public String getAuthority() {
        for (String[] h : this.requestHeaders) {
            if (!":authority".equals(h[0])) continue;
            return h[1];
        }
        return null;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String toString() {
        return "Http2Stream{id=" + this.streamId + ", state=" + String.valueOf((Object)this.state) + "}";
    }

    public static enum State {
        IDLE,
        RESERVED_LOCAL,
        RESERVED_REMOTE,
        OPEN,
        HALF_CLOSED_LOCAL,
        HALF_CLOSED_REMOTE,
        CLOSED;

    }
}

