/*
 * Decompiled with CFR 0.152.
 */
package zeph.http2;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import zeph.http.HttpRequest;
import zeph.http.HttpResponse;
import zeph.http.ProtocolHandler;
import zeph.http2.Http2Connection;
import zeph.http2.Http2Frame;
import zeph.http2.Http2FrameReader;
import zeph.http2.Http2Settings;
import zeph.http2.Http2Stream;
import zeph.logging.Logger;

public class Http2ServerHandler
implements Http2Connection.StreamHandler,
ProtocolHandler {
    private static final Logger log = new Logger(Http2ServerHandler.class);
    private final Http2Connection connection;
    private final Function<HttpRequest, HttpResponse> handler;
    private final int serverPort;
    private final boolean secure;
    private final boolean streamingMode;
    private final ExecutorService handlerExecutor;
    private ByteBuffer accumulationBuffer;
    private final Map<Integer, Future<HttpResponse>> streamingHandlers = new ConcurrentHashMap<Integer, Future<HttpResponse>>();
    private final List<PendingResponse> pendingResponses = new ArrayList<PendingResponse>();
    private Runnable handlerCompletionCallback;
    private final List<StreamingResponse> pendingStreamingResponses = new ArrayList<StreamingResponse>();
    private final Map<Integer, StreamingResponse> activeStreamingResponses = new ConcurrentHashMap<Integer, StreamingResponse>();
    private boolean upgradeRequestHasBody = false;
    private boolean upgradeBodyAlreadyHandled = false;
    private final Http2Connection.StreamHandler streamHandler = this;

    public Http2ServerHandler(Function<HttpRequest, HttpResponse> handler, int serverPort, boolean secure) {
        this(handler, serverPort, secure, true);
    }

    public Http2ServerHandler(Function<HttpRequest, HttpResponse> handler, int serverPort, boolean secure, boolean streamingMode) {
        Http2Settings settings = new Http2Settings();
        settings.setInitialWindowSize(0x1000000);
        this.connection = new Http2Connection(settings);
        this.connection.setStreamHandler(this);
        this.handler = handler;
        this.serverPort = serverPort;
        this.secure = secure;
        this.streamingMode = streamingMode;
        this.handlerExecutor = streamingMode ? Executors.newFixedThreadPool(Math.max(4, Runtime.getRuntime().availableProcessors()), r -> {
            Thread t = new Thread(r, "zeph-h2-handler");
            t.setDaemon(true);
            return t;
        }) : null;
    }

    public Http2Connection getConnection() {
        return this.connection;
    }

    public void setHandlerCompletionCallback(Runnable callback) {
        this.handlerCompletionCallback = callback;
    }

    public void setUpgradeBodyAlreadyHandled() {
        this.upgradeBodyAlreadyHandled = true;
    }

    public void setupUpgradeStream(HttpRequest http1Request) {
        String contentLength;
        ArrayList<String[]> headers = new ArrayList<String[]>();
        headers.add(new String[]{":method", http1Request.getMethod().name()});
        headers.add(new String[]{":path", http1Request.getPath() + (String)(http1Request.getQueryString() != null ? "?" + http1Request.getQueryString() : "")});
        headers.add(new String[]{":scheme", this.secure ? "https" : "http"});
        String host = http1Request.getHeader("host");
        if (host != null) {
            headers.add(new String[]{":authority", host});
        }
        this.upgradeRequestHasBody = (contentLength = http1Request.getHeader("content-length")) != null && !contentLength.equals("0");
        for (Map.Entry<String, String> entry : http1Request.getHeaders().entrySet()) {
            String name = entry.getKey().toLowerCase();
            if (name.equals("connection") || name.equals("upgrade") || name.equals("http2-settings") || name.equals("host") || name.equals("keep-alive") || name.equals("transfer-encoding")) continue;
            headers.add(new String[]{name, entry.getValue()});
        }
        this.connection.createUpgradeStream(headers, this.upgradeRequestHasBody);
    }

    private void processUpgradeStream() {
        Http2Stream stream = this.connection.getUpgradeStream();
        if (stream == null || this.streamHandler == null) {
            return;
        }
        if (this.upgradeBodyAlreadyHandled) {
            return;
        }
        if (this.upgradeRequestHasBody) {
            if (this.streamingMode && this.handlerExecutor != null) {
                this.onHeadersComplete(stream);
            }
        } else if (stream.isRequestComplete()) {
            this.onRequest(stream);
        }
    }

    public byte[] processData(byte[] data) throws Http2FrameReader.Http2Exception {
        Http2Frame frame;
        ByteBuffer input;
        if (this.accumulationBuffer != null && this.accumulationBuffer.hasRemaining()) {
            int remaining = this.accumulationBuffer.remaining();
            ByteBuffer combined = ByteBuffer.allocate(remaining + data.length);
            combined.put(this.accumulationBuffer);
            combined.put(data);
            combined.flip();
            input = combined;
            this.accumulationBuffer = null;
        } else {
            input = ByteBuffer.wrap(data);
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(65536);
        boolean wasAwaitingPreface = this.connection.getState() == Http2Connection.State.AWAITING_PREFACE;
        boolean isPriorKnowledge = false;
        if (wasAwaitingPreface) {
            if (!this.connection.processPreface(input)) {
                if (input.hasRemaining()) {
                    this.accumulationBuffer = ByteBuffer.allocate(input.remaining());
                    this.accumulationBuffer.put(input);
                    this.accumulationBuffer.flip();
                }
                return null;
            }
            if (this.connection.getUpgradeStream() == null) {
                isPriorKnowledge = true;
                ByteBuffer temp = ByteBuffer.allocate(128);
                this.connection.writeServerPreface(temp);
                temp.flip();
                byte[] preface = new byte[temp.remaining()];
                temp.get(preface);
                outputStream.write(preface, 0, preface.length);
                if (input.hasRemaining()) {
                    this.accumulationBuffer = ByteBuffer.allocate(input.remaining());
                    this.accumulationBuffer.put(input);
                    this.accumulationBuffer.flip();
                }
                return preface;
            }
        }
        Http2FrameReader frameReader = this.connection.getFrameReader();
        while (input.hasRemaining() && (frame = frameReader.readFrame(input)) != null) {
            Http2Connection.State prevState = this.connection.getState();
            List<Http2Frame> responses = this.connection.processFrame(frame);
            for (Http2Frame resp : responses) {
                byte[] encoded = resp.encode();
                outputStream.write(encoded, 0, encoded.length);
            }
            if (prevState != Http2Connection.State.AWAITING_SETTINGS || this.connection.getState() != Http2Connection.State.OPEN) continue;
            this.processUpgradeStream();
        }
        if (input.hasRemaining()) {
            this.accumulationBuffer = ByteBuffer.allocate(input.remaining());
            this.accumulationBuffer.put(input);
            this.accumulationBuffer.flip();
        }
        this.writePendingResponses(outputStream);
        byte[] result = outputStream.toByteArray();
        return (byte[])(result.length > 0 ? result : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRequest(Http2Stream stream) {
        boolean hasContentLength;
        InputStream bodyStream;
        HttpResponse response;
        HttpRequest request = this.streamToRequest(stream);
        try {
            response = this.handler.apply(request);
        }
        catch (Exception e) {
            response = HttpResponse.serverError();
        }
        ArrayList<String[]> responseHeaders = new ArrayList<String[]>();
        responseHeaders.add(new String[]{":status", String.valueOf(response.getStatus())});
        Map<String, String> headers = response.getHeaders();
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            String name = entry.getKey().toLowerCase();
            if (name.equals("connection") || name.equals("transfer-encoding") || name.equals("keep-alive")) continue;
            responseHeaders.add(new String[]{name, entry.getValue()});
        }
        if (response.isStreaming() && (bodyStream = response.getBodyStream()) != null) {
            long contentLength = response.getContentLength();
            if (contentLength >= 0L) {
                responseHeaders.add(new String[]{"content-length", String.valueOf(contentLength)});
            }
            int bufferSize = this.connection.getRemoteSettings().getMaxFrameSize();
            List<StreamingResponse> list = this.pendingStreamingResponses;
            synchronized (list) {
                this.pendingStreamingResponses.add(new StreamingResponse(stream.getStreamId(), responseHeaders, bodyStream, bufferSize));
            }
            return;
        }
        byte[] body = response.getBodyBytes();
        if (body != null && body.length > 0 && !(hasContentLength = headers.keySet().stream().anyMatch(k -> k.equalsIgnoreCase("content-length")))) {
            responseHeaders.add(new String[]{"content-length", String.valueOf(body.length)});
        }
        List<PendingResponse> list = this.pendingResponses;
        synchronized (list) {
            this.pendingResponses.add(new PendingResponse(stream.getStreamId(), responseHeaders, body));
        }
    }

    @Override
    public boolean onHeadersComplete(Http2Stream stream) {
        if (!this.streamingMode || this.handlerExecutor == null) {
            return false;
        }
        stream.setStreamingMode(true);
        int streamId = stream.getStreamId();
        CompletionStage future = CompletableFuture.supplyAsync(() -> {
            HttpRequest request = this.streamToRequest(stream);
            try {
                return this.handler.apply(request);
            }
            catch (Exception e) {
                return HttpResponse.serverError();
            }
        }, this.handlerExecutor).whenComplete((result, error) -> {
            if (this.handlerCompletionCallback != null) {
                this.handlerCompletionCallback.run();
            }
        });
        this.streamingHandlers.put(streamId, (Future<HttpResponse>)((Object)future));
        return true;
    }

    @Override
    public void onBodyComplete(Http2Stream stream) {
    }

    public void checkCompletedStreamingHandlers() {
        Iterator<Map.Entry<Integer, Future<HttpResponse>>> iter = this.streamingHandlers.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Integer, Future<HttpResponse>> entry = iter.next();
            int streamId = entry.getKey();
            Future<HttpResponse> future = entry.getValue();
            if (!future.isDone()) continue;
            iter.remove();
            try {
                HttpResponse response = future.get();
                this.queueResponse(streamId, response);
            }
            catch (Exception e) {
                this.queueResponse(streamId, HttpResponse.serverError());
            }
        }
    }

    public void queueUpgradeResponse(HttpResponse response) {
        this.queueResponse(1, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueResponse(int streamId, HttpResponse response) {
        boolean hasContentLength;
        InputStream bodyStream;
        ArrayList<String[]> responseHeaders = new ArrayList<String[]>();
        responseHeaders.add(new String[]{":status", String.valueOf(response.getStatus())});
        Map<String, String> headers = response.getHeaders();
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            String name = entry.getKey().toLowerCase();
            if (name.equals("connection") || name.equals("transfer-encoding") || name.equals("keep-alive")) continue;
            responseHeaders.add(new String[]{name, entry.getValue()});
        }
        if (response.isStreaming() && (bodyStream = response.getBodyStream()) != null) {
            long contentLength = response.getContentLength();
            if (contentLength >= 0L) {
                responseHeaders.add(new String[]{"content-length", String.valueOf(contentLength)});
            }
            int bufferSize = this.connection.getRemoteSettings().getMaxFrameSize();
            List<StreamingResponse> list = this.pendingStreamingResponses;
            synchronized (list) {
                this.pendingStreamingResponses.add(new StreamingResponse(streamId, responseHeaders, bodyStream, bufferSize));
            }
            return;
        }
        byte[] body = response.getBodyBytes();
        if (body != null && body.length > 0 && !(hasContentLength = headers.keySet().stream().anyMatch(k -> k.equalsIgnoreCase("content-length")))) {
            responseHeaders.add(new String[]{"content-length", String.valueOf(body.length)});
        }
        List<PendingResponse> list = this.pendingResponses;
        synchronized (list) {
            this.pendingResponses.add(new PendingResponse(streamId, responseHeaders, body));
        }
    }

    public boolean hasPendingStreamingHandlers() {
        return !this.streamingHandlers.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasPendingResponses() {
        List<Object> list = this.pendingResponses;
        synchronized (list) {
            if (!this.pendingResponses.isEmpty()) {
                return true;
            }
        }
        list = this.pendingStreamingResponses;
        synchronized (list) {
            if (!this.pendingStreamingResponses.isEmpty()) {
                return true;
            }
        }
        return !this.activeStreamingResponses.isEmpty();
    }

    public boolean hasAccumulatedData() {
        return this.accumulationBuffer != null && this.accumulationBuffer.hasRemaining();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writePendingResponses(ByteArrayOutputStream outputStream) {
        List<Object> list = this.pendingResponses;
        synchronized (list) {
            for (PendingResponse resp : this.pendingResponses) {
                try {
                    boolean hasBody = resp.body != null && resp.body.length > 0;
                    ByteBuffer headerBuf = ByteBuffer.allocate(16384);
                    this.connection.writeResponseHeaders(headerBuf, resp.streamId, resp.headers, !hasBody);
                    headerBuf.flip();
                    outputStream.write(headerBuf.array(), 0, headerBuf.limit());
                    if (!hasBody) continue;
                    this.writeDataFrames(outputStream, resp.streamId, resp.body, true);
                }
                catch (Http2FrameReader.Http2Exception e) {
                    this.writeRstStreamToOutput(outputStream, resp.streamId, e.getErrorCode());
                }
            }
            this.pendingResponses.clear();
        }
        list = this.pendingStreamingResponses;
        synchronized (list) {
            while (!this.pendingStreamingResponses.isEmpty()) {
                StreamingResponse sr = this.pendingStreamingResponses.remove(0);
                log.trace("H2 streaming: starting stream " + sr.streamId + ", buffer size=" + sr.buffer.length);
                try {
                    ByteBuffer headerBuf = ByteBuffer.allocate(16384);
                    this.connection.writeResponseHeaders(headerBuf, sr.streamId, sr.headers, false);
                    headerBuf.flip();
                    outputStream.write(headerBuf.array(), 0, headerBuf.limit());
                    sr.headersSent = true;
                    log.trace("H2 streaming: headers sent for stream " + sr.streamId);
                    sr.currentRead = sr.stream.read(sr.buffer);
                    log.trace("H2 streaming: first read=" + sr.currentRead);
                    if (sr.currentRead <= 0) {
                        ByteBuffer frameBuf = ByteBuffer.allocate(9);
                        this.connection.writeResponseData(frameBuf, sr.streamId, new byte[0], true);
                        frameBuf.flip();
                        outputStream.write(frameBuf.array(), 0, frameBuf.limit());
                        sr.close();
                        continue;
                    }
                    int nextRead = sr.stream.read(sr.nextBuffer);
                    sr.isLast = nextRead <= 0;
                    byte[] chunk = sr.currentRead == sr.buffer.length ? sr.buffer : Arrays.copyOf(sr.buffer, sr.currentRead);
                    int available = this.connection.getAvailableSendWindow(sr.streamId);
                    log.trace("H2 streaming: chunk.length=" + chunk.length + ", available window=" + available);
                    if (available >= chunk.length) {
                        ByteBuffer frameBuf = ByteBuffer.allocate(chunk.length + 9);
                        this.connection.writeResponseData(frameBuf, sr.streamId, chunk, sr.isLast);
                        frameBuf.flip();
                        outputStream.write(frameBuf.array(), 0, frameBuf.limit());
                        log.trace("H2 streaming: DATA frame written, " + frameBuf.limit() + " bytes, isLast=" + sr.isLast);
                        if (sr.isLast) {
                            sr.close();
                            log.trace("H2 streaming: stream " + sr.streamId + " complete");
                            continue;
                        }
                        byte[] temp = sr.buffer;
                        sr.buffer = sr.nextBuffer;
                        sr.nextBuffer = temp;
                        sr.currentRead = nextRead;
                        this.activeStreamingResponses.put(sr.streamId, sr);
                        log.trace("H2 streaming: stream " + sr.streamId + " added to active, currentRead=" + sr.currentRead);
                        continue;
                    }
                    sr.pendingData = chunk;
                    sr.waitingForWindow = true;
                    byte[] temp = sr.buffer;
                    sr.buffer = sr.nextBuffer;
                    sr.nextBuffer = temp;
                    sr.currentRead = nextRead;
                    this.activeStreamingResponses.put(sr.streamId, sr);
                }
                catch (Exception e) {
                    log.error("HTTP/2 streaming error: " + e.getMessage(), e);
                    this.writeRstStreamToOutput(outputStream, sr.streamId, 2);
                    sr.close();
                }
            }
            return;
        }
    }

    @Override
    public boolean hasPendingStreaming() {
        return !this.activeStreamingResponses.isEmpty();
    }

    public boolean isWaitingForWindow() {
        for (StreamingResponse sr : this.activeStreamingResponses.values()) {
            if (!sr.waitingForWindow) continue;
            return true;
        }
        return false;
    }

    @Override
    public byte[] continueStreaming() {
        if (this.activeStreamingResponses.isEmpty()) {
            return null;
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(65536);
        ArrayList<Integer> completedStreams = new ArrayList<Integer>();
        for (StreamingResponse sr : this.activeStreamingResponses.values()) {
            try {
                int available = this.connection.getAvailableSendWindow(sr.streamId);
                if (sr.pendingData != null) {
                    if (available < sr.pendingData.length) continue;
                    ByteBuffer frameBuf = ByteBuffer.allocate(sr.pendingData.length + 9);
                    this.connection.writeResponseData(frameBuf, sr.streamId, sr.pendingData, sr.isLast);
                    frameBuf.flip();
                    outputStream.write(frameBuf.array(), 0, frameBuf.limit());
                    sr.pendingData = null;
                    sr.waitingForWindow = false;
                    if (sr.isLast) {
                        sr.close();
                        completedStreams.add(sr.streamId);
                        continue;
                    }
                }
                if (sr.waitingForWindow) continue;
                int nextRead = sr.stream.read(sr.nextBuffer);
                sr.isLast = nextRead <= 0;
                byte[] chunk = sr.currentRead == sr.buffer.length ? sr.buffer : Arrays.copyOf(sr.buffer, sr.currentRead);
                available = this.connection.getAvailableSendWindow(sr.streamId);
                if (available >= chunk.length) {
                    ByteBuffer frameBuf = ByteBuffer.allocate(chunk.length + 9);
                    this.connection.writeResponseData(frameBuf, sr.streamId, chunk, sr.isLast);
                    frameBuf.flip();
                    outputStream.write(frameBuf.array(), 0, frameBuf.limit());
                    if (sr.isLast) {
                        sr.close();
                        completedStreams.add(sr.streamId);
                        continue;
                    }
                    byte[] temp = sr.buffer;
                    sr.buffer = sr.nextBuffer;
                    sr.nextBuffer = temp;
                    sr.currentRead = nextRead;
                    continue;
                }
                sr.pendingData = chunk;
                sr.waitingForWindow = true;
                byte[] temp = sr.buffer;
                sr.buffer = sr.nextBuffer;
                sr.nextBuffer = temp;
                sr.currentRead = nextRead;
            }
            catch (Exception e) {
                log.error("HTTP/2 streaming error on stream " + sr.streamId + ": " + e.getMessage(), e);
                sr.close();
                completedStreams.add(sr.streamId);
                this.writeRstStreamToOutput(outputStream, sr.streamId, 2);
            }
        }
        for (Integer streamId : completedStreams) {
            this.activeStreamingResponses.remove(streamId);
        }
        byte[] result = outputStream.toByteArray();
        return (byte[])(result.length > 0 ? result : null);
    }

    private void startStreamingResponse(ByteArrayOutputStream outputStream, StreamingResponse sr) {
        try {
            ByteBuffer headerBuf = ByteBuffer.allocate(16384);
            this.connection.writeResponseHeaders(headerBuf, sr.streamId, sr.headers, false);
            headerBuf.flip();
            outputStream.write(headerBuf.array(), 0, headerBuf.limit());
            sr.headersSent = true;
            sr.currentRead = sr.stream.read(sr.buffer);
            if (sr.currentRead <= 0) {
                ByteBuffer frameBuf = ByteBuffer.allocate(9);
                this.connection.writeResponseData(frameBuf, sr.streamId, new byte[0], true);
                frameBuf.flip();
                outputStream.write(frameBuf.array(), 0, frameBuf.limit());
                sr.close();
            } else {
                int nextRead = sr.stream.read(sr.nextBuffer);
                sr.isLast = nextRead <= 0;
                byte[] temp = sr.buffer;
                sr.buffer = sr.nextBuffer;
                sr.nextBuffer = temp;
                sr.currentRead = nextRead;
                this.activeStreamingResponses.put(sr.streamId, sr);
            }
        }
        catch (Exception e) {
            log.error("HTTP/2 streaming error: " + e.getMessage(), e);
            this.writeRstStreamToOutput(outputStream, sr.streamId, 2);
            sr.close();
        }
    }

    @Override
    public void onWindowAvailable(int streamId) {
        StreamingResponse sr = this.activeStreamingResponses.get(streamId);
        if (sr != null && sr.waitingForWindow) {
            sr.waitingForWindow = false;
            log.trace("Window available for stream " + streamId + ", cleared waitingForWindow flag");
        }
    }

    public boolean hasStreamingWaitingForWindow() {
        for (StreamingResponse sr : this.activeStreamingResponses.values()) {
            if (!sr.waitingForWindow) continue;
            return true;
        }
        return false;
    }

    private void writeRstStreamToOutput(ByteArrayOutputStream outputStream, int streamId, int errorCode) {
        ByteBuffer rstBuf = ByteBuffer.allocate(32);
        this.connection.writeRstStream(rstBuf, streamId, errorCode);
        rstBuf.flip();
        outputStream.write(rstBuf.array(), 0, rstBuf.limit());
    }

    private void writeDataFrames(ByteArrayOutputStream outputStream, int streamId, byte[] body, boolean endStream) throws Http2FrameReader.Http2Exception {
        int chunkSize;
        int maxFrameSize = this.connection.getRemoteSettings().getMaxFrameSize();
        for (int offset = 0; offset < body.length; offset += chunkSize) {
            byte[] chunk;
            boolean isLast;
            chunkSize = Math.min(maxFrameSize, body.length - offset);
            boolean bl = isLast = offset + chunkSize >= body.length;
            if (offset == 0 && chunkSize == body.length) {
                chunk = body;
            } else {
                chunk = new byte[chunkSize];
                System.arraycopy(body, offset, chunk, 0, chunkSize);
            }
            ByteBuffer frameBuf = ByteBuffer.allocate(chunkSize + 9);
            this.connection.writeResponseData(frameBuf, streamId, chunk, isLast && endStream);
            frameBuf.flip();
            outputStream.write(frameBuf.array(), 0, frameBuf.limit());
        }
    }

    private HttpRequest streamToRequest(Http2Stream stream) {
        HttpRequest request = new HttpRequest();
        String method = null;
        String path = null;
        String scheme = null;
        String authority = null;
        HashMap<String, String> headers = new HashMap<String, String>();
        for (String[] header : stream.getRequestHeaders()) {
            String name = header[0];
            String value = header[1];
            if (name.startsWith(":")) {
                switch (name) {
                    case ":method": {
                        method = value;
                        break;
                    }
                    case ":path": {
                        path = value;
                        break;
                    }
                    case ":scheme": {
                        scheme = value;
                        break;
                    }
                    case ":authority": {
                        authority = value;
                    }
                }
                continue;
            }
            headers.put(name, value);
        }
        if (method != null) {
            request.setMethod(method);
        }
        if (path != null) {
            int queryIdx = path.indexOf(63);
            if (queryIdx >= 0) {
                request.setPath(path.substring(0, queryIdx));
                request.setQueryString(path.substring(queryIdx + 1));
            } else {
                request.setPath(path);
            }
        }
        for (Map.Entry entry : headers.entrySet()) {
            request.addHeader((String)entry.getKey(), (String)entry.getValue());
        }
        if (authority != null) {
            request.setServerName(authority);
            headers.put("host", authority);
        } else if (headers.containsKey("host")) {
            request.setServerName((String)headers.get("host"));
        }
        request.setSecure(this.secure || "https".equals(scheme));
        request.setServerPort(this.serverPort);
        if (stream.isStreamingMode()) {
            InputStream bodyStream = stream.getStreamingBodyInputStream();
            if (bodyStream != null) {
                request.setBodyStream(bodyStream);
            }
        } else {
            byte[] body = stream.getRequestBody();
            if (body != null && body.length > 0) {
                request.setBody(new ByteArrayInputStream(body));
            }
        }
        request.setProtocol("HTTP/2.0");
        return request;
    }

    @Override
    public boolean isOpen() {
        return this.connection.isOpen();
    }

    public boolean isClosed() {
        Http2Connection.State state = this.connection.getState();
        return state == Http2Connection.State.GOAWAY_SENT || state == Http2Connection.State.CLOSED;
    }

    @Override
    public byte[] close() {
        if (this.handlerExecutor != null) {
            this.handlerExecutor.shutdown();
            try {
                if (!this.handlerExecutor.awaitTermination(5L, TimeUnit.SECONDS)) {
                    this.handlerExecutor.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                this.handlerExecutor.shutdownNow();
            }
        }
        ByteBuffer output = ByteBuffer.allocate(128);
        this.connection.writeGoaway(output, 0, null);
        output.flip();
        byte[] result = new byte[output.remaining()];
        output.get(result);
        return result;
    }

    @Override
    public byte[] processData(byte[] data, int offset, int length) {
        try {
            byte[] actualData;
            if (offset == 0 && length == data.length) {
                actualData = data;
            } else {
                actualData = new byte[length];
                System.arraycopy(data, offset, actualData, 0, length);
            }
            return this.processData(actualData);
        }
        catch (Http2FrameReader.Http2Exception e) {
            return this.close();
        }
    }

    @Override
    public boolean hasPendingWrite() {
        return this.hasPendingResponses() || this.hasPendingStreamingHandlers();
    }

    @Override
    public byte[] getPendingWrite() {
        this.checkCompletedStreamingHandlers();
        return null;
    }

    @Override
    public boolean isKeepAlive() {
        return true;
    }

    @Override
    public String getProtocol() {
        return "HTTP/2";
    }

    @Override
    public void setCompletionCallback(Runnable callback) {
        this.setHandlerCompletionCallback(callback);
    }

    public byte[] ping() {
        ByteBuffer output = ByteBuffer.allocate(32);
        byte[] opaqueData = new byte[8];
        System.currentTimeMillis();
        long time = System.nanoTime();
        for (int i = 0; i < 8; ++i) {
            opaqueData[i] = (byte)(time >> i * 8);
        }
        this.connection.getFrameWriter().writePing(output, opaqueData);
        output.flip();
        byte[] result = new byte[output.remaining()];
        output.get(result);
        return result;
    }

    private static class StreamingResponse {
        final int streamId;
        final InputStream stream;
        byte[] buffer;
        byte[] nextBuffer;
        int currentRead = 0;
        boolean headersSent = false;
        List<String[]> headers;
        byte[] pendingData = null;
        boolean isLast = false;
        boolean waitingForWindow = false;
        boolean closed = false;

        StreamingResponse(int streamId, List<String[]> headers, InputStream stream, int bufferSize) {
            this.streamId = streamId;
            this.headers = headers;
            this.stream = stream;
            this.buffer = new byte[bufferSize];
            this.nextBuffer = new byte[bufferSize];
        }

        void close() {
            if (!this.closed) {
                this.closed = true;
                try {
                    this.stream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private record PendingResponse(int streamId, List<String[]> headers, byte[] body) {
    }
}

