/*
 * Decompiled with CFR 0.152.
 */
package zeph.http2;

public final class Http2FrameType {
    public static final int DATA = 0;
    public static final int HEADERS = 1;
    public static final int PRIORITY = 2;
    public static final int RST_STREAM = 3;
    public static final int SETTINGS = 4;
    public static final int PUSH_PROMISE = 5;
    public static final int PING = 6;
    public static final int GOAWAY = 7;
    public static final int WINDOW_UPDATE = 8;
    public static final int CONTINUATION = 9;
    public static final int FLAG_END_STREAM = 1;
    public static final int FLAG_ACK = 1;
    public static final int FLAG_END_HEADERS = 4;
    public static final int FLAG_PADDED = 8;
    public static final int FLAG_PRIORITY = 32;
    public static final int FRAME_HEADER_SIZE = 9;
    public static final int DEFAULT_MAX_FRAME_SIZE = 16384;
    public static final int MIN_MAX_FRAME_SIZE = 16384;
    public static final int MAX_MAX_FRAME_SIZE = 0xFFFFFF;
    public static final byte[] CONNECTION_PREFACE = new byte[]{80, 82, 73, 32, 42, 32, 72, 84, 84, 80, 47, 50, 46, 48, 13, 10, 13, 10, 83, 77, 13, 10, 13, 10};

    private Http2FrameType() {
    }

    public static String name(int type) {
        return switch (type) {
            case 0 -> "DATA";
            case 1 -> "HEADERS";
            case 2 -> "PRIORITY";
            case 3 -> "RST_STREAM";
            case 4 -> "SETTINGS";
            case 5 -> "PUSH_PROMISE";
            case 6 -> "PING";
            case 7 -> "GOAWAY";
            case 8 -> "WINDOW_UPDATE";
            case 9 -> "CONTINUATION";
            default -> "UNKNOWN(" + type + ")";
        };
    }
}

