/*
 * Decompiled with CFR 0.152.
 */
package zeph.http2;

import java.nio.ByteBuffer;
import zeph.http2.Http2Frame;
import zeph.http2.Http2FrameType;

public class Http2FrameReader {
    private final int maxFrameSize;

    public Http2FrameReader() {
        this(16384);
    }

    public Http2FrameReader(int maxFrameSize) {
        this.maxFrameSize = maxFrameSize;
    }

    public Http2Frame readFrame(ByteBuffer buf) throws Http2Exception {
        if (buf.remaining() < 9) {
            return null;
        }
        buf.mark();
        int length = (buf.get() & 0xFF) << 16 | (buf.get() & 0xFF) << 8 | buf.get() & 0xFF;
        int type = buf.get() & 0xFF;
        int flags = buf.get() & 0xFF;
        int streamId = (buf.get() & 0x7F) << 24 | (buf.get() & 0xFF) << 16 | (buf.get() & 0xFF) << 8 | buf.get() & 0xFF;
        if (length > this.maxFrameSize) {
            throw new Http2Exception(6, "Frame size " + length + " exceeds maximum " + this.maxFrameSize);
        }
        if (buf.remaining() < length) {
            buf.reset();
            return null;
        }
        byte[] payload = new byte[length];
        buf.get(payload);
        return new Http2Frame(type, flags, streamId, payload);
    }

    public Http2Frame readFrame(byte[] data) throws Http2Exception {
        return this.readFrame(data, 0, data.length);
    }

    public Http2Frame readFrame(byte[] data, int offset, int length) throws Http2Exception {
        return this.readFrame(ByteBuffer.wrap(data, offset, length));
    }

    public static boolean hasConnectionPreface(ByteBuffer buf) {
        if (buf.remaining() < Http2FrameType.CONNECTION_PREFACE.length) {
            return false;
        }
        buf.mark();
        for (byte b : Http2FrameType.CONNECTION_PREFACE) {
            if (buf.get() == b) continue;
            buf.reset();
            return false;
        }
        return true;
    }

    public static boolean startsWithConnectionPreface(ByteBuffer buf) {
        if (buf.remaining() < Http2FrameType.CONNECTION_PREFACE.length) {
            return false;
        }
        int pos = buf.position();
        for (int i = 0; i < Http2FrameType.CONNECTION_PREFACE.length; ++i) {
            if (buf.get(pos + i) == Http2FrameType.CONNECTION_PREFACE[i]) continue;
            return false;
        }
        return true;
    }

    public static void consumeConnectionPreface(ByteBuffer buf) {
        buf.position(buf.position() + Http2FrameType.CONNECTION_PREFACE.length);
    }

    public static class Http2Exception
    extends Exception {
        private final int errorCode;
        private final int streamId;

        public Http2Exception(int errorCode, String message) {
            this(errorCode, 0, message);
        }

        public Http2Exception(int errorCode, int streamId, String message) {
            super(message);
            this.errorCode = errorCode;
            this.streamId = streamId;
        }

        public int getErrorCode() {
            return this.errorCode;
        }

        public int getStreamId() {
            return this.streamId;
        }

        public boolean isConnectionError() {
            return this.streamId == 0;
        }
    }
}

