/*
 * Decompiled with CFR 0.152.
 */
package zeph.http;

import zeph.http2.Http2FrameType;

public class ProtocolDetector {
    public static boolean isHttp2Preface(byte[] data) {
        byte[] preface = Http2FrameType.CONNECTION_PREFACE;
        if (data.length < preface.length) {
            if (data.length >= 4 && data[0] == 80 && data[1] == 82 && data[2] == 73 && data[3] == 32) {
                return data.length >= preface.length;
            }
            return false;
        }
        for (int i = 0; i < preface.length; ++i) {
            if (data[i] == preface[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean mightBeHttp2Preface(byte[] data) {
        if (data.length < 4) {
            return false;
        }
        return data[0] == 80 && data[1] == 82 && data[2] == 73 && data[3] == 32;
    }

    public static boolean isTlsRecord(byte[] data) {
        if (data.length < 5) {
            return false;
        }
        int contentType = data[0] & 0xFF;
        if (contentType < 20 || contentType > 23) {
            return false;
        }
        int majorVersion = data[1] & 0xFF;
        int minorVersion = data[2] & 0xFF;
        return majorVersion == 3 && minorVersion >= 1 && minorVersion <= 3;
    }
}

