/*
 * Decompiled with CFR 0.152.
 */
package zeph.http;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import javax.net.ssl.SSLException;
import zeph.http.Http1Handler;
import zeph.http.HttpRequest;
import zeph.http.HttpResponse;
import zeph.http.HttpServer;
import zeph.http2.Http2FrameReader;
import zeph.http2.Http2ServerHandler;
import zeph.logging.Logger;
import zeph.ssl.DirectBufferPool;
import zeph.ssl.SslConfig;
import zeph.ssl.SslHandler;

public class HttpsServerNio
implements HttpServer {
    private static final Logger log = new Logger(HttpsServerNio.class);
    private final String host;
    private final int port;
    private final int workerCount;
    private final Function<HttpRequest, HttpResponse> handler;
    private final SslConfig sslConfig;
    private final AtomicBoolean running = new AtomicBoolean(true);
    private final NioWorker[] workers;
    private final AtomicInteger nextWorker = new AtomicInteger(0);
    private final AtomicLong connectionIdGenerator = new AtomicLong(0L);
    private final boolean streamingMode;
    private final ExecutorService handlerExecutor;
    private ServerSocketChannel serverChannel;
    private Selector acceptorSelector;
    private Thread acceptorThread;

    public HttpsServerNio(String host, int port, int workerCount, Function<HttpRequest, HttpResponse> handler, SslConfig sslConfig, boolean streamingMode) throws IOException {
        this.host = host;
        this.port = port;
        this.workerCount = workerCount;
        this.handler = handler;
        this.sslConfig = sslConfig;
        this.streamingMode = streamingMode;
        this.handlerExecutor = streamingMode ? Executors.newFixedThreadPool(Math.max(4, Runtime.getRuntime().availableProcessors()), r -> {
            Thread t = new Thread(r, "zeph-ssl-nio-handler");
            t.setDaemon(true);
            return t;
        }) : null;
        this.workers = new NioWorker[workerCount];
        for (int i = 0; i < workerCount; ++i) {
            this.workers[i] = new NioWorker(i);
        }
        this.serverChannel = ServerSocketChannel.open();
        this.serverChannel.configureBlocking(false);
        this.serverChannel.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)true);
        this.serverChannel.bind(new InetSocketAddress(host, port), 4096);
        this.acceptorSelector = Selector.open();
        this.serverChannel.register(this.acceptorSelector, 16);
        log.info("HTTPS Server (NIO) listening on " + host + ":" + port + " with " + workerCount + " workers" + (streamingMode ? " (streaming mode)" : ""));
    }

    @Override
    public void run() {
        for (NioWorker worker : this.workers) {
            worker.start();
        }
        this.acceptorThread = Thread.currentThread();
        log.info("HTTPS Server (NIO) started with " + this.workerCount + " workers");
        while (this.running.get()) {
            try {
                this.acceptorSelector.select(1000L);
                Set<SelectionKey> selectedKeys = this.acceptorSelector.selectedKeys();
                Iterator<SelectionKey> iter = selectedKeys.iterator();
                while (iter.hasNext()) {
                    SocketChannel clientChannel;
                    SelectionKey key = iter.next();
                    iter.remove();
                    if (!key.isAcceptable() || (clientChannel = this.serverChannel.accept()) == null) continue;
                    clientChannel.configureBlocking(false);
                    clientChannel.setOption((SocketOption)StandardSocketOptions.TCP_NODELAY, (Object)true);
                    long connId = this.connectionIdGenerator.incrementAndGet();
                    int workerIdx = Math.abs(this.nextWorker.getAndIncrement() % this.workerCount);
                    this.workers[workerIdx].addConnection(clientChannel, connId);
                }
            }
            catch (IOException e) {
                if (!this.running.get()) continue;
                log.error("HTTPS NIO Acceptor error: " + e.getMessage(), e);
            }
        }
    }

    @Override
    public void stop() {
        this.running.set(false);
        this.acceptorSelector.wakeup();
        for (NioWorker worker : this.workers) {
            worker.stop();
        }
    }

    @Override
    public boolean isRunning() {
        return this.running.get();
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public void close() {
        this.stop();
        if (this.handlerExecutor != null) {
            this.handlerExecutor.shutdown();
            try {
                if (!this.handlerExecutor.awaitTermination(5L, TimeUnit.SECONDS)) {
                    this.handlerExecutor.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                this.handlerExecutor.shutdownNow();
            }
        }
        try {
            if (this.acceptorThread != null) {
                this.acceptorThread.join(2000L);
            }
            for (NioWorker worker : this.workers) {
                worker.thread.interrupt();
                worker.thread.join(1000L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        for (NioWorker worker : this.workers) {
            worker.close();
        }
        try {
            this.serverChannel.close();
            this.acceptorSelector.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private class NioWorker
    implements Runnable {
        final int id;
        final Selector selector;
        final Thread thread;
        final ConcurrentHashMap<SocketChannel, NioConnection> connections = new ConcurrentHashMap();
        final ConcurrentLinkedQueue<NewConnection> pendingConnections = new ConcurrentLinkedQueue();
        final ByteBuffer readBuffer = ByteBuffer.allocateDirect(65536);

        NioWorker(int id) throws IOException {
            this.id = id;
            this.selector = Selector.open();
            this.thread = new Thread((Runnable)this, "zeph-ssl-nio-worker-" + id);
        }

        void start() {
            this.thread.start();
        }

        void addConnection(SocketChannel channel, long connId) {
            this.pendingConnections.offer(new NewConnection(channel, connId));
            this.selector.wakeup();
        }

        private void processPendingConnections() {
            NewConnection nc;
            while ((nc = this.pendingConnections.poll()) != null) {
                try {
                    SelectionKey key = nc.channel.register(this.selector, 1);
                    SslHandler sslHandler = new SslHandler(HttpsServerNio.this.sslConfig.createEngineWithAlpn());
                    sslHandler.beginHandshake();
                    NioConnection conn = new NioConnection(nc.channel, nc.id, key, sslHandler, HttpsServerNio.this.handler, HttpsServerNio.this.port, HttpsServerNio.this.streamingMode);
                    key.attach(conn);
                    this.connections.put(nc.channel, conn);
                }
                catch (Exception e) {
                    try {
                        nc.channel.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }

        @Override
        public void run() {
            while (HttpsServerNio.this.running.get()) {
                try {
                    boolean hasPendingWork = false;
                    for (NioConnection conn : this.connections.values()) {
                        if (conn.pendingWrite == null || !conn.pendingWrite.hasRemaining()) continue;
                        hasPendingWork = true;
                        break;
                    }
                    this.selector.select(hasPendingWork ? 0L : 100L);
                    this.processPendingConnections();
                    Set<SelectionKey> selectedKeys = this.selector.selectedKeys();
                    Iterator<SelectionKey> iter = selectedKeys.iterator();
                    while (iter.hasNext()) {
                        NioConnection conn;
                        SelectionKey key = iter.next();
                        iter.remove();
                        if (!key.isValid() || (conn = (NioConnection)key.attachment()) == null) continue;
                        try {
                            if (key.isReadable()) {
                                this.handleRead(conn);
                            }
                            if (!key.isValid() || !key.isWritable()) continue;
                            this.handleWrite(conn);
                        }
                        catch (IOException e) {
                            this.closeConnection(conn);
                        }
                    }
                    for (NioConnection conn : this.connections.values()) {
                        int ops;
                        if (!conn.key.isValid() || conn.pendingWrite == null || !conn.pendingWrite.hasRemaining() || ((ops = conn.key.interestOps()) & 4) != 0) continue;
                        conn.key.interestOps(ops | 4);
                    }
                    if (!HttpsServerNio.this.streamingMode) continue;
                    this.checkCompletedStreamingHandlers();
                }
                catch (IOException e) {
                    if (!HttpsServerNio.this.running.get()) continue;
                    log.error("HTTPS NIO Worker " + this.id + " error: " + e.getMessage(), e);
                }
            }
        }

        private void handleRead(NioConnection conn) throws IOException, SSLException {
            this.readBuffer.clear();
            int bytesRead = conn.channel.read(this.readBuffer);
            if (bytesRead < 0) {
                this.closeConnection(conn);
                return;
            }
            if (bytesRead == 0) {
                return;
            }
            this.readBuffer.flip();
            byte[] data = new byte[bytesRead];
            this.readBuffer.get(data);
            if (conn.state == ConnectionState.HANDSHAKING) {
                this.handleHandshakeRead(conn, data);
            } else if (conn.state == ConnectionState.CONNECTED) {
                this.handleApplicationRead(conn, data);
            }
        }

        private void handleHandshakeRead(NioConnection conn, byte[] data) throws IOException, SSLException {
            byte[] handshakeResponse = conn.sslHandler.processHandshake(data);
            if (conn.sslHandler.isHandshakeComplete()) {
                byte[] remaining;
                conn.state = ConnectionState.CONNECTED;
                String protocol = conn.sslHandler.getApplicationProtocol();
                if ("h2".equals(protocol)) {
                    conn.isHttp2 = true;
                    conn.http2Handler = new Http2ServerHandler(HttpsServerNio.this.handler, HttpsServerNio.this.port, true, HttpsServerNio.this.streamingMode);
                    conn.http2Handler.setHandlerCompletionCallback(() -> this.selector.wakeup());
                }
                if ((remaining = conn.sslHandler.getRemainingData()) != null && remaining.length > 0) {
                    if (handshakeResponse != null && handshakeResponse.length > 0) {
                        conn.pendingWrite = ByteBuffer.wrap(handshakeResponse);
                        conn.pendingAppData = remaining;
                        conn.readAfterWrite = false;
                        conn.key.interestOps(4);
                    } else {
                        this.handleApplicationRead(conn, remaining);
                    }
                } else if (handshakeResponse != null && handshakeResponse.length > 0) {
                    conn.pendingWrite = ByteBuffer.wrap(handshakeResponse);
                    conn.readAfterWrite = true;
                    conn.key.interestOps(4);
                }
            } else if (handshakeResponse != null && handshakeResponse.length > 0) {
                conn.pendingWrite = ByteBuffer.wrap(handshakeResponse);
                conn.readAfterWrite = true;
                conn.key.interestOps(4);
            }
        }

        private void handleApplicationRead(NioConnection conn, byte[] encryptedData) throws IOException, SSLException {
            byte[] wrapData;
            byte[] decrypted = conn.sslHandler.decrypt(encryptedData);
            if (conn.sslHandler.hasPendingWrap() && (wrapData = conn.sslHandler.processPendingWrap()) != null && wrapData.length > 0) {
                if (conn.pendingWrite == null) {
                    conn.pendingWrite = ByteBuffer.wrap(wrapData);
                    conn.readAfterWrite = true;
                    conn.key.interestOps(5);
                } else {
                    ByteBuffer combined = ByteBuffer.allocate(conn.pendingWrite.remaining() + wrapData.length);
                    combined.put(conn.pendingWrite);
                    combined.put(wrapData);
                    combined.flip();
                    conn.pendingWrite = combined;
                }
            }
            if (decrypted.length == 0) {
                if (conn.pendingWrite != null) {
                    conn.key.interestOps(5);
                }
                return;
            }
            if (conn.isHttp2) {
                this.handleHttp2Read(conn, decrypted);
            } else {
                this.handleHttp1Read(conn, decrypted);
            }
        }

        private void handleHttp2Read(NioConnection conn, byte[] decrypted) throws IOException, SSLException {
            try {
                byte[] response = conn.http2Handler.processData(decrypted);
                if (response != null && response.length > 0) {
                    ByteBuffer encrypted = conn.sslHandler.encryptToDirectBuffer(response);
                    if (conn.pendingWrite == null) {
                        conn.pendingWrite = encrypted;
                    } else {
                        int totalSize = conn.pendingWrite.remaining() + encrypted.remaining();
                        ByteBuffer combined = DirectBufferPool.acquire(totalSize);
                        combined.put(conn.pendingWrite);
                        combined.put(encrypted);
                        combined.flip();
                        DirectBufferPool.release(conn.pendingWrite);
                        DirectBufferPool.release(encrypted);
                        conn.pendingWrite = combined;
                    }
                    conn.key.interestOps(5);
                }
            }
            catch (Http2FrameReader.Http2Exception e) {
                this.closeConnection(conn);
            }
        }

        private void handleHttp1Read(NioConnection conn, byte[] decrypted) throws IOException, SSLException {
            Http1Handler.ParseResult parseResult = conn.http1Handler.parse(decrypted, 0, decrypted.length);
            if (parseResult == Http1Handler.ParseResult.REQUEST_COMPLETE) {
                if (conn.streamingRequest && conn.handlerFuture != null) {
                    return;
                }
                HttpRequest request = conn.http1Handler.getRequest();
                request.setSecure(true);
                HttpResponse response = conn.http1Handler.handleRequest(request);
                if (!conn.isKeepAlive()) {
                    conn.closeAfterWrite = true;
                }
                if (response.isStreaming()) {
                    this.startStreamingResponse(conn, response);
                } else {
                    byte[] plainResponse = response.encode();
                    conn.pendingWrite = conn.sslHandler.encryptToDirectBuffer(plainResponse);
                    conn.readAfterWrite = false;
                    conn.key.interestOps(4);
                }
                conn.http1Handler.reset();
            } else if (parseResult == Http1Handler.ParseResult.HEADERS_COMPLETE) {
                HttpRequest request = conn.http1Handler.getRequest();
                request.setSecure(true);
                conn.streamingRequest = true;
                NioWorker worker = this;
                conn.handlerFuture = HttpsServerNio.this.handlerExecutor.submit(() -> {
                    try {
                        HttpResponse resp = HttpsServerNio.this.handler.apply(request);
                        worker.selector.wakeup();
                        return resp;
                    }
                    catch (Exception e) {
                        worker.selector.wakeup();
                        return HttpResponse.serverError();
                    }
                });
                conn.http1Handler.parse(new byte[0], 0, 0);
            } else if (parseResult == Http1Handler.ParseResult.ERROR) {
                HttpResponse response = HttpResponse.badRequest();
                response.setHeader("Connection", "close");
                conn.pendingWrite = conn.sslHandler.encryptToDirectBuffer(response.encode());
                conn.closeAfterWrite = true;
                conn.readAfterWrite = false;
                conn.key.interestOps(4);
            }
        }

        private void startStreamingResponse(NioConnection conn, HttpResponse response) throws SSLException {
            InputStream stream = response.getBodyStream();
            if (stream == null) {
                conn.pendingWrite = conn.sslHandler.encryptToDirectBuffer(response.encode());
                conn.readAfterWrite = false;
                conn.key.interestOps(4);
                return;
            }
            conn.streamingBody = stream;
            conn.useChunkedEncoding = response.getContentLength() < 0L;
            conn.streamingBuffer = new byte[16384];
            conn.pendingWrite = conn.sslHandler.encryptToDirectBuffer(response.encodeStreamingHeaders());
            conn.readAfterWrite = false;
            conn.key.interestOps(4);
        }

        private boolean continueStreamingResponse(NioConnection conn) throws SSLException {
            if (conn.streamingBody == null) {
                return false;
            }
            try {
                byte[] chunk;
                int n = conn.streamingBody.read(conn.streamingBuffer);
                if (n <= 0) {
                    byte[] finalChunk = null;
                    if (conn.useChunkedEncoding) {
                        finalChunk = "0\r\n\r\n".getBytes(StandardCharsets.US_ASCII);
                    }
                    conn.streamingBody.close();
                    conn.streamingBody = null;
                    conn.streamingBuffer = null;
                    if (finalChunk != null) {
                        conn.pendingWrite = conn.sslHandler.encryptToDirectBuffer(finalChunk);
                        return true;
                    }
                    return false;
                }
                if (conn.useChunkedEncoding) {
                    String sizeHex = Integer.toHexString(n);
                    byte[] header = (sizeHex + "\r\n").getBytes(StandardCharsets.US_ASCII);
                    byte[] footer = "\r\n".getBytes(StandardCharsets.US_ASCII);
                    chunk = new byte[header.length + n + footer.length];
                    System.arraycopy(header, 0, chunk, 0, header.length);
                    System.arraycopy(conn.streamingBuffer, 0, chunk, header.length, n);
                    System.arraycopy(footer, 0, chunk, header.length + n, footer.length);
                } else {
                    chunk = new byte[n];
                    System.arraycopy(conn.streamingBuffer, 0, chunk, 0, n);
                }
                conn.pendingWrite = conn.sslHandler.encryptToDirectBuffer(chunk);
                return true;
            }
            catch (Exception e) {
                try {
                    conn.streamingBody.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                conn.streamingBody = null;
                conn.streamingBuffer = null;
                return false;
            }
        }

        private void handleWrite(NioConnection conn) throws IOException, SSLException {
            block30: {
                if (conn.pendingWrite == null) {
                    if (conn.isHttp2 && conn.http2Handler != null && conn.http2Handler.hasAccumulatedData()) {
                        try {
                            byte[] response = conn.http2Handler.processData(new byte[0]);
                            if (response != null && response.length > 0) {
                                conn.pendingWrite = conn.sslHandler.encryptToDirectBuffer(response);
                            }
                        }
                        catch (Exception e) {
                            this.closeConnection(conn);
                            return;
                        }
                    }
                    if (conn.pendingWrite == null) {
                        conn.key.interestOps(1);
                        return;
                    }
                }
                int bytesWritten = conn.channel.write(conn.pendingWrite);
                if (!conn.pendingWrite.hasRemaining()) {
                    DirectBufferPool.release(conn.pendingWrite);
                    conn.pendingWrite = null;
                    if (conn.streamingBody != null) {
                        if (this.continueStreamingResponse(conn)) {
                            if (conn.isHttp2) {
                                conn.key.interestOps(5);
                            }
                            return;
                        }
                        conn.streamingBody = null;
                        conn.streamingBuffer = null;
                    }
                    if (conn.isHttp2 && conn.http2Handler != null && conn.http2Handler.hasPendingStreaming()) {
                        byte[] nextChunk = conn.http2Handler.continueStreaming();
                        if (nextChunk != null && nextChunk.length > 0) {
                            conn.pendingWrite = conn.sslHandler.encryptToDirectBuffer(nextChunk);
                            conn.key.interestOps(5);
                            return;
                        }
                        if (conn.http2Handler.isClosed()) {
                            this.closeConnection(conn);
                            return;
                        }
                    }
                    if (conn.isHttp2 && conn.http2Handler != null && (conn.http2Handler.hasPendingResponses() || conn.http2Handler.hasAccumulatedData())) {
                        try {
                            byte[] response = conn.http2Handler.processData(new byte[0]);
                            if (response != null && response.length > 0) {
                                conn.pendingWrite = conn.sslHandler.encryptToDirectBuffer(response);
                                conn.key.interestOps(5);
                                return;
                            }
                        }
                        catch (Exception e) {
                            this.closeConnection(conn);
                            return;
                        }
                    }
                    if (conn.pendingAppData != null) {
                        byte[] appData = conn.pendingAppData;
                        conn.pendingAppData = null;
                        this.handleApplicationRead(conn, appData);
                        return;
                    }
                    if (conn.isHttp2) {
                        if (conn.http2Handler != null && conn.http2Handler.isClosed()) {
                            this.closeConnection(conn);
                        } else {
                            conn.key.interestOps(1);
                        }
                        return;
                    }
                    if (conn.closeAfterWrite) {
                        try {
                            byte[] closeData = conn.sslHandler.close();
                            if (closeData != null && closeData.length > 0) {
                                conn.pendingWrite = ByteBuffer.wrap(closeData);
                                conn.closeAfterWrite = false;
                                conn.state = ConnectionState.CLOSING;
                                break block30;
                            }
                            this.closeConnection(conn);
                        }
                        catch (SSLException e) {
                            this.closeConnection(conn);
                        }
                    } else if (conn.state == ConnectionState.CLOSING) {
                        this.closeConnection(conn);
                    } else if (conn.readAfterWrite || conn.isKeepAlive()) {
                        conn.key.interestOps(1);
                    } else {
                        this.closeConnection(conn);
                    }
                }
            }
        }

        private void checkCompletedStreamingHandlers() {
            for (NioConnection conn : this.connections.values()) {
                Object response;
                if (conn.isHttp2 && conn.http2Handler != null) {
                    if (conn.http2Handler.hasPendingStreamingHandlers()) {
                        conn.http2Handler.checkCompletedStreamingHandlers();
                    }
                    if (!conn.http2Handler.hasPendingResponses() && !conn.http2Handler.hasPendingStreamingHandlers() || conn.pendingWrite != null && conn.pendingWrite.hasRemaining()) continue;
                    try {
                        response = conn.http2Handler.processData(new byte[0]);
                        if (response == null || ((Object)response).length <= 0) continue;
                        conn.pendingWrite = conn.sslHandler.encryptToDirectBuffer((byte[])response);
                        conn.key.interestOps(5);
                    }
                    catch (Exception response2) {}
                    continue;
                }
                if (!conn.streamingRequest || conn.handlerFuture == null || !conn.handlerFuture.isDone()) continue;
                try {
                    response = conn.handlerFuture.get();
                    conn.handlerFuture = null;
                    conn.streamingRequest = false;
                    if (conn.isKeepAlive()) {
                        ((HttpResponse)response).setHeader("Connection", "keep-alive");
                    } else {
                        ((HttpResponse)response).setHeader("Connection", "close");
                        conn.closeAfterWrite = true;
                    }
                    if (((HttpResponse)response).isStreaming()) {
                        this.startStreamingResponse(conn, (HttpResponse)response);
                    } else {
                        conn.pendingWrite = conn.sslHandler.encryptToDirectBuffer(((HttpResponse)response).encode());
                        conn.readAfterWrite = false;
                        conn.key.interestOps(4);
                    }
                    conn.http1Handler.reset();
                }
                catch (Exception e) {
                    conn.handlerFuture = null;
                    conn.streamingRequest = false;
                    try {
                        HttpResponse response3 = HttpResponse.serverError();
                        response3.setHeader("Connection", "close");
                        conn.pendingWrite = conn.sslHandler.encryptToDirectBuffer(response3.encode());
                        conn.closeAfterWrite = true;
                        conn.readAfterWrite = false;
                        conn.key.interestOps(4);
                    }
                    catch (SSLException sslEx) {
                        this.closeConnection(conn);
                    }
                    conn.http1Handler.reset();
                }
            }
        }

        private void closeConnection(NioConnection conn) {
            this.connections.remove(conn.channel);
            conn.close();
        }

        void stop() {
            this.selector.wakeup();
        }

        void close() {
            for (NioConnection conn : this.connections.values()) {
                conn.close();
            }
            this.connections.clear();
            try {
                this.selector.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        record NewConnection(SocketChannel channel, long id) {
        }
    }

    private class NioConnection {
        final SocketChannel channel;
        final long id;
        final SelectionKey key;
        final Http1Handler http1Handler;
        final SslHandler sslHandler;
        ConnectionState state = ConnectionState.HANDSHAKING;
        ByteBuffer pendingWrite;
        boolean closeAfterWrite = false;
        boolean readAfterWrite = false;
        byte[] pendingAppData;
        boolean isHttp2 = false;
        Http2ServerHandler http2Handler;
        InputStream streamingBody;
        boolean useChunkedEncoding;
        byte[] streamingBuffer;
        Future<HttpResponse> handlerFuture;
        boolean streamingRequest = false;

        NioConnection(SocketChannel channel, long id, SelectionKey key, SslHandler sslHandler, Function<HttpRequest, HttpResponse> handler, int serverPort, boolean streamingMode) {
            this.channel = channel;
            this.id = id;
            this.key = key;
            this.http1Handler = new Http1Handler(handler, serverPort, streamingMode);
            this.sslHandler = sslHandler;
        }

        boolean isKeepAlive() {
            return this.http1Handler.isKeepAlive();
        }

        void close() {
            try {
                this.key.cancel();
                this.channel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (this.pendingWrite != null) {
                DirectBufferPool.release(this.pendingWrite);
                this.pendingWrite = null;
            }
            if (this.streamingBody != null) {
                try {
                    this.streamingBody.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.streamingBody = null;
            }
        }
    }

    private static enum ConnectionState {
        HANDSHAKING,
        CONNECTED,
        CLOSING;

    }
}

