/*
 * Decompiled with CFR 0.152.
 */
package zeph.http;

import java.util.function.Function;
import zeph.http.HttpRequest;
import zeph.http.HttpResponse;
import zeph.http.HttpServerNio;

public interface HttpServer
extends AutoCloseable {
    public void run();

    public void stop();

    @Override
    public void close();

    public int getPort();

    public String getHost();

    public boolean isRunning();

    default public boolean gracefulShutdown(long timeoutMs) {
        this.stop();
        return true;
    }

    default public int getActiveConnectionCount() {
        return 0;
    }

    default public boolean isDraining() {
        return false;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static HttpServer create(int port, Function<HttpRequest, HttpResponse> handler) throws Exception {
        return HttpServer.builder().port(port).handler(handler).build();
    }

    public static class Builder {
        private String host = "0.0.0.0";
        private int port = 8080;
        private int workers = Runtime.getRuntime().availableProcessors();
        private Function<HttpRequest, HttpResponse> handler;
        private boolean streamingMode = false;
        private long maxBodySize = -1L;
        private int idleTimeoutMs = 30000;

        public Builder host(String host) {
            this.host = host;
            return this;
        }

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        public Builder workers(int workers) {
            this.workers = workers;
            return this;
        }

        public Builder handler(Function<HttpRequest, HttpResponse> handler) {
            this.handler = handler;
            return this;
        }

        public Builder streamingMode(boolean streamingMode) {
            this.streamingMode = streamingMode;
            return this;
        }

        public Builder maxBodySize(long maxBodySize) {
            this.maxBodySize = maxBodySize;
            return this;
        }

        public Builder idleTimeout(int idleTimeoutMs) {
            this.idleTimeoutMs = idleTimeoutMs;
            return this;
        }

        public HttpServer build() throws Exception {
            if (this.handler == null) {
                throw new IllegalStateException("Handler must be set");
            }
            return new HttpServerNio(this.host, this.port, this.workers, this.handler, this.streamingMode, false, this.maxBodySize, this.idleTimeoutMs);
        }
    }
}

