/*
 * Decompiled with CFR 0.152.
 */
package zeph.http;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import zeph.http.HttpMethod;

public class HttpRequest {
    private HttpMethod method;
    private String uri;
    private String path;
    private String queryString;
    private String version;
    private String protocol;
    private final Map<String, String> headers = new HashMap<String, String>();
    private byte[] body;
    private InputStream bodyStream;
    private String remoteAddr;
    private int remotePort;
    private int serverPort;
    private String serverName;
    private boolean secure;

    public HttpMethod getMethod() {
        return this.method;
    }

    public void setMethod(HttpMethod method) {
        this.method = method;
    }

    public void setMethod(String methodStr) {
        this.method = HttpMethod.valueOf(methodStr.toUpperCase());
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
        if (uri == null) {
            this.path = null;
            this.queryString = null;
            return;
        }
        int qIdx = uri.indexOf(63);
        if (qIdx >= 0) {
            this.path = uri.substring(0, qIdx);
            this.queryString = uri.substring(qIdx + 1);
        } else {
            this.path = uri;
            this.queryString = null;
        }
    }

    public void reset() {
        this.method = null;
        this.uri = null;
        this.path = null;
        this.queryString = null;
        this.version = null;
        this.headers.clear();
        this.body = null;
        this.bodyStream = null;
        this.remoteAddr = null;
        this.remotePort = 0;
        this.serverPort = 0;
        this.serverName = null;
        this.secure = false;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getProtocol() {
        return this.protocol != null ? this.protocol : this.version;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public String getHeader(String name) {
        return this.headers.get(name.toLowerCase());
    }

    public void setHeader(String name, String value) {
        this.headers.put(name.toLowerCase(), value);
    }

    public void addHeader(String name, String value) {
        this.headers.put(name.toLowerCase(), value);
    }

    public byte[] getBody() {
        return this.body;
    }

    public void setBody(byte[] body) {
        this.body = body;
    }

    public InputStream getBodyStream() {
        return this.bodyStream;
    }

    public void setBody(InputStream bodyStream) {
        this.bodyStream = bodyStream;
    }

    public void setBodyStream(InputStream bodyStream) {
        this.bodyStream = bodyStream;
    }

    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public void setRemoteAddr(String remoteAddr) {
        this.remoteAddr = remoteAddr;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public void setRemotePort(int remotePort) {
        this.remotePort = remotePort;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public boolean isKeepAlive() {
        String connection = this.getHeader("connection");
        if (connection != null) {
            return connection.equalsIgnoreCase("keep-alive");
        }
        return "HTTP/1.1".equals(this.version);
    }

    public long getContentLength() {
        String cl = this.getHeader("content-length");
        if (cl != null) {
            try {
                return Long.parseLong(cl.trim());
            }
            catch (NumberFormatException e) {
                return -1L;
            }
        }
        return -1L;
    }

    public String getContentType() {
        return this.getHeader("content-type");
    }

    public String toString() {
        return "HttpRequest{method=" + String.valueOf((Object)this.method) + ", uri='" + this.uri + "', version='" + this.version + "', headers=" + this.headers.size() + ", bodyLen=" + (this.body != null ? this.body.length : 0) + "}";
    }
}

