/*
 * Decompiled with CFR 0.152.
 */
package zeph.http;

import java.io.InputStream;
import java.util.function.Function;
import zeph.http.HttpParser;
import zeph.http.HttpRequest;
import zeph.http.HttpResponse;
import zeph.http.ProtocolHandler;
import zeph.logging.Logger;

public class Http1Handler
implements ProtocolHandler {
    private static final Logger log = new Logger(Http1Handler.class);
    private static final int MAX_REQUESTS_PER_CONNECTION = 1000;
    private final HttpParser parser = new HttpParser();
    private final Function<HttpRequest, HttpResponse> handler;
    private final int serverPort;
    private final boolean streamingMode;
    private boolean keepAlive = true;
    private boolean closed = false;
    private Runnable completionCallback;
    private int requestCount = 0;
    private InputStream streamingBody;
    private boolean useChunkedEncoding;
    private byte[] streamingBuffer;
    private static final int STREAMING_BUFFER_SIZE = 16384;
    private HttpResponse pendingResponse;
    private byte[] pendingWrite;
    private HttpResponse lastResponse;

    public Http1Handler(Function<HttpRequest, HttpResponse> handler, int serverPort, boolean streamingMode) {
        this(handler, serverPort, streamingMode, -1L);
    }

    public Http1Handler(Function<HttpRequest, HttpResponse> handler, int serverPort, boolean streamingMode, long maxBodySize) {
        this.parser.setStreamingMode(streamingMode);
        this.parser.setMaxBodySize(maxBodySize);
        this.handler = handler;
        this.serverPort = serverPort;
        this.streamingMode = streamingMode;
    }

    public Http1Handler(int serverPort, boolean streamingMode) {
        this.parser.setStreamingMode(streamingMode);
        this.handler = null;
        this.serverPort = serverPort;
        this.streamingMode = streamingMode;
    }

    public ParseResult parse(byte[] data, int offset, int length) {
        HttpParser.Result result = this.parser.parse(data, offset, length);
        switch (result) {
            case NEED_MORE_DATA: {
                return ParseResult.NEED_MORE_DATA;
            }
            case HEADERS_COMPLETE: {
                return ParseResult.HEADERS_COMPLETE;
            }
            case COMPLETE: {
                return ParseResult.REQUEST_COMPLETE;
            }
            case ERROR: {
                return ParseResult.ERROR;
            }
        }
        return ParseResult.NEED_MORE_DATA;
    }

    public HttpRequest getRequest() {
        HttpRequest request = this.parser.getRequest();
        if (request != null) {
            request.setServerPort(this.serverPort);
        }
        return request;
    }

    public boolean isH2cUpgradeRequest(HttpRequest request) {
        String upgrade = request.getHeader("upgrade");
        String http2Settings = request.getHeader("http2-settings");
        String connection = request.getHeader("connection");
        return "h2c".equalsIgnoreCase(upgrade) && http2Settings != null && connection != null && connection.toLowerCase().contains("upgrade");
    }

    public HttpResponse handleRequest(HttpRequest request) {
        HttpResponse response;
        ++this.requestCount;
        this.keepAlive = request.isKeepAlive();
        if (this.requestCount >= 1000) {
            this.keepAlive = false;
        }
        try {
            response = this.handler.apply(request);
        }
        catch (Exception e) {
            log.error("Handler exception for " + String.valueOf((Object)request.getMethod()) + " " + request.getUri(), e);
            response = HttpResponse.serverError();
        }
        if (this.keepAlive) {
            response.setHeader("Connection", "keep-alive");
        } else {
            response.setHeader("Connection", "close");
        }
        this.lastResponse = response;
        return response;
    }

    public HttpResponse handleRequest(HttpRequest request, Function<HttpRequest, HttpResponse> externalHandler) {
        HttpResponse response;
        ++this.requestCount;
        this.keepAlive = request.isKeepAlive();
        if (this.requestCount >= 1000) {
            this.keepAlive = false;
        }
        try {
            response = externalHandler.apply(request);
        }
        catch (Exception e) {
            log.error("Handler exception for " + String.valueOf((Object)request.getMethod()) + " " + request.getUri(), e);
            response = HttpResponse.serverError();
        }
        if (this.keepAlive) {
            response.setHeader("Connection", "keep-alive");
        } else {
            response.setHeader("Connection", "close");
        }
        this.lastResponse = response;
        return response;
    }

    public HttpResponse getLastResponse() {
        return this.lastResponse;
    }

    public void startStreaming(HttpResponse response) {
        this.streamingBody = response.getBodyStream();
        this.useChunkedEncoding = response.getContentLength() < 0L;
        this.streamingBuffer = new byte[16384];
    }

    public void reset() {
        this.parser.reset();
        this.pendingResponse = null;
        this.pendingWrite = null;
        this.lastResponse = null;
    }

    public void setStreamingMode(boolean enabled) {
        this.parser.setStreamingMode(enabled);
    }

    @Override
    public byte[] processData(byte[] data, int offset, int length) {
        ParseResult result = this.parse(data, offset, length);
        if (result == ParseResult.REQUEST_COMPLETE) {
            HttpRequest request = this.getRequest();
            HttpResponse response = this.handleRequest(request);
            this.reset();
            return response.encode();
        }
        return null;
    }

    @Override
    public boolean hasPendingWrite() {
        return this.pendingWrite != null;
    }

    @Override
    public byte[] getPendingWrite() {
        byte[] write = this.pendingWrite;
        this.pendingWrite = null;
        return write;
    }

    @Override
    public boolean hasPendingStreaming() {
        return this.streamingBody != null;
    }

    @Override
    public byte[] continueStreaming() {
        if (this.streamingBody == null) {
            return null;
        }
        try {
            int n = this.streamingBody.read(this.streamingBuffer);
            if (n <= 0) {
                this.streamingBody.close();
                this.streamingBody = null;
                if (this.useChunkedEncoding) {
                    return "0\r\n\r\n".getBytes();
                }
                return null;
            }
            if (this.useChunkedEncoding) {
                String header = Integer.toHexString(n) + "\r\n";
                byte[] headerBytes = header.getBytes();
                byte[] footer = "\r\n".getBytes();
                byte[] chunk = new byte[headerBytes.length + n + footer.length];
                System.arraycopy(headerBytes, 0, chunk, 0, headerBytes.length);
                System.arraycopy(this.streamingBuffer, 0, chunk, headerBytes.length, n);
                System.arraycopy(footer, 0, chunk, headerBytes.length + n, footer.length);
                return chunk;
            }
            byte[] chunk = new byte[n];
            System.arraycopy(this.streamingBuffer, 0, chunk, 0, n);
            return chunk;
        }
        catch (Exception e) {
            try {
                this.streamingBody.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.streamingBody = null;
            return null;
        }
    }

    @Override
    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    @Override
    public boolean isOpen() {
        return !this.closed;
    }

    @Override
    public String getProtocol() {
        return "HTTP/1.1";
    }

    @Override
    public byte[] close() {
        this.closed = true;
        if (this.streamingBody != null) {
            try {
                this.streamingBody.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.streamingBody = null;
        }
        return null;
    }

    @Override
    public void setCompletionCallback(Runnable callback) {
        this.completionCallback = callback;
    }

    public HttpParser getParser() {
        return this.parser;
    }

    public boolean isStreamingMode() {
        return this.streamingMode;
    }

    public static enum ParseResult {
        NEED_MORE_DATA,
        HEADERS_COMPLETE,
        REQUEST_COMPLETE,
        UPGRADE_H2C,
        ERROR;

    }
}

