/*
 * Decompiled with CFR 0.152.
 */
package zeph.http;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import zeph.http2.Http2ServerHandler;

public class H2cUpgradeHelper {
    private static final byte[] SWITCHING_PROTOCOLS_RESPONSE = "HTTP/1.1 101 Switching Protocols\r\nConnection: Upgrade\r\nUpgrade: h2c\r\n\r\n".getBytes(StandardCharsets.US_ASCII);

    public static byte[] getSwitchingProtocolsResponse() {
        return (byte[])SWITCHING_PROTOCOLS_RESPONSE.clone();
    }

    public static byte[] buildServerPreface(Http2ServerHandler http2Handler) {
        try {
            ByteBuffer output = ByteBuffer.allocate(1024);
            http2Handler.getConnection().writeServerPreface(output);
            output.flip();
            byte[] result = new byte[output.remaining()];
            output.get(result);
            return result;
        }
        catch (Exception e) {
            return new byte[0];
        }
    }

    public static byte[] buildUpgradeResponse(Http2ServerHandler http2Handler) {
        byte[] switchBytes = SWITCHING_PROTOCOLS_RESPONSE;
        byte[] prefaceBytes = H2cUpgradeHelper.buildServerPreface(http2Handler);
        byte[] combined = new byte[switchBytes.length + prefaceBytes.length];
        System.arraycopy(switchBytes, 0, combined, 0, switchBytes.length);
        System.arraycopy(prefaceBytes, 0, combined, switchBytes.length, prefaceBytes.length);
        return combined;
    }

    public static byte[] buildUpgradeResponseWithData(Http2ServerHandler http2Handler, byte[] http2Response) {
        byte[] switchBytes = SWITCHING_PROTOCOLS_RESPONSE;
        byte[] prefaceBytes = H2cUpgradeHelper.buildServerPreface(http2Handler);
        byte[] combined = new byte[switchBytes.length + prefaceBytes.length + http2Response.length];
        System.arraycopy(switchBytes, 0, combined, 0, switchBytes.length);
        System.arraycopy(prefaceBytes, 0, combined, switchBytes.length, prefaceBytes.length);
        System.arraycopy(http2Response, 0, combined, switchBytes.length + prefaceBytes.length, http2Response.length);
        return combined;
    }
}

