/*
 * Decompiled with CFR 0.152.
 */
package zeph.http;

import java.util.concurrent.ConcurrentLinkedQueue;

public class ByteArrayPool {
    private static final int[] SIZE_CLASSES = new int[]{4096, 8192, 16384, 32768, 65536, 262144, 0x100000};
    private static final int MAX_POOLED_SIZE = 0x100000;
    private static final int MAX_POOL_SIZE = 32;
    private final ConcurrentLinkedQueue<byte[]>[] pools = new ConcurrentLinkedQueue[SIZE_CLASSES.length];
    private static final ByteArrayPool INSTANCE = new ByteArrayPool();

    public static ByteArrayPool getInstance() {
        return INSTANCE;
    }

    private ByteArrayPool() {
        for (int i = 0; i < SIZE_CLASSES.length; ++i) {
            this.pools[i] = new ConcurrentLinkedQueue();
        }
    }

    public byte[] acquire(int minSize) {
        if (minSize > 0x100000) {
            return new byte[minSize];
        }
        int classIndex = this.getSizeClassIndex(minSize);
        byte[] array = this.pools[classIndex].poll();
        if (array != null) {
            return array;
        }
        return new byte[SIZE_CLASSES[classIndex]];
    }

    public void release(byte[] array) {
        ConcurrentLinkedQueue<byte[]> pool;
        if (array == null || array.length > 0x100000) {
            return;
        }
        int classIndex = this.getExactSizeClassIndex(array.length);
        if (classIndex >= 0 && (pool = this.pools[classIndex]).size() < 32) {
            pool.offer(array);
        }
    }

    private int getSizeClassIndex(int size) {
        for (int i = 0; i < SIZE_CLASSES.length; ++i) {
            if (SIZE_CLASSES[i] < size) continue;
            return i;
        }
        return SIZE_CLASSES.length - 1;
    }

    private int getExactSizeClassIndex(int size) {
        for (int i = 0; i < SIZE_CLASSES.length; ++i) {
            if (SIZE_CLASSES[i] != size) continue;
            return i;
        }
        return -1;
    }

    public void clear() {
        for (ConcurrentLinkedQueue<byte[]> pool : this.pools) {
            pool.clear();
        }
    }

    public String getStats() {
        StringBuilder sb = new StringBuilder("ByteArrayPool stats:\n");
        for (int i = 0; i < SIZE_CLASSES.length; ++i) {
            sb.append("  ").append(SIZE_CLASSES[i]).append("B: ").append(this.pools[i].size()).append(" cached\n");
        }
        return sb.toString();
    }
}

