/*
 * Decompiled with CFR 0.152.
 */
package zeph.config;

import java.util.ArrayList;

public class ConfigValidator {
    public static final int MIN_PORT = 1;
    public static final int MAX_PORT = 65535;
    public static final int MIN_PRIVILEGED_PORT = 1024;
    public static final int MIN_WORKERS = 1;
    public static final int MAX_WORKERS = 1024;
    public static final int MIN_BUFFER_SIZE = 1024;
    public static final int MAX_BUFFER_SIZE = 0x1000000;
    public static final int MIN_RING_SIZE = 16;
    public static final int MAX_RING_SIZE = 32768;

    public static void validatePort(int port) {
        if (port < 1 || port > 65535) {
            throw new IllegalArgumentException("Port must be between 1 and 65535, got: " + port);
        }
    }

    public static String validatePortWithWarning(int port) {
        ConfigValidator.validatePort(port);
        if (port < 1024) {
            return "Using privileged port " + port + " (requires root/admin privileges)";
        }
        return null;
    }

    public static void validateWorkerCount(int workers) {
        if (workers < 1) {
            throw new IllegalArgumentException("Worker count must be at least 1, got: " + workers);
        }
        if (workers > 1024) {
            throw new IllegalArgumentException("Worker count exceeds maximum 1024, got: " + workers);
        }
    }

    public static String validateWorkerCountWithRecommendation(int workers) {
        ConfigValidator.validateWorkerCount(workers);
        int cpus = Runtime.getRuntime().availableProcessors();
        if (workers > cpus * 2) {
            return "Worker count " + workers + " exceeds 2x CPU count (" + cpus + "), may cause excessive context switching";
        }
        return null;
    }

    public static void validateBufferSize(int size) {
        if (size < 1024) {
            throw new IllegalArgumentException("Buffer size must be at least 1024 bytes, got: " + size);
        }
        if (size > 0x1000000) {
            throw new IllegalArgumentException("Buffer size exceeds maximum 16777216 bytes, got: " + size);
        }
    }

    public static void validateRingSize(int size) {
        if (size < 16) {
            throw new IllegalArgumentException("Ring size must be at least 16, got: " + size);
        }
        if (size > 32768) {
            throw new IllegalArgumentException("Ring size exceeds maximum 32768, got: " + size);
        }
        if ((size & size - 1) != 0) {
            throw new IllegalArgumentException("Ring size should be a power of 2 for optimal performance, got: " + size);
        }
    }

    public static void validateIpAddress(String ip) {
        if (ip == null || ip.isEmpty()) {
            throw new IllegalArgumentException("IP address cannot be null or empty");
        }
        if (ip.equals("0.0.0.0") || ip.equals("::") || ip.equals("localhost")) {
            return;
        }
        if (ip.matches("^\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}$")) {
            String[] parts;
            for (String part : parts = ip.split("\\.")) {
                int value = Integer.parseInt(part);
                if (value >= 0 && value <= 255) continue;
                throw new IllegalArgumentException("Invalid IPv4 address: " + ip);
            }
            return;
        }
        if (ip.contains(":")) {
            return;
        }
        throw new IllegalArgumentException("Invalid IP address format: " + ip);
    }

    public static void validateHttp2InitialWindowSize(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("HTTP/2 initial window size cannot be negative: " + size);
        }
        if (size > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("HTTP/2 initial window size exceeds maximum: " + size);
        }
    }

    public static void validateTimeout(long timeoutMs, String name) {
        if (timeoutMs < 0L) {
            throw new IllegalArgumentException(name + " timeout cannot be negative: " + timeoutMs);
        }
        if (timeoutMs > 86400000L) {
            throw new IllegalArgumentException(name + " timeout exceeds 24 hours, likely a mistake: " + timeoutMs);
        }
    }

    public static String[] validateServerConfig(String ip, int port, int workers, int ringSize) {
        String workerWarning;
        ArrayList<String> warnings = new ArrayList<String>();
        ConfigValidator.validateIpAddress(ip);
        String portWarning = ConfigValidator.validatePortWithWarning(port);
        if (portWarning != null) {
            warnings.add(portWarning);
        }
        if ((workerWarning = ConfigValidator.validateWorkerCountWithRecommendation(workers)) != null) {
            warnings.add(workerWarning);
        }
        ConfigValidator.validateRingSize(ringSize);
        return warnings.toArray(new String[0]);
    }
}

