/*
 * Decompiled with CFR 0.152.
 */
package zeph.client;

import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

public class HttpClientResponse {
    private static final Map<Integer, String> STATUS_MESSAGES = new HashMap<Integer, String>();
    private final int status;
    private final String statusMessage;
    private final Map<String, String> headers;
    private final byte[] body;
    private final InputStream bodyStream;
    private final Exception error;
    private final Map<String, Object> opts;
    private final String protocol;

    public HttpClientResponse(int status, String statusMessage, Map<String, String> headers, byte[] body, Map<String, Object> opts) {
        this(status, statusMessage, headers, body, opts, "HTTP/1.1");
    }

    public HttpClientResponse(int status, String statusMessage, Map<String, String> headers, byte[] body, Map<String, Object> opts, String protocol) {
        this.status = status;
        this.statusMessage = statusMessage;
        this.headers = headers;
        this.body = body;
        this.bodyStream = null;
        this.error = null;
        this.opts = opts;
        this.protocol = protocol;
    }

    public HttpClientResponse(int status, String statusMessage, Map<String, String> headers, InputStream bodyStream, Map<String, Object> opts, String protocol) {
        this.status = status;
        this.statusMessage = statusMessage;
        this.headers = headers;
        this.body = null;
        this.bodyStream = bodyStream;
        this.error = null;
        this.opts = opts;
        this.protocol = protocol;
    }

    public HttpClientResponse(Exception error, Map<String, Object> opts) {
        this.status = -1;
        this.statusMessage = null;
        this.headers = null;
        this.body = null;
        this.bodyStream = null;
        this.error = error;
        this.opts = opts;
        this.protocol = null;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public int getStatus() {
        return this.status;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public String getHeader(String name) {
        if (this.headers == null) {
            return null;
        }
        return this.headers.get(name.toLowerCase());
    }

    public byte[] getBody() {
        return this.body;
    }

    public InputStream getBodyStream() {
        return this.bodyStream;
    }

    public String getBodyAsString() {
        if (this.body == null) {
            return null;
        }
        return new String(this.body, StandardCharsets.UTF_8);
    }

    public Exception getError() {
        return this.error;
    }

    public boolean hasError() {
        return this.error != null;
    }

    public Map<String, Object> getOpts() {
        return this.opts;
    }

    public boolean isKeepAlive() {
        if (this.headers == null) {
            return false;
        }
        String connection = this.headers.get("connection");
        if (connection != null) {
            if (connection.toLowerCase().contains("close")) {
                return false;
            }
            if (connection.toLowerCase().contains("keep-alive")) {
                return true;
            }
        }
        return true;
    }

    public boolean isRedirect() {
        return this.status == 301 || this.status == 302 || this.status == 303 || this.status == 307 || this.status == 308;
    }

    public boolean isSuccess() {
        return this.status >= 200 && this.status < 300;
    }

    public boolean isClientError() {
        return this.status >= 400 && this.status < 500;
    }

    public boolean isServerError() {
        return this.status >= 500 && this.status < 600;
    }

    public String toString() {
        if (this.error != null) {
            return "HttpClientResponse{error=" + this.error.getMessage() + "}";
        }
        return "HttpClientResponse{status=" + this.status + ", bodyLength=" + (this.body != null ? this.body.length : 0) + "}";
    }

    public void printTrace(boolean detail, int requestId, long elapsedMs) {
        this.printTrace(detail, requestId, elapsedMs, 2000L);
    }

    public void printTrace(boolean detail, int requestId, long elapsedMs, long traceLimit) {
        if (this.error != null) {
            System.err.println("<=== [" + String.format("%02d", requestId) + "] ERROR: " + this.error.getMessage() + " " + elapsedMs + "ms");
            return;
        }
        String msg = this.statusMessage;
        if (msg == null || msg.isEmpty()) {
            msg = STATUS_MESSAGES.getOrDefault(this.status, "");
        }
        String proto = this.protocol != null ? this.protocol : "HTTP/1.1";
        System.err.println("<=== [" + String.format("%02d", requestId) + "] " + proto + " " + this.status + " " + msg + " " + elapsedMs + "ms");
        if (detail && this.headers != null) {
            for (Map.Entry<String, String> entry : this.headers.entrySet()) {
                System.err.println(entry.getKey() + ": " + entry.getValue());
            }
            System.err.println();
            System.err.println();
            if (this.body != null && this.body.length > 0) {
                String bodyStr = this.getBodyAsString();
                if (traceLimit > 0L && (long)bodyStr.length() > traceLimit) {
                    System.err.println("[Response body: " + this.body.length + " bytes, use -L 0 to show full body]");
                } else {
                    System.err.println(bodyStr);
                }
            }
            System.err.println();
            System.err.println();
        }
    }

    static {
        STATUS_MESSAGES.put(100, "Continue");
        STATUS_MESSAGES.put(101, "Switching Protocols");
        STATUS_MESSAGES.put(102, "Processing");
        STATUS_MESSAGES.put(103, "Early Hints");
        STATUS_MESSAGES.put(200, "OK");
        STATUS_MESSAGES.put(201, "Created");
        STATUS_MESSAGES.put(202, "Accepted");
        STATUS_MESSAGES.put(203, "Non-Authoritative Information");
        STATUS_MESSAGES.put(204, "No Content");
        STATUS_MESSAGES.put(205, "Reset Content");
        STATUS_MESSAGES.put(206, "Partial Content");
        STATUS_MESSAGES.put(207, "Multi-Status");
        STATUS_MESSAGES.put(208, "Already Reported");
        STATUS_MESSAGES.put(226, "IM Used");
        STATUS_MESSAGES.put(300, "Multiple Choices");
        STATUS_MESSAGES.put(301, "Moved Permanently");
        STATUS_MESSAGES.put(302, "Found");
        STATUS_MESSAGES.put(303, "See Other");
        STATUS_MESSAGES.put(304, "Not Modified");
        STATUS_MESSAGES.put(305, "Use Proxy");
        STATUS_MESSAGES.put(307, "Temporary Redirect");
        STATUS_MESSAGES.put(308, "Permanent Redirect");
        STATUS_MESSAGES.put(400, "Bad Request");
        STATUS_MESSAGES.put(401, "Unauthorized");
        STATUS_MESSAGES.put(402, "Payment Required");
        STATUS_MESSAGES.put(403, "Forbidden");
        STATUS_MESSAGES.put(404, "Not Found");
        STATUS_MESSAGES.put(405, "Method Not Allowed");
        STATUS_MESSAGES.put(406, "Not Acceptable");
        STATUS_MESSAGES.put(407, "Proxy Authentication Required");
        STATUS_MESSAGES.put(408, "Request Timeout");
        STATUS_MESSAGES.put(409, "Conflict");
        STATUS_MESSAGES.put(410, "Gone");
        STATUS_MESSAGES.put(411, "Length Required");
        STATUS_MESSAGES.put(412, "Precondition Failed");
        STATUS_MESSAGES.put(413, "Payload Too Large");
        STATUS_MESSAGES.put(414, "URI Too Long");
        STATUS_MESSAGES.put(415, "Unsupported Media Type");
        STATUS_MESSAGES.put(416, "Range Not Satisfiable");
        STATUS_MESSAGES.put(417, "Expectation Failed");
        STATUS_MESSAGES.put(418, "I'm a teapot");
        STATUS_MESSAGES.put(421, "Misdirected Request");
        STATUS_MESSAGES.put(422, "Unprocessable Entity");
        STATUS_MESSAGES.put(423, "Locked");
        STATUS_MESSAGES.put(424, "Failed Dependency");
        STATUS_MESSAGES.put(425, "Too Early");
        STATUS_MESSAGES.put(426, "Upgrade Required");
        STATUS_MESSAGES.put(428, "Precondition Required");
        STATUS_MESSAGES.put(429, "Too Many Requests");
        STATUS_MESSAGES.put(431, "Request Header Fields Too Large");
        STATUS_MESSAGES.put(451, "Unavailable For Legal Reasons");
        STATUS_MESSAGES.put(500, "Internal Server Error");
        STATUS_MESSAGES.put(501, "Not Implemented");
        STATUS_MESSAGES.put(502, "Bad Gateway");
        STATUS_MESSAGES.put(503, "Service Unavailable");
        STATUS_MESSAGES.put(504, "Gateway Timeout");
        STATUS_MESSAGES.put(505, "HTTP Version Not Supported");
        STATUS_MESSAGES.put(506, "Variant Also Negotiates");
        STATUS_MESSAGES.put(507, "Insufficient Storage");
        STATUS_MESSAGES.put(508, "Loop Detected");
        STATUS_MESSAGES.put(510, "Not Extended");
        STATUS_MESSAGES.put(511, "Network Authentication Required");
    }
}

