/*
 * Decompiled with CFR 0.152.
 */
package zeph.client;

import clojure.lang.Named;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;

public class HttpClientRequest {
    private String method = "GET";
    private String url;
    private String host;
    private int port;
    private String path;
    private String queryString;
    private boolean secure;
    private Map<String, String> headers = new HashMap<String, String>();
    private byte[] body;
    private InputStream bodyStream;
    private File bodyFile;
    private List<MultipartPart> streamingMultipart;
    private String multipartBoundary;
    private long totalContentLength;
    private List<Map<String, Object>> pendingMultipartParts;
    private int timeout = 30000;
    private int keepalive = 120000;
    private boolean followRedirects = true;
    private int maxRedirects = 5;
    private boolean insecure = false;
    private String[] basicAuth;
    private boolean trace;
    private boolean traceDetail;
    private long traceLimit = 2000L;
    private boolean progress;
    private Map<String, Object> opts;
    private static final byte[] CRLF = "\r\n".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] HEADER_SEP = ": ".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] SPACE = " ".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] HTTP_11 = " HTTP/1.1\r\n".getBytes(StandardCharsets.US_ASCII);
    private static final AtomicInteger requestIdCounter = new AtomicInteger(1);
    private int traceRequestId;

    public HttpClientRequest url(String url) {
        this.url = url;
        try {
            URI uri = URI.create(url);
            this.secure = "https".equalsIgnoreCase(uri.getScheme());
            this.host = uri.getHost();
            this.port = uri.getPort();
            if (this.port < 0) {
                this.port = this.secure ? 443 : 80;
            }
            this.path = uri.getRawPath();
            if (this.path == null || this.path.isEmpty()) {
                this.path = "/";
            }
            this.queryString = uri.getRawQuery();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid URL: " + url, e);
        }
        return this;
    }

    public HttpClientRequest method(String method) {
        this.method = method.toUpperCase();
        return this;
    }

    public HttpClientRequest header(String name, String value) {
        this.headers.put(name, value);
        return this;
    }

    public HttpClientRequest headers(Map<?, ?> headers) {
        if (headers != null) {
            for (Map.Entry<?, ?> entry : headers.entrySet()) {
                String key = entry.getKey() instanceof Named ? ((Named)entry.getKey()).getName() : entry.getKey().toString();
                String value = entry.getValue() != null ? entry.getValue().toString() : "";
                this.headers.put(key, value);
            }
        }
        return this;
    }

    public HttpClientRequest body(byte[] body) {
        this.body = body;
        return this;
    }

    public HttpClientRequest body(String body) {
        this.body = body != null ? body.getBytes(StandardCharsets.UTF_8) : null;
        return this;
    }

    public HttpClientRequest body(InputStream stream) {
        this.bodyStream = stream;
        return this;
    }

    public HttpClientRequest body(File file) {
        this.bodyFile = file;
        if (file != null && file.exists()) {
            this.totalContentLength = file.length();
        }
        return this;
    }

    public HttpClientRequest bodyFile(String path) {
        return this.body(new File(path));
    }

    public HttpClientRequest timeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    public HttpClientRequest keepalive(int keepalive) {
        this.keepalive = keepalive;
        return this;
    }

    public HttpClientRequest followRedirects(boolean follow) {
        this.followRedirects = follow;
        return this;
    }

    public HttpClientRequest maxRedirects(int max) {
        this.maxRedirects = max;
        return this;
    }

    public HttpClientRequest insecure(boolean insecure) {
        this.insecure = insecure;
        return this;
    }

    public HttpClientRequest basicAuth(String user, String password) {
        this.basicAuth = new String[]{user, password};
        return this;
    }

    public HttpClientRequest trace(boolean trace) {
        this.trace = trace;
        return this;
    }

    public HttpClientRequest traceDetail(boolean traceDetail) {
        this.traceDetail = traceDetail;
        if (traceDetail) {
            this.trace = true;
        }
        return this;
    }

    public HttpClientRequest traceLimit(long traceLimit) {
        this.traceLimit = traceLimit;
        return this;
    }

    public HttpClientRequest progress(boolean progress) {
        this.progress = progress;
        return this;
    }

    public HttpClientRequest queryParams(Map<?, ?> params) {
        if (params != null && !params.isEmpty()) {
            boolean first;
            StringBuilder sb = new StringBuilder();
            boolean bl = first = this.queryString == null || this.queryString.isEmpty();
            if (!first) {
                sb.append(this.queryString).append("&");
            }
            for (Map.Entry<?, ?> entry : params.entrySet()) {
                if (!first) {
                    sb.append("&");
                }
                String key = entry.getKey() instanceof Named ? ((Named)entry.getKey()).getName() : entry.getKey().toString();
                String value = entry.getValue() != null ? entry.getValue().toString() : "";
                sb.append(URLEncoder.encode(key, StandardCharsets.UTF_8)).append("=").append(URLEncoder.encode(value, StandardCharsets.UTF_8));
                first = false;
            }
            this.queryString = sb.toString();
        }
        return this;
    }

    public HttpClientRequest formParams(Map<?, ?> params) {
        if (params != null && !params.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (Map.Entry<?, ?> entry : params.entrySet()) {
                if (!first) {
                    sb.append("&");
                }
                String key = entry.getKey() instanceof Named ? ((Named)entry.getKey()).getName() : entry.getKey().toString();
                String value = entry.getValue() != null ? entry.getValue().toString() : "";
                sb.append(URLEncoder.encode(key, StandardCharsets.UTF_8)).append("=").append(URLEncoder.encode(value, StandardCharsets.UTF_8));
                first = false;
            }
            this.body = sb.toString().getBytes(StandardCharsets.UTF_8);
            this.headers.put("Content-Type", "application/x-www-form-urlencoded");
        }
        return this;
    }

    public HttpClientRequest multipart(List<?> parts) {
        if (parts == null || parts.isEmpty()) {
            return this;
        }
        String boundary = "----ZephBoundary" + UUID.randomUUID().toString().replace("-", "");
        this.multipartBoundary = boundary;
        boolean hasLargeFile = false;
        for (Object partObj : parts) {
            File file;
            Map part;
            Object content;
            if (!(partObj instanceof Map) || !((content = this.getMapValue(part = (Map)partObj, "content")) instanceof File) || (file = (File)content).length() <= 0x100000L) continue;
            hasLargeFile = true;
            break;
        }
        if (hasLargeFile) {
            return this.multipartStreaming(parts, boundary);
        }
        return this.multipartBuffered(parts, boundary);
    }

    public HttpClientRequest multipart(String name, String value) {
        if (this.pendingMultipartParts == null) {
            this.pendingMultipartParts = new ArrayList<Map<String, Object>>();
        }
        HashMap<String, String> part = new HashMap<String, String>();
        part.put("name", name);
        part.put("content", value);
        this.pendingMultipartParts.add(part);
        return this;
    }

    public HttpClientRequest multipartFile(String name, File file, String contentType) {
        if (this.pendingMultipartParts == null) {
            this.pendingMultipartParts = new ArrayList<Map<String, Object>>();
        }
        HashMap<String, Object> part = new HashMap<String, Object>();
        part.put("name", name);
        part.put("content", file);
        part.put("filename", file.getName());
        if (contentType != null) {
            part.put("content-type", contentType);
        }
        this.pendingMultipartParts.add(part);
        return this;
    }

    public HttpClientRequest multipartFile(String name, File file) {
        return this.multipartFile(name, file, null);
    }

    private HttpClientRequest multipartStreaming(List<?> parts, String boundary) {
        this.streamingMultipart = new ArrayList<MultipartPart>();
        long totalLength = 0L;
        try {
            for (Object partObj : parts) {
                long contentLength;
                Map part;
                Object nameObj;
                if (!(partObj instanceof Map) || (nameObj = this.getMapValue(part = (Map)partObj, "name")) == null) continue;
                String name = nameObj.toString();
                Object content = this.getMapValue(part, "content");
                if (content == null) continue;
                Object filenameObj = this.getMapValue(part, "filename");
                String filename = filenameObj != null ? filenameObj.toString() : null;
                Object contentTypeObj = this.getMapValue(part, "content-type");
                String contentType = contentTypeObj != null ? contentTypeObj.toString() : null;
                ByteArrayOutputStream headerOut = new ByteArrayOutputStream();
                headerOut.write(("--" + boundary + "\r\n").getBytes(StandardCharsets.UTF_8));
                StringBuilder disposition = new StringBuilder();
                disposition.append("Content-Disposition: form-data; name=\"").append(name).append("\"");
                if (content instanceof File) {
                    File file = (File)content;
                    String fname = filename != null ? filename : file.getName();
                    disposition.append("; filename=\"").append(fname).append("\"");
                    contentLength = file.length();
                    if (contentType == null) {
                        contentType = this.guessContentType(fname);
                    }
                } else if (content instanceof byte[]) {
                    if (filename != null) {
                        disposition.append("; filename=\"").append(filename).append("\"");
                    }
                    contentLength = ((byte[])content).length;
                } else {
                    byte[] bytes = content.toString().getBytes(StandardCharsets.UTF_8);
                    content = bytes;
                    contentLength = bytes.length;
                    if (contentType == null) {
                        contentType = "text/plain; charset=UTF-8";
                    }
                }
                disposition.append("\r\n");
                headerOut.write(disposition.toString().getBytes(StandardCharsets.UTF_8));
                if (contentType != null) {
                    headerOut.write(("Content-Type: " + contentType + "\r\n").getBytes(StandardCharsets.UTF_8));
                }
                headerOut.write("\r\n".getBytes(StandardCharsets.UTF_8));
                byte[] headerBytes = headerOut.toByteArray();
                totalLength += (long)headerBytes.length + contentLength + 2L;
                this.streamingMultipart.add(new MultipartPart(name, content, filename, contentType, headerBytes, contentLength));
            }
            byte[] finalBoundary = ("--" + boundary + "--\r\n").getBytes(StandardCharsets.UTF_8);
            this.totalContentLength = totalLength += (long)finalBoundary.length;
            this.headers.put("Content-Type", "multipart/form-data; boundary=" + boundary);
            this.headers.put("Content-Length", String.valueOf(totalLength));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to build streaming multipart", e);
        }
        return this;
    }

    private HttpClientRequest multipartBuffered(List<?> parts, String boundary) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            for (Object partObj : parts) {
                byte[] contentBytes;
                Map part;
                Object nameObj;
                if (!(partObj instanceof Map) || (nameObj = this.getMapValue(part = (Map)partObj, "name")) == null) continue;
                String name = nameObj.toString();
                Object content = this.getMapValue(part, "content");
                if (content == null) continue;
                Object filenameObj = this.getMapValue(part, "filename");
                String filename = filenameObj != null ? filenameObj.toString() : null;
                Object contentTypeObj = this.getMapValue(part, "content-type");
                String contentType = contentTypeObj != null ? contentTypeObj.toString() : null;
                out.write(("--" + boundary + "\r\n").getBytes(StandardCharsets.UTF_8));
                StringBuilder disposition = new StringBuilder();
                disposition.append("Content-Disposition: form-data; name=\"").append(name).append("\"");
                if (content instanceof File) {
                    File file = (File)content;
                    String fname = filename != null ? filename : file.getName();
                    disposition.append("; filename=\"").append(fname).append("\"");
                    contentBytes = this.readFile(file);
                    if (contentType == null) {
                        contentType = this.guessContentType(fname);
                    }
                } else if (content instanceof InputStream) {
                    if (filename != null) {
                        disposition.append("; filename=\"").append(filename).append("\"");
                    }
                    contentBytes = this.readInputStream((InputStream)content);
                    if (contentType == null && filename != null) {
                        contentType = this.guessContentType(filename);
                    }
                } else if (content instanceof byte[]) {
                    if (filename != null) {
                        disposition.append("; filename=\"").append(filename).append("\"");
                    }
                    contentBytes = (byte[])content;
                } else {
                    contentBytes = content.toString().getBytes(StandardCharsets.UTF_8);
                    if (contentType == null) {
                        contentType = "text/plain; charset=UTF-8";
                    }
                }
                disposition.append("\r\n");
                out.write(disposition.toString().getBytes(StandardCharsets.UTF_8));
                if (contentType != null) {
                    out.write(("Content-Type: " + contentType + "\r\n").getBytes(StandardCharsets.UTF_8));
                }
                out.write("\r\n".getBytes(StandardCharsets.UTF_8));
                out.write(contentBytes);
                out.write("\r\n".getBytes(StandardCharsets.UTF_8));
            }
            out.write(("--" + boundary + "--\r\n").getBytes(StandardCharsets.UTF_8));
            this.body = out.toByteArray();
            this.headers.put("Content-Type", "multipart/form-data; boundary=" + boundary);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to build multipart body", e);
        }
        return this;
    }

    private Object getMapValue(Map<?, ?> map, String key) {
        Object value = map.get(key);
        if (value != null) {
            return value;
        }
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            Object k = entry.getKey();
            if (!(k instanceof Named) || !((Named)k).getName().equals(key)) continue;
            return entry.getValue();
        }
        return null;
    }

    private byte[] readFile(File file) throws Exception {
        try (FileInputStream fis = new FileInputStream(file);){
            byte[] byArray = fis.readAllBytes();
            return byArray;
        }
    }

    private byte[] readInputStream(InputStream is) throws Exception {
        int bytesRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[8192];
        while ((bytesRead = is.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, bytesRead);
        }
        return buffer.toByteArray();
    }

    private String guessContentType(String filename) {
        if (filename == null) {
            return "application/octet-stream";
        }
        String lower = filename.toLowerCase();
        if (lower.endsWith(".jar")) {
            return "application/java-archive";
        }
        if (lower.endsWith(".zip")) {
            return "application/zip";
        }
        if (lower.endsWith(".json")) {
            return "application/json";
        }
        if (lower.endsWith(".xml")) {
            return "application/xml";
        }
        if (lower.endsWith(".txt")) {
            return "text/plain";
        }
        if (lower.endsWith(".html") || lower.endsWith(".htm")) {
            return "text/html";
        }
        if (lower.endsWith(".css")) {
            return "text/css";
        }
        if (lower.endsWith(".js")) {
            return "application/javascript";
        }
        if (lower.endsWith(".png")) {
            return "image/png";
        }
        if (lower.endsWith(".jpg") || lower.endsWith(".jpeg")) {
            return "image/jpeg";
        }
        if (lower.endsWith(".gif")) {
            return "image/gif";
        }
        if (lower.endsWith(".pdf")) {
            return "application/pdf";
        }
        if (lower.endsWith(".raml")) {
            return "application/raml+yaml";
        }
        if (lower.endsWith(".yaml") || lower.endsWith(".yml")) {
            return "application/yaml";
        }
        return "application/octet-stream";
    }

    public HttpClientRequest opts(Map<String, Object> opts) {
        this.opts = opts;
        return this;
    }

    public String getMethod() {
        return this.method;
    }

    public String getUrl() {
        return this.url;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getPath() {
        return this.path;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public byte[] getBody() {
        if (this.pendingMultipartParts != null && !this.pendingMultipartParts.isEmpty()) {
            this.multipart(this.pendingMultipartParts);
            this.pendingMultipartParts = null;
        }
        return this.body;
    }

    public boolean hasStreamingBody() {
        if (this.bodyStream != null || this.bodyFile != null) {
            return true;
        }
        if (this.streamingMultipart != null && !this.streamingMultipart.isEmpty()) {
            return true;
        }
        if (this.pendingMultipartParts != null) {
            for (Map<String, Object> part : this.pendingMultipartParts) {
                File file;
                Object content = part.get("content");
                if (!(content instanceof File) || (file = (File)content).length() <= 0x100000L) continue;
                return true;
            }
        }
        return false;
    }

    public InputStream getBodyStream() {
        if (this.bodyStream != null) {
            return this.bodyStream;
        }
        if (this.bodyFile != null) {
            try {
                return new FileInputStream(this.bodyFile);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to open file: " + String.valueOf(this.bodyFile), e);
            }
        }
        return null;
    }

    public File getBodyFile() {
        return this.bodyFile;
    }

    public boolean hasKnownBodyLength() {
        if (this.bodyFile != null) {
            return true;
        }
        if (this.bodyStream != null) {
            return this.headers.containsKey("Content-Length") || this.headers.containsKey("content-length");
        }
        return this.body != null;
    }

    public List<MultipartPart> getStreamingMultipart() {
        if (this.pendingMultipartParts != null && !this.pendingMultipartParts.isEmpty()) {
            this.multipart(this.pendingMultipartParts);
            this.pendingMultipartParts = null;
        }
        return this.streamingMultipart;
    }

    public String getMultipartBoundary() {
        if (this.pendingMultipartParts != null && !this.pendingMultipartParts.isEmpty()) {
            this.multipart(this.pendingMultipartParts);
            this.pendingMultipartParts = null;
        }
        return this.multipartBoundary;
    }

    public long getTotalContentLength() {
        if (this.pendingMultipartParts != null && !this.pendingMultipartParts.isEmpty()) {
            this.multipart(this.pendingMultipartParts);
            this.pendingMultipartParts = null;
        }
        return this.totalContentLength;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int getKeepalive() {
        return this.keepalive;
    }

    public boolean isFollowRedirects() {
        return this.followRedirects;
    }

    public int getMaxRedirects() {
        return this.maxRedirects;
    }

    public boolean isInsecure() {
        return this.insecure;
    }

    public String[] getBasicAuth() {
        return this.basicAuth;
    }

    public boolean isTrace() {
        return this.trace;
    }

    public boolean isTraceDetail() {
        return this.traceDetail;
    }

    public long getTraceLimit() {
        return this.traceLimit;
    }

    public boolean isProgress() {
        return this.progress;
    }

    public Map<String, Object> getOpts() {
        return this.opts;
    }

    public String getPoolKey() {
        return this.host + ":" + this.port + (this.secure ? ":s" : "");
    }

    public List<String[]> buildHttp1Headers() {
        if (this.pendingMultipartParts != null && !this.pendingMultipartParts.isEmpty()) {
            this.multipart(this.pendingMultipartParts);
            this.pendingMultipartParts = null;
        }
        ArrayList<String[]> headerList = new ArrayList<String[]>();
        headerList.add(new String[]{"Host", this.getHostHeader()});
        if (this.bodyFile != null) {
            headerList.add(new String[]{"Content-Length", String.valueOf(this.bodyFile.length())});
        } else if (this.bodyStream != null) {
            if (!this.headers.containsKey("Content-Length") && !this.headers.containsKey("content-length")) {
                headerList.add(new String[]{"Transfer-Encoding", "chunked"});
            }
        } else if (this.hasStreamingBody()) {
            headerList.add(new String[]{"Content-Length", String.valueOf(this.totalContentLength)});
        } else if (this.body != null && this.body.length > 0) {
            headerList.add(new String[]{"Content-Length", String.valueOf(this.body.length)});
        }
        if (!this.headers.containsKey("User-Agent") && !this.headers.containsKey("user-agent")) {
            headerList.add(new String[]{"User-Agent", "Zeph/1.0"});
        }
        if (this.keepalive > 0) {
            headerList.add(new String[]{"Connection", "keep-alive"});
        } else {
            headerList.add(new String[]{"Connection", "close"});
        }
        if (this.basicAuth != null) {
            String credentials = this.basicAuth[0] + ":" + this.basicAuth[1];
            String encoded = Base64.getEncoder().encodeToString(credentials.getBytes(StandardCharsets.UTF_8));
            headerList.add(new String[]{"Authorization", "Basic " + encoded});
        }
        for (Map.Entry<String, String> entry : this.headers.entrySet()) {
            String key = entry.getKey().toLowerCase();
            if (key.equals("host") || key.equals("content-length") || key.equals("transfer-encoding") || key.equals("connection") || key.equals("authorization") && this.basicAuth != null) continue;
            headerList.add(new String[]{entry.getKey(), entry.getValue()});
        }
        if (!this.headers.containsKey("Accept") && !this.headers.containsKey("accept")) {
            headerList.add(new String[]{"Accept", "*/*"});
        }
        return headerList;
    }

    public byte[] encode() {
        if (this.pendingMultipartParts != null && !this.pendingMultipartParts.isEmpty()) {
            this.multipart(this.pendingMultipartParts);
            this.pendingMultipartParts = null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream(512);
        try {
            out.write(this.method.getBytes(StandardCharsets.US_ASCII));
            out.write(SPACE);
            out.write(this.path.getBytes(StandardCharsets.US_ASCII));
            if (this.queryString != null && !this.queryString.isEmpty()) {
                out.write(63);
                out.write(this.queryString.getBytes(StandardCharsets.US_ASCII));
            }
            out.write(HTTP_11);
            this.writeHeader(out, "Host", this.getHostHeader());
            if (this.bodyFile != null) {
                this.writeHeader(out, "Content-Length", String.valueOf(this.bodyFile.length()));
            } else if (this.bodyStream != null) {
                if (!this.headers.containsKey("Content-Length") && !this.headers.containsKey("content-length")) {
                    this.writeHeader(out, "Transfer-Encoding", "chunked");
                }
            } else if (this.hasStreamingBody()) {
                this.writeHeader(out, "Content-Length", String.valueOf(this.totalContentLength));
            } else if (this.body != null && this.body.length > 0) {
                this.writeHeader(out, "Content-Length", String.valueOf(this.body.length));
            }
            if (!this.headers.containsKey("User-Agent") && !this.headers.containsKey("user-agent")) {
                this.writeHeader(out, "User-Agent", "Zeph/1.0");
            }
            if (this.keepalive > 0) {
                this.writeHeader(out, "Connection", "keep-alive");
            } else {
                this.writeHeader(out, "Connection", "close");
            }
            if (this.basicAuth != null) {
                String credentials = this.basicAuth[0] + ":" + this.basicAuth[1];
                String encoded = Base64.getEncoder().encodeToString(credentials.getBytes(StandardCharsets.UTF_8));
                this.writeHeader(out, "Authorization", "Basic " + encoded);
            }
            for (Map.Entry<String, String> entry : this.headers.entrySet()) {
                String key = entry.getKey().toLowerCase();
                if (key.equals("host") || key.equals("content-length") || key.equals("transfer-encoding") || key.equals("connection") || key.equals("authorization") && this.basicAuth != null) continue;
                this.writeHeader(out, entry.getKey(), entry.getValue());
            }
            if (!this.headers.containsKey("Accept") && !this.headers.containsKey("accept")) {
                this.writeHeader(out, "Accept", "*/*");
            }
            out.write(CRLF);
            if (!this.hasStreamingBody() && this.body != null && this.body.length > 0) {
                out.write(this.body);
            }
            return out.toByteArray();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to encode request", e);
        }
    }

    private void writeHeader(ByteArrayOutputStream out, String name, String value) throws Exception {
        out.write(name.getBytes(StandardCharsets.US_ASCII));
        out.write(HEADER_SEP);
        out.write(value.getBytes(StandardCharsets.US_ASCII));
        out.write(CRLF);
    }

    private String getHostHeader() {
        if (this.secure && this.port == 443 || !this.secure && this.port == 80) {
            return this.host;
        }
        return this.host + ":" + this.port;
    }

    public String toString() {
        return this.method + " " + this.url;
    }

    public void printTrace(String protocol, List<String[]> actualHeaders) {
        if (!this.trace) {
            return;
        }
        this.traceRequestId = requestIdCounter.getAndIncrement();
        System.err.println("===> [" + String.format("%02d", this.traceRequestId) + "] " + protocol + " " + this.method + " " + this.url);
        if (this.traceDetail) {
            if (actualHeaders != null) {
                for (String[] header : actualHeaders) {
                    if (header.length < 2 || header[0].startsWith(":")) continue;
                    System.err.println(header[0] + ": " + header[1]);
                }
            }
            System.err.println();
            System.err.println();
            if (this.body != null && this.body.length > 0) {
                String bodyStr = new String(this.body, StandardCharsets.UTF_8);
                if ((long)bodyStr.length() > this.traceLimit && this.traceLimit > 0L) {
                    System.err.println("[Request body: " + this.body.length + " bytes]");
                } else {
                    System.err.println(bodyStr);
                }
            } else {
                System.err.println("--- No body ---");
            }
            System.err.println();
            System.err.println();
        }
    }

    @Deprecated
    public void printTrace(String protocol) {
        this.printTrace(protocol, null);
    }

    public int getTraceRequestId() {
        return this.traceRequestId;
    }

    public String getRequestUri() {
        if (this.queryString != null && !this.queryString.isEmpty()) {
            return this.path + "?" + this.queryString;
        }
        return this.path;
    }

    public static HttpClientRequest get(String url) {
        return new HttpClientRequest().method("GET").url(url);
    }

    public static HttpClientRequest post(String url) {
        return new HttpClientRequest().method("POST").url(url);
    }

    public static HttpClientRequest put(String url) {
        return new HttpClientRequest().method("PUT").url(url);
    }

    public static HttpClientRequest delete(String url) {
        return new HttpClientRequest().method("DELETE").url(url);
    }

    public static HttpClientRequest head(String url) {
        return new HttpClientRequest().method("HEAD").url(url);
    }

    public static class MultipartPart {
        public final String name;
        public final Object content;
        public final String filename;
        public final String contentType;
        public final byte[] headerBytes;
        public final long contentLength;

        public MultipartPart(String name, Object content, String filename, String contentType, byte[] headerBytes, long contentLength) {
            this.name = name;
            this.content = content;
            this.filename = filename;
            this.contentType = contentType;
            this.headerBytes = headerBytes;
            this.contentLength = contentLength;
        }
    }
}

