/*
 * Decompiled with CFR 0.152.
 */
package zeph.client;

import java.util.concurrent.atomic.AtomicInteger;

public class HttpClientConnectionPool
implements AutoCloseable {
    private final int maxConnectionsPerHost;
    private final int maxTotalConnections;
    private final long idleTimeout;
    private final long connectionTimeout;
    private final AtomicInteger activeConnections = new AtomicInteger(0);

    public HttpClientConnectionPool() {
        this(20, 200, 60000L, 30000L);
    }

    public HttpClientConnectionPool(int maxConnectionsPerHost, int maxTotalConnections, long idleTimeout, long connectionTimeout) {
        this.maxConnectionsPerHost = maxConnectionsPerHost;
        this.maxTotalConnections = maxTotalConnections;
        this.idleTimeout = idleTimeout;
        this.connectionTimeout = connectionTimeout;
    }

    public Stats getStats() {
        int active = this.activeConnections.get();
        return new Stats(0, 0, active, active);
    }

    public void incrementActive() {
        this.activeConnections.incrementAndGet();
    }

    public void decrementActive() {
        this.activeConnections.decrementAndGet();
    }

    public int getMaxConnectionsPerHost() {
        return this.maxConnectionsPerHost;
    }

    public int getMaxTotalConnections() {
        return this.maxTotalConnections;
    }

    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    public long getConnectionTimeout() {
        return this.connectionTimeout;
    }

    @Override
    public void close() {
        this.activeConnections.set(0);
    }

    public record Stats(int hosts, int idle, int inUse, long total) {
        @Override
        public String toString() {
            return String.format("HttpClientConnectionPool[hosts=%d, idle=%d, inUse=%d, total=%d]", this.hosts, this.idle, this.inUse, this.total);
        }
    }
}

