/*
 * Decompiled with CFR 0.152.
 */
package zeph.client;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import zeph.client.HttpClientResponse;
import zeph.client.HttpResponseParser;

public class Http1ClientHandler {
    private final HttpResponseParser parser = new HttpResponseParser();

    public ParseResult parse(byte[] data, int offset, int length) {
        HttpResponseParser.Result result = this.parser.parse(data, offset, length);
        switch (result) {
            case COMPLETE: {
                return ParseResult.RESPONSE_COMPLETE;
            }
            case HEADERS_COMPLETE: {
                return ParseResult.HEADERS_COMPLETE;
            }
            case NEED_MORE_DATA: {
                return ParseResult.NEED_MORE_DATA;
            }
        }
        return ParseResult.ERROR;
    }

    public ParseResult feedBodyData(byte[] data, int offset, int length) {
        HttpResponseParser.Result result = this.parser.feedStreamData(data, offset, length);
        switch (result) {
            case COMPLETE: {
                return ParseResult.RESPONSE_COMPLETE;
            }
            case NEED_MORE_DATA: {
                return ParseResult.NEED_MORE_DATA;
            }
        }
        return ParseResult.ERROR;
    }

    public ResponseResult buildResponse(Map<String, Object> opts) {
        HttpClientResponse response = new HttpClientResponse(this.parser.getStatusCode(), this.parser.getStatusMessage(), new HashMap<String, String>(this.parser.getHeaders()), this.parser.getBody(), opts, this.parser.getHttpVersion());
        boolean isRedirect = this.parser.isRedirect();
        String redirectLocation = isRedirect ? this.parser.getRedirectLocation() : null;
        boolean keepAlive = this.parser.isKeepAlive();
        return new ResponseResult(response, isRedirect, redirectLocation, keepAlive);
    }

    public int getStatusCode() {
        return this.parser.getStatusCode();
    }

    public String getStatusMessage() {
        return this.parser.getStatusMessage();
    }

    public Map<String, String> getHeaders() {
        return this.parser.getHeaders();
    }

    public String getHeader(String name) {
        return this.parser.getHeader(name);
    }

    public byte[] getBody() {
        return this.parser.getBody();
    }

    public boolean isRedirect() {
        return this.parser.isRedirect();
    }

    public String getRedirectLocation() {
        return this.parser.getRedirectLocation();
    }

    public boolean isKeepAlive() {
        return this.parser.isKeepAlive();
    }

    public String getErrorMessage() {
        return this.parser.getErrorMessage();
    }

    public void reset() {
        this.parser.reset();
    }

    public HttpResponseParser getParser() {
        return this.parser;
    }

    public void setStreamingMode(boolean streaming) {
        this.parser.setStreamingMode(streaming);
    }

    public boolean isStreamingMode() {
        return this.parser.isStreamingMode();
    }

    public boolean isStreamingBody() {
        return this.parser.isStreamingBody();
    }

    public InputStream getBodyStream() {
        return this.parser.getBodyStream();
    }

    public void markStreamComplete() {
        this.parser.markStreamComplete();
    }

    public void markStreamError(IOException e) {
        this.parser.markStreamError(e);
    }

    public ResponseResult buildStreamingResponse(Map<String, Object> opts) {
        HttpClientResponse response = new HttpClientResponse(this.parser.getStatusCode(), this.parser.getStatusMessage(), new HashMap<String, String>(this.parser.getHeaders()), this.parser.getBodyStream(), opts, this.parser.getHttpVersion());
        boolean isRedirect = this.parser.isRedirect();
        String redirectLocation = isRedirect ? this.parser.getRedirectLocation() : null;
        boolean keepAlive = this.parser.isKeepAlive();
        return new ResponseResult(response, isRedirect, redirectLocation, keepAlive);
    }

    public static enum ParseResult {
        NEED_MORE_DATA,
        HEADERS_COMPLETE,
        RESPONSE_COMPLETE,
        ERROR;

    }

    public static class ResponseResult {
        private final HttpClientResponse response;
        private final boolean isRedirect;
        private final String redirectLocation;
        private final boolean keepAlive;

        public ResponseResult(HttpClientResponse response, boolean isRedirect, String redirectLocation, boolean keepAlive) {
            this.response = response;
            this.isRedirect = isRedirect;
            this.redirectLocation = redirectLocation;
            this.keepAlive = keepAlive;
        }

        public HttpClientResponse getResponse() {
            return this.response;
        }

        public boolean isRedirect() {
            return this.isRedirect;
        }

        public String getRedirectLocation() {
            return this.redirectLocation;
        }

        public boolean isKeepAlive() {
            return this.keepAlive;
        }
    }
}

