/*
 * Decompiled with CFR 0.152.
 */
package zeph.buffer;

import java.util.Arrays;

public class DynamicBytes {
    private byte[] data;
    private int idx;
    private static final byte[] CRLF = new byte[]{13, 10};
    private static final byte[] COLON_SPACE = new byte[]{58, 32};

    public DynamicBytes(int initialCapacity) {
        this.data = new byte[initialCapacity];
        this.idx = 0;
    }

    public DynamicBytes() {
        this(256);
    }

    private void expandIfNeeded(int more) {
        long need = (long)this.idx + (long)more;
        if ((long)this.data.length < need) {
            long newLength = this.data.length + (this.data.length >> 1);
            if (newLength < need) {
                newLength = need + (need >> 2);
            }
            this.data = Arrays.copyOf(this.data, (int)Math.min(newLength, 0x7FFFFFF7L));
        }
    }

    public DynamicBytes append(byte[] bytes) {
        return this.append(bytes, 0, bytes.length);
    }

    public DynamicBytes append(byte[] bytes, int offset, int length) {
        this.expandIfNeeded(length);
        System.arraycopy(bytes, offset, this.data, this.idx, length);
        this.idx += length;
        return this;
    }

    public DynamicBytes append(String str) {
        if (str == null) {
            return this;
        }
        int length = str.length();
        this.expandIfNeeded(length);
        for (int i = 0; i < length; ++i) {
            char c = str.charAt(i);
            this.data[this.idx++] = c < '\u0080' ? (int)c : 63;
        }
        return this;
    }

    public DynamicBytes append(byte b) {
        this.expandIfNeeded(1);
        this.data[this.idx++] = b;
        return this;
    }

    public DynamicBytes crlf() {
        return this.append(CRLF);
    }

    public DynamicBytes appendHeader(String key, String value) {
        this.append(key);
        this.append(COLON_SPACE);
        this.append(value);
        return this.crlf();
    }

    public DynamicBytes appendInt(int value) {
        if (value < 0) {
            this.append((byte)45);
            value = -value;
        }
        if (value == 0) {
            return this.append((byte)48);
        }
        int digits = 0;
        for (int temp = value; temp > 0; temp /= 10) {
            ++digits;
        }
        this.expandIfNeeded(digits);
        int pos = this.idx + digits - 1;
        while (value > 0) {
            this.data[pos--] = (byte)(48 + value % 10);
            value /= 10;
        }
        this.idx += digits;
        return this;
    }

    public DynamicBytes appendLong(long value) {
        if (value < 0L) {
            this.append((byte)45);
            value = -value;
        }
        if (value == 0L) {
            return this.append((byte)48);
        }
        int digits = 0;
        for (long temp = value; temp > 0L; temp /= 10L) {
            ++digits;
        }
        this.expandIfNeeded(digits);
        int pos = this.idx + digits - 1;
        while (value > 0L) {
            this.data[pos--] = (byte)(48L + value % 10L);
            value /= 10L;
        }
        this.idx += digits;
        return this;
    }

    public byte[] get() {
        return this.data;
    }

    public int length() {
        return this.idx;
    }

    public void reset() {
        this.idx = 0;
    }

    public byte[] toByteArray() {
        return Arrays.copyOf(this.data, this.idx);
    }
}

