(ns zeph.ring
  "Ultra high-performance Ring adapter for Zeph HTTP server.
   Uses Java-based RingAdapter for minimal overhead."
  (:import [zeph.ring RingAdapter]
           [zeph.http HttpRequest HttpResponse]
           [clojure.lang IPersistentMap]))

(defn wrap-ring-handler
  "Wrap a Ring handler for use with Zeph HttpServer.
   Returns a java.util.function.Function.

   Uses Java-based RingAdapter for maximum performance."
  [handler]
  (let [error-resp (RingAdapter/errorResponse)]
    (reify java.util.function.Function
      (apply [_ req]
        (try
          (let [ring-req (RingAdapter/buildRequestMap ^HttpRequest req)
                ring-resp (handler ring-req)]
            (if (instance? IPersistentMap ring-resp)
              (RingAdapter/buildResponse ^IPersistentMap ring-resp)
              ;; Fallback for non-map responses
              (RingAdapter/buildResponse
                (RingAdapter/errorResponse))))
          (catch Throwable t
            (binding [*out* *err*]
              (println "Handler error:" (.getMessage t)))
            (RingAdapter/buildResponse error-resp)))))))
