/*
 * Decompiled with CFR 0.152.
 */
package zeph.uring;

import java.lang.foreign.Arena;
import java.lang.foreign.FunctionDescriptor;
import java.lang.foreign.Linker;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.StructLayout;
import java.lang.foreign.SymbolLookup;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class Socket {
    public static final int AF_INET = 2;
    public static final int AF_INET6 = 10;
    public static final int SOCK_STREAM = 1;
    public static final int SOCK_DGRAM = 2;
    public static final int SOCK_NONBLOCK = 2048;
    public static final int SOCK_CLOEXEC = 524288;
    public static final int SOL_SOCKET = 1;
    public static final int SO_REUSEADDR = 2;
    public static final int SO_REUSEPORT = 15;
    public static final int SO_KEEPALIVE = 9;
    public static final int IPPROTO_TCP = 6;
    public static final int TCP_NODELAY = 1;
    public static final int ACCEPT4_NONBLOCK = 2048;
    public static final int ACCEPT4_CLOEXEC = 524288;
    public static final StructLayout SOCKADDR_IN_LAYOUT = MemoryLayout.structLayout(ValueLayout.JAVA_SHORT.withName("sin_family"), ValueLayout.JAVA_SHORT.withName("sin_port"), ValueLayout.JAVA_INT.withName("sin_addr"), MemoryLayout.sequenceLayout(8L, ValueLayout.JAVA_BYTE).withName("sin_zero")).withName("sockaddr_in");
    public static final StructLayout SOCKADDR_IN6_LAYOUT = MemoryLayout.structLayout(ValueLayout.JAVA_SHORT.withName("sin6_family"), ValueLayout.JAVA_SHORT.withName("sin6_port"), ValueLayout.JAVA_INT.withName("sin6_flowinfo"), MemoryLayout.sequenceLayout(16L, ValueLayout.JAVA_BYTE).withName("sin6_addr"), ValueLayout.JAVA_INT.withName("sin6_scope_id")).withName("sockaddr_in6");
    private static final Linker LINKER = Linker.nativeLinker();
    private static final SymbolLookup LIBC = Linker.nativeLinker().defaultLookup();
    private static final MethodHandle socket_mh;
    private static final MethodHandle bind_mh;
    private static final MethodHandle listen_mh;
    private static final MethodHandle close_mh;
    private static final MethodHandle setsockopt_mh;
    private static final MethodHandle fcntl_mh;
    private static final MethodHandle htons_mh;
    private static final MethodHandle htonl_mh;
    private static final MethodHandle inet_pton_mh;
    private static final MethodHandle strerror_mh;
    private static final MethodHandle errno_location_mh;
    private static final int F_GETFL = 3;
    private static final int F_SETFL = 4;
    private static final int O_NONBLOCK = 2048;

    private static String getLastError() {
        try {
            MemorySegment errnoPtr = errno_location_mh.invokeExact();
            int errno = errnoPtr.reinterpret(4L).get(ValueLayout.JAVA_INT, 0L);
            MemorySegment msgPtr = strerror_mh.invokeExact(errno);
            String msg = msgPtr.reinterpret(256L).getString(0L);
            return errno + " (" + msg + ")";
        }
        catch (Throwable t) {
            return "unknown";
        }
    }

    public static int socket(int domain, int type, int protocol) throws Exception {
        try {
            int fd = socket_mh.invokeExact(domain, type, protocol);
            if (fd < 0) {
                throw new Exception("socket() failed with error: " + -fd);
            }
            return fd;
        }
        catch (Throwable t) {
            throw new Exception("socket() failed", t);
        }
    }

    public static int createServerSocket() throws Exception {
        return Socket.socket(2, 526337, 0);
    }

    public static void bind(int sockfd, String ip, int port, Arena arena) throws Exception {
        short networkPort;
        MemorySegment addr = arena.allocate(SOCKADDR_IN_LAYOUT);
        addr.fill((byte)0);
        addr.set(ValueLayout.JAVA_SHORT, 0L, (short)2);
        try {
            networkPort = htons_mh.invokeExact((short)port);
        }
        catch (Throwable t) {
            throw new Exception("htons() failed", t);
        }
        addr.set(ValueLayout.JAVA_SHORT, 2L, networkPort);
        if (ip.equals("0.0.0.0")) {
            addr.set(ValueLayout.JAVA_INT, 4L, 0);
        } else {
            try (Arena tempArena = Arena.ofConfined();){
                MemorySegment ipStr = tempArena.allocateFrom(ip);
                MemorySegment addrSlice = addr.asSlice(4L, 4L);
                int result = inet_pton_mh.invokeExact(2, ipStr, addrSlice);
                if (result != 1) {
                    throw new Exception("Invalid IP address: " + ip);
                }
            }
            catch (Throwable t) {
                throw new Exception("inet_pton() failed", t);
            }
        }
        try {
            int result = bind_mh.invokeExact(sockfd, addr, (int)SOCKADDR_IN_LAYOUT.byteSize());
            if (result < 0) {
                throw new Exception("bind() failed: " + Socket.getLastError() + " (sockfd=" + sockfd + ", port=" + port + ")");
            }
        }
        catch (Throwable t) {
            if (t instanceof Exception && t.getMessage() != null && t.getMessage().startsWith("bind()")) {
                throw (Exception)t;
            }
            throw new Exception("bind() failed", t);
        }
    }

    public static void listen(int sockfd, int backlog) throws Exception {
        try {
            int result = listen_mh.invokeExact(sockfd, backlog);
            if (result < 0) {
                throw new Exception("listen() failed with error: " + -result);
            }
        }
        catch (Throwable t) {
            throw new Exception("listen() failed", t);
        }
    }

    public static void close(int fd) throws Exception {
        try {
            int result = close_mh.invokeExact(fd);
            if (result < 0) {
                throw new Exception("close() failed with error: " + -result);
            }
        }
        catch (Throwable t) {
            throw new Exception("close() failed", t);
        }
    }

    public static void setOption(int sockfd, int level, int optname, int value, Arena arena) throws Exception {
        MemorySegment optval = arena.allocate(ValueLayout.JAVA_INT);
        optval.set(ValueLayout.JAVA_INT, 0L, value);
        try {
            int result = setsockopt_mh.invokeExact(sockfd, level, optname, optval, (int)ValueLayout.JAVA_INT.byteSize());
            if (result < 0) {
                throw new Exception("setsockopt() failed with error: " + -result);
            }
        }
        catch (Throwable t) {
            throw new Exception("setsockopt() failed", t);
        }
    }

    public static void setNonBlocking(int fd) throws Exception {
        try {
            int flags = fcntl_mh.invokeExact(fd, 3, 0);
            if (flags < 0) {
                throw new Exception("fcntl(F_GETFL) failed");
            }
            int result = fcntl_mh.invokeExact(fd, 4, flags | 0x800);
            if (result < 0) {
                throw new Exception("fcntl(F_SETFL) failed");
            }
        }
        catch (Throwable t) {
            throw new Exception("setNonBlocking() failed", t);
        }
    }

    public static void setReuseAddr(int sockfd, Arena arena) throws Exception {
        Socket.setOption(sockfd, 1, 2, 1, arena);
    }

    public static void setReusePort(int sockfd, Arena arena) throws Exception {
        Socket.setOption(sockfd, 1, 15, 1, arena);
    }

    public static void setTcpNoDelay(int sockfd, Arena arena) throws Exception {
        Socket.setOption(sockfd, 6, 1, 1, arena);
    }

    public static int createClientSocket() throws Exception {
        return Socket.socket(2, 526337, 0);
    }

    public static MemorySegment createSockAddr(Arena arena, String ip, int port) throws Exception {
        short networkPort;
        MemorySegment addr = arena.allocate(SOCKADDR_IN_LAYOUT);
        addr.fill((byte)0);
        addr.set(ValueLayout.JAVA_SHORT, 0L, (short)2);
        try {
            networkPort = htons_mh.invokeExact((short)port);
        }
        catch (Throwable t) {
            throw new Exception("htons() failed", t);
        }
        addr.set(ValueLayout.JAVA_SHORT, 2L, networkPort);
        try (Arena tempArena = Arena.ofConfined();){
            MemorySegment ipStr = tempArena.allocateFrom(ip);
            MemorySegment addrSlice = addr.asSlice(4L, 4L);
            int result = inet_pton_mh.invokeExact(2, ipStr, addrSlice);
            if (result != 1) {
                throw new Exception("Invalid IP address: " + ip);
            }
        }
        catch (Throwable t) {
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            throw new Exception("inet_pton() failed", t);
        }
        return addr;
    }

    public static int getSockAddrInSize() {
        return (int)SOCKADDR_IN_LAYOUT.byteSize();
    }

    public static String resolveHost(String hostname) throws Exception {
        try {
            InetAddress addr = InetAddress.getByName(hostname);
            return addr.getHostAddress();
        }
        catch (UnknownHostException e) {
            throw new Exception("Failed to resolve hostname: " + hostname, e);
        }
    }

    public static void setKeepAlive(int sockfd, Arena arena) throws Exception {
        Socket.setOption(sockfd, 1, 9, 1, arena);
    }

    static {
        try {
            socket_mh = LINKER.downcallHandle(LIBC.find("socket").orElseThrow(), FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT), new Linker.Option[0]);
            bind_mh = LINKER.downcallHandle(LIBC.find("bind").orElseThrow(), FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.JAVA_INT), new Linker.Option[0]);
            listen_mh = LINKER.downcallHandle(LIBC.find("listen").orElseThrow(), FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT), new Linker.Option[0]);
            close_mh = LINKER.downcallHandle(LIBC.find("close").orElseThrow(), FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.JAVA_INT), new Linker.Option[0]);
            setsockopt_mh = LINKER.downcallHandle(LIBC.find("setsockopt").orElseThrow(), FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.JAVA_INT), new Linker.Option[0]);
            fcntl_mh = LINKER.downcallHandle(LIBC.find("fcntl").orElseThrow(), FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT), Linker.Option.firstVariadicArg(2));
            htons_mh = LINKER.downcallHandle(LIBC.find("htons").orElseThrow(), FunctionDescriptor.of(ValueLayout.JAVA_SHORT, ValueLayout.JAVA_SHORT), new Linker.Option[0]);
            htonl_mh = LINKER.downcallHandle(LIBC.find("htonl").orElseThrow(), FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.JAVA_INT), new Linker.Option[0]);
            inet_pton_mh = LINKER.downcallHandle(LIBC.find("inet_pton").orElseThrow(), FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.ADDRESS), new Linker.Option[0]);
            errno_location_mh = LINKER.downcallHandle(LIBC.find("__errno_location").orElseThrow(), FunctionDescriptor.of(ValueLayout.ADDRESS, new MemoryLayout[0]), new Linker.Option[0]);
            strerror_mh = LINKER.downcallHandle(LIBC.find("strerror").orElseThrow(), FunctionDescriptor.of(ValueLayout.ADDRESS, ValueLayout.JAVA_INT), new Linker.Option[0]);
        }
        catch (Throwable t) {
            throw new ExceptionInInitializerError(t);
        }
    }
}

