/*
 * Decompiled with CFR 0.152.
 */
package zeph.uring;

import java.lang.foreign.MemorySegment;
import zeph.uring.IoUring;

public class IoUringTest {
    public static void main(String[] args) {
        System.out.println("Testing io_uring initialization...");
        System.out.println("Java version: " + System.getProperty("java.version"));
        System.out.println("OS: " + System.getProperty("os.name"));
        try (IoUring ring = new IoUring(256, 0);){
            System.out.println("io_uring initialized successfully!");
            System.out.println("Ring FD: " + ring.getRingFd());
            System.out.println("SQ entries: " + ring.getSqEntries());
            System.out.println("CQ entries: " + ring.getCqEntries());
            System.out.println("Features: 0x" + Integer.toHexString(ring.getFeatures()));
            System.out.println("\nTesting NOP operation...");
            MemorySegment sqe = ring.getSqe();
            if (sqe != null) {
                ring.prepareNop(sqe, 12345L);
                ring.submit();
                int submitted = ring.enter(1, 1, 1);
                System.out.println("Submitted: " + submitted);
                MemorySegment cqe = ring.peekCqe();
                if (cqe != null) {
                    long userData = IoUring.getUserData(cqe);
                    int result = IoUring.getResult(cqe);
                    System.out.println("CQE user_data: " + userData);
                    System.out.println("CQE result: " + result);
                    ring.advanceCq();
                    System.out.println("NOP test passed!");
                } else {
                    System.out.println("No CQE available");
                }
            } else {
                System.out.println("Could not get SQE");
            }
            System.out.println("\nAll tests passed!");
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
            e.printStackTrace();
        }
    }
}

