/*
 * Decompiled with CFR 0.152.
 */
package zeph.uring;

import java.lang.foreign.Arena;
import java.lang.foreign.FunctionDescriptor;
import java.lang.foreign.Linker;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.StructLayout;
import java.lang.foreign.SymbolLookup;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.VarHandle;

public class IoUring
implements AutoCloseable {
    private static final long SYS_io_uring_setup = 425L;
    private static final long SYS_io_uring_enter = 426L;
    private static final long SYS_io_uring_register = 427L;
    private static final long SYS_eventfd2 = 290L;
    public static final int EFD_NONBLOCK = 2048;
    public static final int EFD_SEMAPHORE = 1;
    public static final int IORING_SETUP_IOPOLL = 1;
    public static final int IORING_SETUP_SQPOLL = 2;
    public static final int IORING_SETUP_SQ_AFF = 4;
    public static final int IORING_SETUP_CQSIZE = 8;
    public static final int IORING_SETUP_CLAMP = 16;
    public static final int IORING_SETUP_ATTACH_WQ = 32;
    public static final int IORING_SETUP_R_DISABLED = 64;
    public static final int IORING_SETUP_SUBMIT_ALL = 128;
    public static final int IORING_SETUP_COOP_TASKRUN = 256;
    public static final int IORING_SETUP_TASKRUN_FLAG = 512;
    public static final int IORING_SETUP_SQE128 = 1024;
    public static final int IORING_SETUP_CQE32 = 2048;
    public static final int IORING_SETUP_SINGLE_ISSUER = 4096;
    public static final int IORING_SETUP_DEFER_TASKRUN = 8192;
    public static final int IORING_ENTER_GETEVENTS = 1;
    public static final int IORING_ENTER_SQ_WAKEUP = 2;
    public static final int IORING_ENTER_SQ_WAIT = 4;
    public static final int IORING_ENTER_EXT_ARG = 8;
    public static final int IORING_ENTER_REGISTERED_RING = 16;
    public static final byte IORING_OP_NOP = 0;
    public static final byte IORING_OP_READV = 1;
    public static final byte IORING_OP_WRITEV = 2;
    public static final byte IORING_OP_FSYNC = 3;
    public static final byte IORING_OP_READ_FIXED = 4;
    public static final byte IORING_OP_WRITE_FIXED = 5;
    public static final byte IORING_OP_POLL_ADD = 6;
    public static final byte IORING_OP_POLL_REMOVE = 7;
    public static final byte IORING_OP_SYNC_FILE_RANGE = 8;
    public static final byte IORING_OP_SENDMSG = 9;
    public static final byte IORING_OP_RECVMSG = 10;
    public static final byte IORING_OP_TIMEOUT = 11;
    public static final byte IORING_OP_TIMEOUT_REMOVE = 12;
    public static final byte IORING_OP_ACCEPT = 13;
    public static final byte IORING_OP_ASYNC_CANCEL = 14;
    public static final byte IORING_OP_LINK_TIMEOUT = 15;
    public static final byte IORING_OP_CONNECT = 16;
    public static final byte IORING_OP_FALLOCATE = 17;
    public static final byte IORING_OP_OPENAT = 18;
    public static final byte IORING_OP_CLOSE = 19;
    public static final byte IORING_OP_FILES_UPDATE = 20;
    public static final byte IORING_OP_STATX = 21;
    public static final byte IORING_OP_READ = 22;
    public static final byte IORING_OP_WRITE = 23;
    public static final byte IORING_OP_FADVISE = 24;
    public static final byte IORING_OP_MADVISE = 25;
    public static final byte IORING_OP_SEND = 26;
    public static final byte IORING_OP_RECV = 27;
    public static final byte IORING_OP_OPENAT2 = 28;
    public static final byte IORING_OP_EPOLL_CTL = 29;
    public static final byte IORING_OP_SPLICE = 30;
    public static final byte IORING_OP_PROVIDE_BUFFERS = 31;
    public static final byte IORING_OP_REMOVE_BUFFERS = 32;
    public static final byte IORING_OP_TEE = 33;
    public static final byte IORING_OP_SHUTDOWN = 34;
    public static final byte IORING_OP_RENAMEAT = 35;
    public static final byte IORING_OP_UNLINKAT = 36;
    public static final byte IORING_OP_MKDIRAT = 37;
    public static final byte IORING_OP_SYMLINKAT = 38;
    public static final byte IORING_OP_LINKAT = 39;
    public static final byte IORING_OP_MSG_RING = 40;
    public static final byte IORING_OP_SOCKET = 45;
    public static final byte IOSQE_FIXED_FILE = 1;
    public static final byte IOSQE_IO_DRAIN = 2;
    public static final byte IOSQE_IO_LINK = 4;
    public static final byte IOSQE_IO_HARDLINK = 8;
    public static final byte IOSQE_ASYNC = 16;
    public static final byte IOSQE_BUFFER_SELECT = 32;
    public static final StructLayout IO_URING_PARAMS_LAYOUT = MemoryLayout.structLayout(ValueLayout.JAVA_INT.withName("sq_entries"), ValueLayout.JAVA_INT.withName("cq_entries"), ValueLayout.JAVA_INT.withName("flags"), ValueLayout.JAVA_INT.withName("sq_thread_cpu"), ValueLayout.JAVA_INT.withName("sq_thread_idle"), ValueLayout.JAVA_INT.withName("features"), ValueLayout.JAVA_INT.withName("wq_fd"), MemoryLayout.sequenceLayout(3L, ValueLayout.JAVA_INT).withName("resv"), ValueLayout.JAVA_INT.withName("sq_off_head"), ValueLayout.JAVA_INT.withName("sq_off_tail"), ValueLayout.JAVA_INT.withName("sq_off_ring_mask"), ValueLayout.JAVA_INT.withName("sq_off_ring_entries"), ValueLayout.JAVA_INT.withName("sq_off_flags"), ValueLayout.JAVA_INT.withName("sq_off_dropped"), ValueLayout.JAVA_INT.withName("sq_off_array"), ValueLayout.JAVA_INT.withName("sq_off_resv1"), ValueLayout.JAVA_LONG.withName("sq_off_user_addr"), ValueLayout.JAVA_INT.withName("cq_off_head"), ValueLayout.JAVA_INT.withName("cq_off_tail"), ValueLayout.JAVA_INT.withName("cq_off_ring_mask"), ValueLayout.JAVA_INT.withName("cq_off_ring_entries"), ValueLayout.JAVA_INT.withName("cq_off_overflow"), ValueLayout.JAVA_INT.withName("cq_off_cqes"), ValueLayout.JAVA_INT.withName("cq_off_flags"), ValueLayout.JAVA_INT.withName("cq_off_resv1"), ValueLayout.JAVA_LONG.withName("cq_off_user_addr")).withName("io_uring_params");
    public static final StructLayout IO_URING_SQE_LAYOUT = MemoryLayout.structLayout(ValueLayout.JAVA_BYTE.withName("opcode"), ValueLayout.JAVA_BYTE.withName("flags"), ValueLayout.JAVA_SHORT.withName("ioprio"), ValueLayout.JAVA_INT.withName("fd"), ValueLayout.JAVA_LONG.withName("off"), ValueLayout.JAVA_LONG.withName("addr"), ValueLayout.JAVA_INT.withName("len"), ValueLayout.JAVA_INT.withName("op_flags"), ValueLayout.JAVA_LONG.withName("user_data"), ValueLayout.JAVA_SHORT.withName("buf_index"), ValueLayout.JAVA_SHORT.withName("personality"), ValueLayout.JAVA_INT.withName("splice_fd_in"), ValueLayout.JAVA_LONG.withName("addr3"), ValueLayout.JAVA_LONG.withName("__pad2")).withName("io_uring_sqe");
    public static final StructLayout IO_URING_CQE_LAYOUT = MemoryLayout.structLayout(ValueLayout.JAVA_LONG.withName("user_data"), ValueLayout.JAVA_INT.withName("res"), ValueLayout.JAVA_INT.withName("flags")).withName("io_uring_cqe");
    public static final VarHandle PARAMS_SQ_ENTRIES = IO_URING_PARAMS_LAYOUT.varHandle(MemoryLayout.PathElement.groupElement("sq_entries"));
    public static final VarHandle PARAMS_CQ_ENTRIES = IO_URING_PARAMS_LAYOUT.varHandle(MemoryLayout.PathElement.groupElement("cq_entries"));
    public static final VarHandle PARAMS_FLAGS = IO_URING_PARAMS_LAYOUT.varHandle(MemoryLayout.PathElement.groupElement("flags"));
    public static final VarHandle PARAMS_FEATURES = IO_URING_PARAMS_LAYOUT.varHandle(MemoryLayout.PathElement.groupElement("features"));
    public static final VarHandle PARAMS_SQ_THREAD_CPU = IO_URING_PARAMS_LAYOUT.varHandle(MemoryLayout.PathElement.groupElement("sq_thread_cpu"));
    public static final VarHandle PARAMS_SQ_THREAD_IDLE = IO_URING_PARAMS_LAYOUT.varHandle(MemoryLayout.PathElement.groupElement("sq_thread_idle"));
    public static final VarHandle PARAMS_SQ_OFF_HEAD = IO_URING_PARAMS_LAYOUT.varHandle(MemoryLayout.PathElement.groupElement("sq_off_head"));
    public static final VarHandle PARAMS_SQ_OFF_TAIL = IO_URING_PARAMS_LAYOUT.varHandle(MemoryLayout.PathElement.groupElement("sq_off_tail"));
    public static final VarHandle PARAMS_SQ_OFF_RING_MASK = IO_URING_PARAMS_LAYOUT.varHandle(MemoryLayout.PathElement.groupElement("sq_off_ring_mask"));
    public static final VarHandle PARAMS_SQ_OFF_RING_ENTRIES = IO_URING_PARAMS_LAYOUT.varHandle(MemoryLayout.PathElement.groupElement("sq_off_ring_entries"));
    public static final VarHandle PARAMS_SQ_OFF_FLAGS = IO_URING_PARAMS_LAYOUT.varHandle(MemoryLayout.PathElement.groupElement("sq_off_flags"));
    public static final VarHandle PARAMS_SQ_OFF_ARRAY = IO_URING_PARAMS_LAYOUT.varHandle(MemoryLayout.PathElement.groupElement("sq_off_array"));
    public static final VarHandle PARAMS_CQ_OFF_HEAD = IO_URING_PARAMS_LAYOUT.varHandle(MemoryLayout.PathElement.groupElement("cq_off_head"));
    public static final VarHandle PARAMS_CQ_OFF_TAIL = IO_URING_PARAMS_LAYOUT.varHandle(MemoryLayout.PathElement.groupElement("cq_off_tail"));
    public static final VarHandle PARAMS_CQ_OFF_RING_MASK = IO_URING_PARAMS_LAYOUT.varHandle(MemoryLayout.PathElement.groupElement("cq_off_ring_mask"));
    public static final VarHandle PARAMS_CQ_OFF_RING_ENTRIES = IO_URING_PARAMS_LAYOUT.varHandle(MemoryLayout.PathElement.groupElement("cq_off_ring_entries"));
    public static final VarHandle PARAMS_CQ_OFF_CQES = IO_URING_PARAMS_LAYOUT.varHandle(MemoryLayout.PathElement.groupElement("cq_off_cqes"));
    public static final VarHandle SQE_OPCODE = IO_URING_SQE_LAYOUT.varHandle(MemoryLayout.PathElement.groupElement("opcode"));
    public static final VarHandle SQE_FLAGS = IO_URING_SQE_LAYOUT.varHandle(MemoryLayout.PathElement.groupElement("flags"));
    public static final VarHandle SQE_IOPRIO = IO_URING_SQE_LAYOUT.varHandle(MemoryLayout.PathElement.groupElement("ioprio"));
    public static final VarHandle SQE_FD = IO_URING_SQE_LAYOUT.varHandle(MemoryLayout.PathElement.groupElement("fd"));
    public static final VarHandle SQE_OFF = IO_URING_SQE_LAYOUT.varHandle(MemoryLayout.PathElement.groupElement("off"));
    public static final VarHandle SQE_ADDR = IO_URING_SQE_LAYOUT.varHandle(MemoryLayout.PathElement.groupElement("addr"));
    public static final VarHandle SQE_LEN = IO_URING_SQE_LAYOUT.varHandle(MemoryLayout.PathElement.groupElement("len"));
    public static final VarHandle SQE_OP_FLAGS = IO_URING_SQE_LAYOUT.varHandle(MemoryLayout.PathElement.groupElement("op_flags"));
    public static final VarHandle SQE_USER_DATA = IO_URING_SQE_LAYOUT.varHandle(MemoryLayout.PathElement.groupElement("user_data"));
    public static final VarHandle CQE_USER_DATA = IO_URING_CQE_LAYOUT.varHandle(MemoryLayout.PathElement.groupElement("user_data"));
    public static final VarHandle CQE_RES = IO_URING_CQE_LAYOUT.varHandle(MemoryLayout.PathElement.groupElement("res"));
    public static final VarHandle CQE_FLAGS = IO_URING_CQE_LAYOUT.varHandle(MemoryLayout.PathElement.groupElement("flags"));
    private static final Linker LINKER = Linker.nativeLinker();
    private static final SymbolLookup LIBC = Linker.nativeLinker().defaultLookup();
    private static final SymbolLookup LOADER = SymbolLookup.loaderLookup();
    private static final MethodHandle syscall;
    private static final MethodHandle mmap;
    private static final MethodHandle munmap;
    private static final MethodHandle close_fd;
    private static final MethodHandle io_uring_enter;
    private static final MethodHandle eventfd2;
    private static final MethodHandle write_fd;
    private static final int PROT_READ = 1;
    private static final int PROT_WRITE = 2;
    private static final int MAP_SHARED = 1;
    private static final int MAP_POPULATE = 32768;
    private static final long IORING_OFF_SQ_RING = 0L;
    private static final long IORING_OFF_CQ_RING = 0x8000000L;
    private static final long IORING_OFF_SQES = 0x10000000L;
    private final Arena arena = Arena.ofShared();
    private final int ringFd;
    private final int entries;
    private final int sqEntries;
    private final int cqEntries;
    private final int features;
    private final MemorySegment sqRing;
    private final MemorySegment cqRing;
    private final MemorySegment sqes;
    private final long sqRingSize;
    private final long cqRingSize;
    private final long sqesSize;
    private final MemorySegment sqHead;
    private final MemorySegment sqTail;
    private final MemorySegment sqMask;
    private final MemorySegment sqFlags;
    private final MemorySegment sqArray;
    private final MemorySegment cqHead;
    private final MemorySegment cqTail;
    private final MemorySegment cqMask;
    private final MemorySegment cqes;
    private final int sqMaskValue;
    private final int cqMaskValue;
    private final boolean sqPollMode;
    public static final int IORING_SQ_NEED_WAKEUP = 1;
    public static final int IORING_SQ_CQ_OVERFLOW = 2;
    private volatile boolean closed = false;

    public IoUring(int entries, int flags) throws Exception {
        this(entries, flags, 0, 0);
    }

    public IoUring(int entries, int flags, int sqThreadCpu, int sqThreadIdle) throws Exception {
        long result;
        this.entries = entries;
        MemorySegment params = this.arena.allocate(IO_URING_PARAMS_LAYOUT);
        params.fill((byte)0);
        PARAMS_FLAGS.set(params, 0L, flags);
        if ((flags & 2) != 0) {
            PARAMS_SQ_THREAD_IDLE.set(params, 0L, sqThreadIdle > 0 ? sqThreadIdle : 1000);
        }
        if ((flags & 4) != 0) {
            PARAMS_SQ_THREAD_CPU.set(params, 0L, sqThreadCpu);
        }
        try {
            result = syscall.invokeExact(425L, entries, params);
        }
        catch (Throwable t) {
            this.arena.close();
            throw new Exception("io_uring_setup failed", t);
        }
        if (result < 0L) {
            this.arena.close();
            throw new Exception("io_uring_setup failed with error: " + -result);
        }
        this.ringFd = (int)result;
        this.sqEntries = PARAMS_SQ_ENTRIES.get(params, 0L);
        this.cqEntries = PARAMS_CQ_ENTRIES.get(params, 0L);
        this.features = PARAMS_FEATURES.get(params, 0L);
        int sqOff_array = PARAMS_SQ_OFF_ARRAY.get(params, 0L);
        this.sqRingSize = (long)sqOff_array + (long)this.sqEntries * 4L;
        int cqOff_cqes = PARAMS_CQ_OFF_CQES.get(params, 0L);
        this.cqRingSize = (long)cqOff_cqes + (long)this.cqEntries * IO_URING_CQE_LAYOUT.byteSize();
        this.sqesSize = (long)this.sqEntries * IO_URING_SQE_LAYOUT.byteSize();
        try {
            this.sqRing = this.mmapRing(this.sqRingSize, 0L);
            this.cqRing = this.mmapRing(this.cqRingSize, 0x8000000L);
            this.sqes = this.mmapRing(this.sqesSize, 0x10000000L);
        }
        catch (Exception e) {
            this.closeRingFd();
            this.arena.close();
            throw e;
        }
        int sqOff_head = PARAMS_SQ_OFF_HEAD.get(params, 0L);
        int sqOff_tail = PARAMS_SQ_OFF_TAIL.get(params, 0L);
        int sqOff_ring_mask = PARAMS_SQ_OFF_RING_MASK.get(params, 0L);
        this.sqHead = this.sqRing.asSlice((long)sqOff_head, ValueLayout.JAVA_INT.byteSize());
        this.sqTail = this.sqRing.asSlice((long)sqOff_tail, ValueLayout.JAVA_INT.byteSize());
        this.sqMask = this.sqRing.asSlice((long)sqOff_ring_mask, ValueLayout.JAVA_INT.byteSize());
        this.sqArray = this.sqRing.asSlice((long)sqOff_array, (long)this.sqEntries * 4L);
        int sqOff_flags = PARAMS_SQ_OFF_FLAGS.get(params, 0L);
        this.sqFlags = this.sqRing.asSlice((long)sqOff_flags, ValueLayout.JAVA_INT.byteSize());
        this.sqPollMode = (flags & 2) != 0;
        int cqOff_head = PARAMS_CQ_OFF_HEAD.get(params, 0L);
        int cqOff_tail = PARAMS_CQ_OFF_TAIL.get(params, 0L);
        int cqOff_ring_mask = PARAMS_CQ_OFF_RING_MASK.get(params, 0L);
        this.cqHead = this.cqRing.asSlice((long)cqOff_head, ValueLayout.JAVA_INT.byteSize());
        this.cqTail = this.cqRing.asSlice((long)cqOff_tail, ValueLayout.JAVA_INT.byteSize());
        this.cqMask = this.cqRing.asSlice((long)cqOff_ring_mask, ValueLayout.JAVA_INT.byteSize());
        this.cqes = this.cqRing.asSlice((long)cqOff_cqes, (long)this.cqEntries * IO_URING_CQE_LAYOUT.byteSize());
        this.sqMaskValue = this.sqMask.get(ValueLayout.JAVA_INT, 0L);
        this.cqMaskValue = this.cqMask.get(ValueLayout.JAVA_INT, 0L);
    }

    private MemorySegment mmapRing(long size, long offset) throws Exception {
        MemorySegment result;
        try {
            result = mmap.invokeExact(MemorySegment.NULL, size, 3, 32769, this.ringFd, offset);
        }
        catch (Throwable t) {
            throw new Exception("mmap failed", t);
        }
        if (result.address() == -1L) {
            throw new Exception("mmap failed");
        }
        return result.reinterpret(size);
    }

    public MemorySegment getSqe() {
        int head;
        int tail = this.sqTail.get(ValueLayout.JAVA_INT, 0L);
        if (tail - (head = this.sqHead.get(ValueLayout.JAVA_INT, 0L)) >= this.sqEntries) {
            return null;
        }
        int index = tail & this.sqMaskValue;
        MemorySegment sqe = this.sqes.asSlice((long)index * IO_URING_SQE_LAYOUT.byteSize(), IO_URING_SQE_LAYOUT.byteSize());
        sqe.fill((byte)0);
        this.sqArray.set(ValueLayout.JAVA_INT, (long)index * 4L, index);
        return sqe;
    }

    public void submit() {
        VarHandle.storeStoreFence();
        int tail = this.sqTail.get(ValueLayout.JAVA_INT, 0L);
        this.sqTail.set(ValueLayout.JAVA_INT, 0L, tail + 1);
    }

    public int enter(int toSubmit, int minComplete, int flags) throws Exception {
        try {
            long result = io_uring_enter.invokeExact(426L, this.ringFd, toSubmit, minComplete, flags, MemorySegment.NULL);
            if (result < 0L) {
                throw new Exception("io_uring_enter failed with error: " + -result);
            }
            return (int)result;
        }
        catch (Throwable t) {
            throw new Exception("io_uring_enter failed", t);
        }
    }

    public MemorySegment peekCqe() {
        int head = this.cqHead.get(ValueLayout.JAVA_INT, 0L);
        int tail = this.cqTail.get(ValueLayout.JAVA_INT, 0L);
        VarHandle.loadLoadFence();
        if (head == tail) {
            return null;
        }
        int index = head & this.cqMaskValue;
        return this.cqes.asSlice((long)index * IO_URING_CQE_LAYOUT.byteSize(), IO_URING_CQE_LAYOUT.byteSize());
    }

    public void advanceCq() {
        int head = this.cqHead.get(ValueLayout.JAVA_INT, 0L);
        this.cqHead.set(ValueLayout.JAVA_INT, 0L, head + 1);
    }

    public boolean needsWakeup() {
        if (!this.sqPollMode) {
            return false;
        }
        int flags = this.sqFlags.get(ValueLayout.JAVA_INT, 0L);
        return (flags & 1) != 0;
    }

    public boolean isSqPollMode() {
        return this.sqPollMode;
    }

    public void prepareNop(MemorySegment sqe, long userData) {
        SQE_OPCODE.set(sqe, 0L, (byte)0);
        SQE_USER_DATA.set(sqe, 0L, userData);
    }

    public void prepareRead(MemorySegment sqe, int fd, MemorySegment buffer, int len, long offset, long userData) {
        SQE_OPCODE.set(sqe, 0L, (byte)22);
        SQE_FD.set(sqe, 0L, fd);
        SQE_ADDR.set(sqe, 0L, buffer.address());
        SQE_LEN.set(sqe, 0L, len);
        SQE_OFF.set(sqe, 0L, offset);
        SQE_USER_DATA.set(sqe, 0L, userData);
    }

    public void prepareWrite(MemorySegment sqe, int fd, MemorySegment buffer, int len, long offset, long userData) {
        SQE_OPCODE.set(sqe, 0L, (byte)23);
        SQE_FD.set(sqe, 0L, fd);
        SQE_ADDR.set(sqe, 0L, buffer.address());
        SQE_LEN.set(sqe, 0L, len);
        SQE_OFF.set(sqe, 0L, offset);
        SQE_USER_DATA.set(sqe, 0L, userData);
    }

    public void prepareAccept(MemorySegment sqe, int fd, MemorySegment addr, MemorySegment addrLen, int flags, long userData) {
        SQE_OPCODE.set(sqe, 0L, (byte)13);
        SQE_FD.set(sqe, 0L, fd);
        SQE_ADDR.set(sqe, 0L, addr != null ? addr.address() : 0L);
        SQE_OFF.set(sqe, 0L, addrLen != null ? addrLen.address() : 0L);
        SQE_OP_FLAGS.set(sqe, 0L, flags);
        SQE_USER_DATA.set(sqe, 0L, userData);
    }

    public void prepareClose(MemorySegment sqe, int fd, long userData) {
        SQE_OPCODE.set(sqe, 0L, (byte)19);
        SQE_FD.set(sqe, 0L, fd);
        SQE_USER_DATA.set(sqe, 0L, userData);
    }

    public void prepareRecv(MemorySegment sqe, int fd, MemorySegment buffer, int len, int flags, long userData) {
        SQE_OPCODE.set(sqe, 0L, (byte)27);
        SQE_FD.set(sqe, 0L, fd);
        SQE_ADDR.set(sqe, 0L, buffer.address());
        SQE_LEN.set(sqe, 0L, len);
        SQE_OP_FLAGS.set(sqe, 0L, flags);
        SQE_USER_DATA.set(sqe, 0L, userData);
    }

    public void prepareSend(MemorySegment sqe, int fd, MemorySegment buffer, int len, int flags, long userData) {
        SQE_OPCODE.set(sqe, 0L, (byte)26);
        SQE_FD.set(sqe, 0L, fd);
        SQE_ADDR.set(sqe, 0L, buffer.address());
        SQE_LEN.set(sqe, 0L, len);
        SQE_OP_FLAGS.set(sqe, 0L, flags);
        SQE_USER_DATA.set(sqe, 0L, userData);
    }

    public void prepareConnect(MemorySegment sqe, int fd, MemorySegment addr, int addrLen, long userData) {
        SQE_OPCODE.set(sqe, 0L, (byte)16);
        SQE_FD.set(sqe, 0L, fd);
        SQE_ADDR.set(sqe, 0L, addr.address());
        SQE_OFF.set(sqe, 0L, addrLen);
        SQE_USER_DATA.set(sqe, 0L, userData);
    }

    public void prepareTimeout(MemorySegment sqe, MemorySegment ts, int count, int flags, long userData) {
        SQE_OPCODE.set(sqe, 0L, (byte)11);
        SQE_FD.set(sqe, 0L, -1);
        SQE_ADDR.set(sqe, 0L, ts.address());
        SQE_LEN.set(sqe, 0L, count);
        SQE_OP_FLAGS.set(sqe, 0L, flags);
        SQE_USER_DATA.set(sqe, 0L, userData);
    }

    public void setSqeLink(MemorySegment sqe) {
        byte flags = SQE_FLAGS.get(sqe, 0L);
        SQE_FLAGS.set(sqe, 0L, (byte)(flags | 4));
    }

    public static long getUserData(MemorySegment cqe) {
        return CQE_USER_DATA.get(cqe, 0L);
    }

    public static int getResult(MemorySegment cqe) {
        return CQE_RES.get(cqe, 0L);
    }

    public static int getCqeFlags(MemorySegment cqe) {
        return CQE_FLAGS.get(cqe, 0L);
    }

    public static int createEventFd(int initval, int flags) throws Exception {
        try {
            long result = eventfd2.invokeExact(290L, initval, flags);
            if (result < 0L) {
                throw new Exception("eventfd2 failed with error: " + -result);
            }
            return (int)result;
        }
        catch (Throwable t) {
            throw new Exception("eventfd2 failed", t);
        }
    }

    public static void writeEventFd(int efd, MemorySegment valueBuffer) throws Exception {
        try {
            long result = write_fd.invokeExact(efd, valueBuffer, 8L);
            if (result < 0L) {
                throw new Exception("write to eventfd failed");
            }
        }
        catch (Throwable t) {
            throw new Exception("write to eventfd failed", t);
        }
    }

    public static void closeEventFd(int efd) {
        try {
            close_fd.invokeExact(efd);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public int getRingFd() {
        return this.ringFd;
    }

    public int getSqEntries() {
        return this.sqEntries;
    }

    public int getCqEntries() {
        return this.cqEntries;
    }

    public int getFeatures() {
        return this.features;
    }

    public Arena getArena() {
        return this.arena;
    }

    private void closeRingFd() {
        try {
            close_fd.invokeExact(this.ringFd);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            if (this.sqRing != null && this.sqRing.address() != 0L) {
                munmap.invokeExact(this.sqRing, this.sqRingSize);
            }
            if (this.cqRing != null && this.cqRing.address() != 0L && this.cqRing.address() != this.sqRing.address()) {
                munmap.invokeExact(this.cqRing, this.cqRingSize);
            }
            if (this.sqes != null && this.sqes.address() != 0L) {
                munmap.invokeExact(this.sqes, this.sqesSize);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.closeRingFd();
        this.arena.close();
    }

    static {
        try {
            syscall = LINKER.downcallHandle(LIBC.find("syscall").orElseThrow(), FunctionDescriptor.of(ValueLayout.JAVA_LONG, ValueLayout.JAVA_LONG, ValueLayout.JAVA_INT, ValueLayout.ADDRESS), Linker.Option.firstVariadicArg(1));
            mmap = LINKER.downcallHandle(LIBC.find("mmap").orElseThrow(), FunctionDescriptor.of(ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.JAVA_LONG, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.JAVA_LONG), new Linker.Option[0]);
            munmap = LINKER.downcallHandle(LIBC.find("munmap").orElseThrow(), FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.JAVA_LONG), new Linker.Option[0]);
            close_fd = LINKER.downcallHandle(LIBC.find("close").orElseThrow(), FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.JAVA_INT), new Linker.Option[0]);
            io_uring_enter = LINKER.downcallHandle(LIBC.find("syscall").orElseThrow(), FunctionDescriptor.of(ValueLayout.JAVA_LONG, ValueLayout.JAVA_LONG, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.ADDRESS), Linker.Option.firstVariadicArg(1));
            eventfd2 = LINKER.downcallHandle(LIBC.find("syscall").orElseThrow(), FunctionDescriptor.of(ValueLayout.JAVA_LONG, ValueLayout.JAVA_LONG, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT), Linker.Option.firstVariadicArg(1));
            write_fd = LINKER.downcallHandle(LIBC.find("write").orElseThrow(), FunctionDescriptor.of(ValueLayout.JAVA_LONG, ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.JAVA_LONG), new Linker.Option[0]);
        }
        catch (Throwable t) {
            throw new ExceptionInInitializerError(t);
        }
    }
}

