/*
 * Decompiled with CFR 0.152.
 */
package zeph.ssl;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class SslConfig {
    private final SSLContext sslContext;
    private static final String LOCALHOST_CERT = "-----BEGIN CERTIFICATE-----\nMIIDCTCCAfGgAwIBAgIUNi7q8U1DzoEMfb4ZhvmBvEr0jeIwDQYJKoZIhvcNAQEL\nBQAwFDESMBAGA1UEAwwJbG9jYWxob3N0MB4XDTI1MTIxMzExMjIzNFoXDTM1MTIx\nMTExMjIzNFowFDESMBAGA1UEAwwJbG9jYWxob3N0MIIBIjANBgkqhkiG9w0BAQEF\nAAOCAQ8AMIIBCgKCAQEAsGyXprORoXi0rs9SxVtZdHMG17HLT1qgFB02E+xV8+zl\nk2HJ7j2zJ0rjUNOyNciox8uEIJ4Xa7j4uMAqsWRNRb+QMM+N5rvU4RO6kHx43Zik\nRAyJVI1dlCQbIMWeadJCQajQ9qUEU6BFfjkM3/iMMnWFcBcFr4XEKX35Gw1dmJt1\nRWqV4RS81AFKh1ee5xbyTXsbzx9AEy9odnLBR64vqgr+dh+hMBs2dgDCxx+zEBpa\nE/R+XbP3x/MGwdvawj/feMvPEggzYORypuBnonWNbE/ByEphibIw7yKi5LYQ0E5I\nyHO+ZUa5Zu1wQHd/2T61vMrzO3wVAeEB7bxoG4bCqwIDAQABo1MwUTAdBgNVHQ4E\nFgQUHDrluJeDtKJyqf8XA7ubMWbcK8AwHwYDVR0jBBgwFoAUHDrluJeDtKJyqf8X\nA7ubMWbcK8AwDwYDVR0TAQH/BAUwAwEB/zANBgkqhkiG9w0BAQsFAAOCAQEAkrxw\ncW7wd7jHGmMR5vkrn3cQiYnR8qeecGweKHZdDXnuEgrDhNIt3XfGfp2BppoTv7N8\n/pIeJulln7rOh5EZxTw0v1UAvHesd/Mmve7myafkcjS8JEhrgDN+GDt1pTUb5gVa\n/qlXGyw/Nz/CcuVHC3G1GJUHJTbH6XpDbPf3af48MfReqIuOveOyelsPDA2WZ9pf\niUVWfkB/0ilk8uHp09oRiR5tn7rslIS1bN4hKlJItb1tJrWRZG0GI2Vxv2ABsiKu\nw6xrs/wRKR0Bjvu5Dj108HPEL+RwmdCdkGfFv92KW5oP5Q3pva6M1mHE5/4EpFA5\nDlywIsCeoOHWAKFuhA==\n-----END CERTIFICATE-----\n";
    private static final String LOCALHOST_KEY = "-----BEGIN PRIVATE KEY-----\nMIIEvAIBADANBgkqhkiG9w0BAQEFAASCBKYwggSiAgEAAoIBAQCwbJems5GheLSu\nz1LFW1l0cwbXsctPWqAUHTYT7FXz7OWTYcnuPbMnSuNQ07I1yKjHy4QgnhdruPi4\nwCqxZE1Fv5Awz43mu9ThE7qQfHjdmKREDIlUjV2UJBsgxZ5p0kJBqND2pQRToEV+\nOQzf+IwydYVwFwWvhcQpffkbDV2Ym3VFapXhFLzUAUqHV57nFvJNexvPH0ATL2h2\ncsFHri+qCv52H6EwGzZ2AMLHH7MQGloT9H5ds/fH8wbB29rCP994y88SCDNg5HKm\n4GeidY1sT8HISmGJsjDvIqLkthDQTkjIc75lRrlm7XBAd3/ZPrW8yvM7fBUB4QHt\nvGgbhsKrAgMBAAECggEAELW9KJZlREB51WOgonDt1TULeffs9EkQOwEU43UxvO1J\nEn9wHO167Jocud9n+s0hibu+eeJpAHrgEyU5LF0XyCcfoc5LnlK+R0uf+SbSjqNY\nmtnL7Hy8cMp5eufZnCQRXEVNKX2x6uovh6GHe40y8v9YXw7NkVusaGupYcUPaOOk\nR/rqTRCsqh8h13l7oNLzTmBXE53vk469bFwl8QtsrhoJaBO2sy7jPDfkgmc1CbW/\n0QnZLO2dIEslzzj2wD5YYEJDN8w//MyM8Dgfv/Pc6wmrRBNlJa90J+Jt0S54O+EN\nadSUfCVkCAj3f21IUawQ4KyCJJCo+Ilj8e/o/KABRQKBgQDX+owvIwSADcaMajcl\nZLWz9kwHptkeCqXcfkOEhaI8tsPj8CRtWN2yyZh2lbr4s4+RVzAO05XGjxPnhaug\n8r/WWtJG60AvdYSEI4g9jq6CnKyHIOmCHyV0Rx0dV9TCZe3es85rgxH+cDOjkQ5K\nHmmwKsP1aJDxUns6UwdRqcDfRwKBgQDRHa82mgs7ye/ufGgciabTS+TlHmVi37lI\n7lVCD93+B+f7txdTgq2+q2iAsJQI4pYtmlT3hdiCCPuTF7tUzY/a6vtY8ZSsjhN3\nyZr8TMPNRSTo2VPyVJrfd4jE96Oal1fUAbdSL4CWVO813US85szy3Zp5uTduWXBg\nHo4Vl+jbfQKBgDPHfZRPcOTCaLeBP3dXjbh3dALhnWv2YY1bOBStdRfZOV2MVS9h\n/sS+UC8d9pVpdyIBJSRo1Z+k7cCz61HK4PMjEwatn9XA9uQ3IJKhgnUN2s8KtPDd\nRr15zyEZzYhNp5mcwgBEjCvT+o1cWXCrmesCVbigOR+iBqkU/sw1RmhBAoGAP1zx\nRGg00y8DJo5Hta34ALpUZyBotCb6K6Eb8GKCb4DRyDHYPZOxNb8WcTgQAwk1XCgR\natcBnZU/NXjRaIbI+hqNgovg8tAyEe/iqGRSSBaVcoC3sQv1yZScuqIWzrbhA/pp\nI9wE6Ihf20BqnZqJq2V+czeuFh+/r0BS6TQYeLkCgYB3GftKiUewDJNbABhJYpoO\noX9OvPwnBAyd+9/xGuf2ohdo3SDbSiE0DxWKhoA99p5Vsfxd8y57GeGQzyZPmyk9\nBTxxBoCA7op9cvFdxkvk1BTebqTcYYisYeKyPvvwJPKA9Jfa3qcRsGhedyymREWf\nZKYf7L2bRhHFqr/iSyjAlQ==\n-----END PRIVATE KEY-----\n";

    private SslConfig(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public SSLEngine createEngine() {
        SSLEngine engine = this.sslContext.createSSLEngine();
        engine.setUseClientMode(false);
        engine.setNeedClientAuth(false);
        return engine;
    }

    public SSLEngine createEngineWithAlpn() {
        SSLEngine engine = this.createEngine();
        SSLParameters params = engine.getSSLParameters();
        params.setApplicationProtocols(new String[]{"h2", "http/1.1"});
        engine.setSSLParameters(params);
        return engine;
    }

    public SSLEngine createEngineWithAlpn(String ... protocols) {
        SSLEngine engine = this.createEngine();
        SSLParameters params = engine.getSSLParameters();
        params.setApplicationProtocols(protocols);
        engine.setSSLParameters(params);
        return engine;
    }

    public static String getAlpnProtocol(SSLEngine engine) {
        return engine.getApplicationProtocol();
    }

    public static boolean isHttp2(SSLEngine engine) {
        String protocol = SslConfig.getAlpnProtocol(engine);
        return "h2".equals(protocol);
    }

    public static boolean isHttp11(SSLEngine engine) {
        String protocol = SslConfig.getAlpnProtocol(engine);
        return protocol == null || "http/1.1".equals(protocol) || protocol.isEmpty();
    }

    public static SslConfig fromPkcs12(String keystorePath, String password) throws Exception {
        return SslConfig.fromKeyStore(keystorePath, password, "PKCS12");
    }

    public static SslConfig fromJks(String keystorePath, String password) throws Exception {
        return SslConfig.fromKeyStore(keystorePath, password, "JKS");
    }

    public static SslConfig fromKeyStore(String keystorePath, String password, String type) throws Exception {
        KeyStore keyStore = KeyStore.getInstance(type);
        try (FileInputStream is = new FileInputStream(keystorePath);){
            keyStore.load(is, password.toCharArray());
        }
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmf.init(keyStore, password.toCharArray());
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(keyStore);
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
        return new SslConfig(sslContext);
    }

    public static SslConfig fromPem(String certPath, String keyPath, String password) throws Exception {
        List<Certificate> certs = SslConfig.readCertificates(certPath);
        if (certs.isEmpty()) {
            throw new IllegalArgumentException("No certificates found in: " + certPath);
        }
        PrivateKey privateKey = SslConfig.readPrivateKey(keyPath);
        KeyStore keyStore = KeyStore.getInstance("PKCS12");
        keyStore.load(null, null);
        Certificate[] certChain = certs.toArray(new Certificate[0]);
        keyStore.setKeyEntry("zeph", privateKey, password.toCharArray(), certChain);
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmf.init(keyStore, password.toCharArray());
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(keyStore);
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
        return new SslConfig(sslContext);
    }

    private static List<Certificate> readCertificates(String path) throws Exception {
        String[] blocks;
        ArrayList<Certificate> certs = new ArrayList<Certificate>();
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        String content = Files.readString(Path.of(path, new String[0]));
        for (String block : blocks = content.split("-----END CERTIFICATE-----")) {
            int beginIndex = block.indexOf("-----BEGIN CERTIFICATE-----");
            if (beginIndex < 0) continue;
            String certPem = block.substring(beginIndex) + "-----END CERTIFICATE-----";
            try (ByteArrayInputStream is = new ByteArrayInputStream(certPem.getBytes());){
                Certificate cert = cf.generateCertificate(is);
                certs.add(cert);
            }
        }
        return certs;
    }

    private static PrivateKey readPrivateKey(String path) throws Exception {
        String content = Files.readString(Path.of(path, new String[0]));
        String algorithm = "RSA";
        if (!content.contains("-----BEGIN PRIVATE KEY-----")) {
            if (content.contains("-----BEGIN RSA PRIVATE KEY-----")) {
                String keyPem = SslConfig.extractPemBlock(content, "RSA PRIVATE KEY");
                algorithm = "RSA";
                return SslConfig.readPkcs1PrivateKey(keyPem, algorithm);
            }
            if (content.contains("-----BEGIN EC PRIVATE KEY-----")) {
                String keyPem = SslConfig.extractPemBlock(content, "EC PRIVATE KEY");
                algorithm = "EC";
                return SslConfig.readPkcs1PrivateKey(keyPem, algorithm);
            }
            throw new IllegalArgumentException("Unsupported key format. Expected PKCS#8 (BEGIN PRIVATE KEY) or PKCS#1 (BEGIN RSA PRIVATE KEY / BEGIN EC PRIVATE KEY)");
        }
        String keyPem = SslConfig.extractPemBlock(content, "PRIVATE KEY");
        byte[] keyBytes = Base64.getDecoder().decode(keyPem);
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory kf = KeyFactory.getInstance(algorithm);
        return kf.generatePrivate(keySpec);
    }

    private static String extractPemBlock(String content, String type) {
        String beginMarker = "-----BEGIN " + type + "-----";
        String endMarker = "-----END " + type + "-----";
        int beginIndex = content.indexOf(beginMarker);
        int endIndex = content.indexOf(endMarker);
        if (beginIndex < 0 || endIndex < 0) {
            throw new IllegalArgumentException("Could not find " + type + " in PEM file");
        }
        String base64 = content.substring(beginIndex + beginMarker.length(), endIndex);
        return base64.replaceAll("\\s", "");
    }

    private static PrivateKey readPkcs1PrivateKey(String base64Key, String algorithm) throws Exception {
        byte[] keyBytes = Base64.getDecoder().decode(base64Key);
        if ("RSA".equals(algorithm)) {
            byte[] pkcs8Header = new byte[]{48, -126, 0, 0, 2, 1, 0, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 4, -126, 0, 0};
            int totalLength = pkcs8Header.length + keyBytes.length;
            byte[] pkcs8Key = new byte[totalLength];
            System.arraycopy(pkcs8Header, 0, pkcs8Key, 0, pkcs8Header.length);
            System.arraycopy(keyBytes, 0, pkcs8Key, pkcs8Header.length, keyBytes.length);
            int seqLength = totalLength - 4;
            pkcs8Key[2] = (byte)(seqLength >> 8 & 0xFF);
            pkcs8Key[3] = (byte)(seqLength & 0xFF);
            int octetLength = keyBytes.length;
            pkcs8Key[pkcs8Header.length - 2] = (byte)(octetLength >> 8 & 0xFF);
            pkcs8Key[pkcs8Header.length - 1] = (byte)(octetLength & 0xFF);
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(pkcs8Key);
            KeyFactory kf = KeyFactory.getInstance("RSA");
            return kf.generatePrivate(keySpec);
        }
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory kf = KeyFactory.getInstance(algorithm);
        return kf.generatePrivate(keySpec);
    }

    public static SslConfig fromContext(SSLContext sslContext) {
        return new SslConfig(sslContext);
    }

    public static SslConfig localhost() throws Exception {
        return SslConfig.fromPemStrings(LOCALHOST_CERT, LOCALHOST_KEY, "localhost");
    }

    public static SslConfig fromPemStrings(String certPem, String keyPem, String password) throws Exception {
        String[] blocks;
        ArrayList<Certificate> certs = new ArrayList<Certificate>();
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        for (String block : blocks = certPem.split("-----END CERTIFICATE-----")) {
            int beginIndex = block.indexOf("-----BEGIN CERTIFICATE-----");
            if (beginIndex < 0) continue;
            String certBlock = block.substring(beginIndex) + "-----END CERTIFICATE-----";
            try (ByteArrayInputStream is = new ByteArrayInputStream(certBlock.getBytes());){
                Certificate cert = cf.generateCertificate(is);
                certs.add(cert);
            }
        }
        if (certs.isEmpty()) {
            throw new IllegalArgumentException("No certificates found in PEM string");
        }
        PrivateKey privateKey = SslConfig.readPrivateKeyFromString(keyPem);
        KeyStore keyStore = KeyStore.getInstance("PKCS12");
        keyStore.load(null, null);
        Certificate[] certChain = certs.toArray(new Certificate[0]);
        keyStore.setKeyEntry("zeph", privateKey, password.toCharArray(), certChain);
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmf.init(keyStore, password.toCharArray());
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(keyStore);
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
        return new SslConfig(sslContext);
    }

    private static PrivateKey readPrivateKeyFromString(String keyPem) throws Exception {
        String algorithm = "RSA";
        if (!keyPem.contains("-----BEGIN PRIVATE KEY-----")) {
            if (keyPem.contains("-----BEGIN RSA PRIVATE KEY-----")) {
                String keyBase64 = SslConfig.extractPemBlockFromString(keyPem, "RSA PRIVATE KEY");
                return SslConfig.readPkcs1PrivateKeyFromBytes(Base64.getDecoder().decode(keyBase64), "RSA");
            }
            throw new IllegalArgumentException("Unsupported key format");
        }
        String keyBase64 = SslConfig.extractPemBlockFromString(keyPem, "PRIVATE KEY");
        byte[] keyBytes = Base64.getDecoder().decode(keyBase64);
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory kf = KeyFactory.getInstance(algorithm);
        return kf.generatePrivate(keySpec);
    }

    private static String extractPemBlockFromString(String content, String type) {
        String beginMarker = "-----BEGIN " + type + "-----";
        String endMarker = "-----END " + type + "-----";
        int beginIndex = content.indexOf(beginMarker);
        int endIndex = content.indexOf(endMarker);
        if (beginIndex < 0 || endIndex < 0) {
            throw new IllegalArgumentException("Could not find " + type + " in PEM string");
        }
        String base64 = content.substring(beginIndex + beginMarker.length(), endIndex);
        return base64.replaceAll("\\s", "");
    }

    private static PrivateKey readPkcs1PrivateKeyFromBytes(byte[] keyBytes, String algorithm) throws Exception {
        if ("RSA".equals(algorithm)) {
            byte[] pkcs8Header = new byte[]{48, -126, 0, 0, 2, 1, 0, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 4, -126, 0, 0};
            int totalLength = pkcs8Header.length + keyBytes.length;
            byte[] pkcs8Key = new byte[totalLength];
            System.arraycopy(pkcs8Header, 0, pkcs8Key, 0, pkcs8Header.length);
            System.arraycopy(keyBytes, 0, pkcs8Key, pkcs8Header.length, keyBytes.length);
            int seqLength = totalLength - 4;
            pkcs8Key[2] = (byte)(seqLength >> 8 & 0xFF);
            pkcs8Key[3] = (byte)(seqLength & 0xFF);
            int octetLength = keyBytes.length;
            pkcs8Key[pkcs8Header.length - 2] = (byte)(octetLength >> 8 & 0xFF);
            pkcs8Key[pkcs8Header.length - 1] = (byte)(octetLength & 0xFF);
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(pkcs8Key);
            KeyFactory kf = KeyFactory.getInstance("RSA");
            return kf.generatePrivate(keySpec);
        }
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory kf = KeyFactory.getInstance(algorithm);
        return kf.generatePrivate(keySpec);
    }

    public static SslConfig forClient() throws Exception {
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(null, null, null);
        return new SslConfig(sslContext);
    }

    public SSLEngine createClientEngineWithAlpn(String host, int port) {
        SSLEngine engine = this.sslContext.createSSLEngine(host, port);
        engine.setUseClientMode(true);
        SSLParameters params = engine.getSSLParameters();
        params.setApplicationProtocols(new String[]{"h2", "http/1.1"});
        engine.setSSLParameters(params);
        return engine;
    }

    public SSLEngine createClientEngineWithAlpn(String host, int port, String ... protocols) {
        SSLEngine engine = this.sslContext.createSSLEngine(host, port);
        engine.setUseClientMode(true);
        SSLParameters params = engine.getSSLParameters();
        params.setApplicationProtocols(protocols);
        engine.setSSLParameters(params);
        return engine;
    }

    public SSLEngine createClientEngine(String host, int port) {
        SSLEngine engine = this.sslContext.createSSLEngine(host, port);
        engine.setUseClientMode(true);
        return engine;
    }

    public static SslConfig forClientInsecure() throws Exception {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(null, trustAllCerts, new SecureRandom());
        return new SslConfig(sslContext);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String keystorePath;
        private String keystorePassword;
        private String keystoreType = "PKCS12";
        private String truststorePath;
        private String truststorePassword;
        private boolean needClientAuth = false;
        private String[] protocols;
        private String[] cipherSuites;

        public Builder keystore(String path, String password) {
            this.keystorePath = path;
            this.keystorePassword = password;
            return this;
        }

        public Builder keystoreType(String type) {
            this.keystoreType = type;
            return this;
        }

        public Builder truststore(String path, String password) {
            this.truststorePath = path;
            this.truststorePassword = password;
            return this;
        }

        public Builder needClientAuth(boolean need) {
            this.needClientAuth = need;
            return this;
        }

        public Builder protocols(String ... protocols) {
            this.protocols = protocols;
            return this;
        }

        public Builder cipherSuites(String ... cipherSuites) {
            this.cipherSuites = cipherSuites;
            return this;
        }

        public SslConfig build() throws Exception {
            if (this.keystorePath == null) {
                throw new IllegalStateException("Keystore path is required");
            }
            KeyStore keyStore = KeyStore.getInstance(this.keystoreType);
            try (FileInputStream is = new FileInputStream(this.keystorePath);){
                keyStore.load(is, this.keystorePassword.toCharArray());
            }
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(keyStore, this.keystorePassword.toCharArray());
            TrustManager[] trustManagers = null;
            if (this.truststorePath != null) {
                KeyStore trustStore = KeyStore.getInstance(this.keystoreType);
                try (FileInputStream is = new FileInputStream(this.truststorePath);){
                    trustStore.load(is, this.truststorePassword.toCharArray());
                }
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                tmf.init(trustStore);
                trustManagers = tmf.getTrustManagers();
            }
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(kmf.getKeyManagers(), trustManagers, null);
            return new SslConfig(this, sslContext){
                final /* synthetic */ Builder this$0;
                {
                    Builder builder = this$0;
                    Objects.requireNonNull(builder);
                    this.this$0 = builder;
                    super(sslContext);
                }

                @Override
                public SSLEngine createEngine() {
                    SSLEngine engine = super.createEngine();
                    engine.setNeedClientAuth(this.this$0.needClientAuth);
                    if (this.this$0.protocols != null) {
                        engine.setEnabledProtocols(this.this$0.protocols);
                    }
                    if (this.this$0.cipherSuites != null) {
                        engine.setEnabledCipherSuites(this.this$0.cipherSuites);
                    }
                    return engine;
                }
            };
        }
    }
}

