/*
 * Decompiled with CFR 0.152.
 */
package zeph.ring;

import clojure.lang.IMapEntry;
import clojure.lang.IPersistentMap;
import clojure.lang.ISeq;
import clojure.lang.Keyword;
import clojure.lang.PersistentArrayMap;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import zeph.http.HttpMethod;
import zeph.http.HttpRequest;
import zeph.http.HttpResponse;

public class RingAdapter {
    private static final Keyword K_SERVER_PORT = Keyword.intern((String)"server-port");
    private static final Keyword K_SERVER_NAME = Keyword.intern((String)"server-name");
    private static final Keyword K_REMOTE_ADDR = Keyword.intern((String)"remote-addr");
    private static final Keyword K_URI = Keyword.intern((String)"uri");
    private static final Keyword K_QUERY_STRING = Keyword.intern((String)"query-string");
    private static final Keyword K_SCHEME = Keyword.intern((String)"scheme");
    private static final Keyword K_REQUEST_METHOD = Keyword.intern((String)"request-method");
    private static final Keyword K_PROTOCOL = Keyword.intern((String)"protocol");
    private static final Keyword K_HEADERS = Keyword.intern((String)"headers");
    private static final Keyword K_BODY = Keyword.intern((String)"body");
    private static final Keyword M_GET = Keyword.intern((String)"get");
    private static final Keyword M_POST = Keyword.intern((String)"post");
    private static final Keyword M_PUT = Keyword.intern((String)"put");
    private static final Keyword M_DELETE = Keyword.intern((String)"delete");
    private static final Keyword M_HEAD = Keyword.intern((String)"head");
    private static final Keyword M_OPTIONS = Keyword.intern((String)"options");
    private static final Keyword M_PATCH = Keyword.intern((String)"patch");
    private static final Keyword M_TRACE = Keyword.intern((String)"trace");
    private static final Keyword M_CONNECT = Keyword.intern((String)"connect");
    private static final Keyword SCHEME_HTTP = Keyword.intern((String)"http");
    private static final Keyword SCHEME_HTTPS = Keyword.intern((String)"https");
    private static final Keyword K_STATUS = Keyword.intern((String)"status");
    private static final String LOCALHOST = "localhost";
    private static final String DEFAULT_ADDR = "127.0.0.1";
    private static final String HTTP_1_1 = "HTTP/1.1";
    private static final IPersistentMap EMPTY_HEADERS = PersistentArrayMap.EMPTY;

    private static Keyword methodToKeyword(HttpMethod method) {
        if (method == null) {
            return null;
        }
        return switch (method) {
            default -> throw new MatchException(null, null);
            case HttpMethod.GET -> M_GET;
            case HttpMethod.POST -> M_POST;
            case HttpMethod.PUT -> M_PUT;
            case HttpMethod.DELETE -> M_DELETE;
            case HttpMethod.HEAD -> M_HEAD;
            case HttpMethod.OPTIONS -> M_OPTIONS;
            case HttpMethod.PATCH -> M_PATCH;
            case HttpMethod.TRACE -> M_TRACE;
            case HttpMethod.CONNECT -> M_CONNECT;
        };
    }

    private static IPersistentMap convertHeaders(Map<String, String> headers) {
        if (headers == null || headers.isEmpty()) {
            return EMPTY_HEADERS;
        }
        int size = headers.size();
        Object[] kvs = new Object[size * 2];
        int i = 0;
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            kvs[i++] = entry.getKey().toLowerCase();
            kvs[i++] = entry.getValue();
        }
        return PersistentArrayMap.createAsIfByAssoc((Object[])kvs);
    }

    public static IPersistentMap buildRequestMap(HttpRequest req) {
        byte[] bodyBytes;
        Map<String, String> javaHeaders = req.getHeaders();
        IPersistentMap headers = RingAdapter.convertHeaders(javaHeaders);
        String serverName = req.getServerName();
        if (serverName == null) {
            Object host = headers.valAt((Object)"host");
            serverName = host != null ? host.toString() : LOCALHOST;
        }
        ByteArrayInputStream body = (bodyBytes = req.getBody()) != null ? new ByteArrayInputStream(bodyBytes) : null;
        return PersistentArrayMap.createAsIfByAssoc((Object[])new Object[]{K_SERVER_PORT, req.getServerPort(), K_SERVER_NAME, serverName, K_REMOTE_ADDR, req.getRemoteAddr() != null ? req.getRemoteAddr() : DEFAULT_ADDR, K_URI, req.getPath(), K_QUERY_STRING, req.getQueryString(), K_SCHEME, req.isSecure() ? SCHEME_HTTPS : SCHEME_HTTP, K_REQUEST_METHOD, RingAdapter.methodToKeyword(req.getMethod()), K_PROTOCOL, req.getProtocol() != null ? req.getProtocol() : HTTP_1_1, K_HEADERS, headers, K_BODY, body});
    }

    public static HttpResponse buildResponse(IPersistentMap ringResp) {
        Object body;
        Object headersObj;
        HttpResponse resp = new HttpResponse();
        Object status = ringResp.valAt((Object)K_STATUS);
        if (status instanceof Number) {
            resp.setStatus(((Number)status).intValue());
        }
        if ((headersObj = ringResp.valAt((Object)K_HEADERS)) instanceof IPersistentMap) {
            IPersistentMap headers = (IPersistentMap)headersObj;
            for (ISeq seq = headers.seq(); seq != null; seq = seq.next()) {
                IMapEntry entry = (IMapEntry)seq.first();
                Object k = entry.key();
                Object v = entry.val();
                String keyStr = k instanceof Keyword ? ((Keyword)k).getName() : k.toString();
                resp.setHeader(keyStr, v.toString());
            }
        }
        if ((body = ringResp.valAt((Object)K_BODY)) != null) {
            if (body instanceof String) {
                resp.setBody((String)body);
            } else if (body instanceof byte[]) {
                resp.setBody((byte[])body);
            } else if (body instanceof InputStream) {
                resp.setBody((InputStream)body);
            } else if (body instanceof File) {
                resp.setBody((File)body);
            } else if (body instanceof ISeq || body instanceof List) {
                StringBuilder sb = new StringBuilder();
                if (body instanceof ISeq) {
                    for (ISeq seq = (ISeq)body; seq != null; seq = seq.next()) {
                        sb.append(seq.first());
                    }
                } else {
                    for (Object o : (List)body) {
                        sb.append(o);
                    }
                }
                resp.setBody(sb.toString());
            } else {
                resp.setBody(body.toString());
            }
        }
        return resp;
    }

    public static IPersistentMap errorResponse() {
        return PersistentArrayMap.createAsIfByAssoc((Object[])new Object[]{K_STATUS, 500, K_HEADERS, PersistentArrayMap.createAsIfByAssoc((Object[])new Object[]{"Content-Type", "text/plain"}), K_BODY, "Internal Server Error"});
    }
}

