/*
 * Decompiled with CFR 0.152.
 */
package zeph.http2.hpack;

import java.util.HashMap;
import java.util.Map;

public final class HpackStaticTable {
    public static final int SIZE = 61;
    private static final String[][] ENTRIES = new String[][]{{null, null}, {":authority", ""}, {":method", "GET"}, {":method", "POST"}, {":path", "/"}, {":path", "/index.html"}, {":scheme", "http"}, {":scheme", "https"}, {":status", "200"}, {":status", "204"}, {":status", "206"}, {":status", "304"}, {":status", "400"}, {":status", "404"}, {":status", "500"}, {"accept-charset", ""}, {"accept-encoding", "gzip, deflate"}, {"accept-language", ""}, {"accept-ranges", ""}, {"accept", ""}, {"access-control-allow-origin", ""}, {"age", ""}, {"allow", ""}, {"authorization", ""}, {"cache-control", ""}, {"content-disposition", ""}, {"content-encoding", ""}, {"content-language", ""}, {"content-length", ""}, {"content-location", ""}, {"content-range", ""}, {"content-type", ""}, {"cookie", ""}, {"date", ""}, {"etag", ""}, {"expect", ""}, {"expires", ""}, {"from", ""}, {"host", ""}, {"if-match", ""}, {"if-modified-since", ""}, {"if-none-match", ""}, {"if-range", ""}, {"if-unmodified-since", ""}, {"last-modified", ""}, {"link", ""}, {"location", ""}, {"max-forwards", ""}, {"proxy-authenticate", ""}, {"proxy-authorization", ""}, {"range", ""}, {"referer", ""}, {"refresh", ""}, {"retry-after", ""}, {"server", ""}, {"set-cookie", ""}, {"strict-transport-security", ""}, {"transfer-encoding", ""}, {"user-agent", ""}, {"vary", ""}, {"via", ""}, {"www-authenticate", ""}};
    private static final Map<String, Integer> NAME_INDEX = new HashMap<String, Integer>();
    private static final Map<String, Map<String, Integer>> NAME_VALUE_INDEX = new HashMap<String, Map<String, Integer>>();

    private HpackStaticTable() {
    }

    public static String[] getEntry(int index) {
        if (index < 1 || index > 61) {
            return null;
        }
        return ENTRIES[index];
    }

    public static String getName(int index) {
        if (index < 1 || index > 61) {
            return null;
        }
        return ENTRIES[index][0];
    }

    public static String getValue(int index) {
        if (index < 1 || index > 61) {
            return null;
        }
        return ENTRIES[index][1];
    }

    public static int findIndex(String name, String value) {
        Integer index;
        Map<String, Integer> valueMap = NAME_VALUE_INDEX.get(name);
        if (valueMap != null && (index = valueMap.get(value)) != null) {
            return index;
        }
        return -1;
    }

    public static int findNameIndex(String name) {
        Integer index = NAME_INDEX.get(name);
        return index != null ? index : -1;
    }

    static {
        for (int i = 1; i <= 61; ++i) {
            String name = ENTRIES[i][0];
            String value = ENTRIES[i][1];
            NAME_INDEX.putIfAbsent(name, i);
            NAME_VALUE_INDEX.computeIfAbsent(name, k -> new HashMap()).putIfAbsent(value, i);
        }
    }
}

