/*
 * Decompiled with CFR 0.152.
 */
package zeph.http2;

public class Http2Settings {
    public static final int HEADER_TABLE_SIZE = 1;
    public static final int ENABLE_PUSH = 2;
    public static final int MAX_CONCURRENT_STREAMS = 3;
    public static final int INITIAL_WINDOW_SIZE = 4;
    public static final int MAX_FRAME_SIZE = 5;
    public static final int MAX_HEADER_LIST_SIZE = 6;
    public static final int DEFAULT_HEADER_TABLE_SIZE = 4096;
    public static final int DEFAULT_ENABLE_PUSH = 1;
    public static final int DEFAULT_MAX_CONCURRENT_STREAMS = Integer.MAX_VALUE;
    public static final int DEFAULT_INITIAL_WINDOW_SIZE = 65535;
    public static final int DEFAULT_MAX_FRAME_SIZE = 16384;
    public static final int DEFAULT_MAX_HEADER_LIST_SIZE = Integer.MAX_VALUE;
    public static final int MAX_INITIAL_WINDOW_SIZE = Integer.MAX_VALUE;
    public static final int MIN_MAX_FRAME_SIZE = 16384;
    public static final int MAX_MAX_FRAME_SIZE = 0xFFFFFF;
    private int headerTableSize;
    private boolean enablePush;
    private int maxConcurrentStreams;
    private int initialWindowSize;
    private int maxFrameSize;
    private int maxHeaderListSize;

    public Http2Settings() {
        this.headerTableSize = 4096;
        this.enablePush = true;
        this.maxConcurrentStreams = Integer.MAX_VALUE;
        this.initialWindowSize = 65535;
        this.maxFrameSize = 16384;
        this.maxHeaderListSize = Integer.MAX_VALUE;
    }

    public Http2Settings(Http2Settings other) {
        this.headerTableSize = other.headerTableSize;
        this.enablePush = other.enablePush;
        this.maxConcurrentStreams = other.maxConcurrentStreams;
        this.initialWindowSize = other.initialWindowSize;
        this.maxFrameSize = other.maxFrameSize;
        this.maxHeaderListSize = other.maxHeaderListSize;
    }

    public boolean apply(int id, int value) {
        switch (id) {
            case 1: {
                if (value < 0) {
                    return false;
                }
                this.headerTableSize = value;
                return true;
            }
            case 2: {
                if (value != 0 && value != 1) {
                    return false;
                }
                this.enablePush = value == 1;
                return true;
            }
            case 3: {
                this.maxConcurrentStreams = value;
                return true;
            }
            case 4: {
                if (value < 0 || value > Integer.MAX_VALUE) {
                    return false;
                }
                this.initialWindowSize = value;
                return true;
            }
            case 5: {
                if (value < 16384 || value > 0xFFFFFF) {
                    return false;
                }
                this.maxFrameSize = value;
                return true;
            }
            case 6: {
                this.maxHeaderListSize = value;
                return true;
            }
        }
        return true;
    }

    public int getHeaderTableSize() {
        return this.headerTableSize;
    }

    public boolean isEnablePush() {
        return this.enablePush;
    }

    public int getMaxConcurrentStreams() {
        return this.maxConcurrentStreams;
    }

    public int getInitialWindowSize() {
        return this.initialWindowSize;
    }

    public int getMaxFrameSize() {
        return this.maxFrameSize;
    }

    public int getMaxHeaderListSize() {
        return this.maxHeaderListSize;
    }

    public void setHeaderTableSize(int headerTableSize) {
        this.headerTableSize = headerTableSize;
    }

    public void setEnablePush(boolean enablePush) {
        this.enablePush = enablePush;
    }

    public void setMaxConcurrentStreams(int maxConcurrentStreams) {
        this.maxConcurrentStreams = maxConcurrentStreams;
    }

    public void setInitialWindowSize(int initialWindowSize) {
        this.initialWindowSize = initialWindowSize;
    }

    public void setMaxFrameSize(int maxFrameSize) {
        this.maxFrameSize = maxFrameSize;
    }

    public void setMaxHeaderListSize(int maxHeaderListSize) {
        this.maxHeaderListSize = maxHeaderListSize;
    }

    public byte[] encode() {
        int count = 0;
        if (this.headerTableSize != 4096) {
            ++count;
        }
        if (!this.enablePush) {
            ++count;
        }
        if (this.maxConcurrentStreams != Integer.MAX_VALUE) {
            ++count;
        }
        if (this.initialWindowSize != 65535) {
            ++count;
        }
        if (this.maxFrameSize != 16384) {
            ++count;
        }
        if (this.maxHeaderListSize != Integer.MAX_VALUE) {
            ++count;
        }
        byte[] payload = new byte[count * 6];
        int offset = 0;
        if (this.headerTableSize != 4096) {
            offset = this.encodeSetting(payload, offset, 1, this.headerTableSize);
        }
        if (!this.enablePush) {
            offset = this.encodeSetting(payload, offset, 2, this.enablePush ? 1 : 0);
        }
        if (this.maxConcurrentStreams != Integer.MAX_VALUE) {
            offset = this.encodeSetting(payload, offset, 3, this.maxConcurrentStreams);
        }
        if (this.initialWindowSize != 65535) {
            offset = this.encodeSetting(payload, offset, 4, this.initialWindowSize);
        }
        if (this.maxFrameSize != 16384) {
            offset = this.encodeSetting(payload, offset, 5, this.maxFrameSize);
        }
        if (this.maxHeaderListSize != Integer.MAX_VALUE) {
            offset = this.encodeSetting(payload, offset, 6, this.maxHeaderListSize);
        }
        return payload;
    }

    private int encodeSetting(byte[] buf, int offset, int id, int value) {
        buf[offset++] = (byte)(id >> 8 & 0xFF);
        buf[offset++] = (byte)(id & 0xFF);
        buf[offset++] = (byte)(value >> 24 & 0xFF);
        buf[offset++] = (byte)(value >> 16 & 0xFF);
        buf[offset++] = (byte)(value >> 8 & 0xFF);
        buf[offset++] = (byte)(value & 0xFF);
        return offset;
    }

    public static Http2Settings decode(byte[] payload) {
        return Http2Settings.decode(payload, 0, payload.length);
    }

    public static Http2Settings decode(byte[] payload, int offset, int length) {
        Http2Settings settings = new Http2Settings();
        int end = offset + length;
        while (offset + 6 <= end) {
            int id = (payload[offset] & 0xFF) << 8 | payload[offset + 1] & 0xFF;
            int value = (payload[offset + 2] & 0xFF) << 24 | (payload[offset + 3] & 0xFF) << 16 | (payload[offset + 4] & 0xFF) << 8 | payload[offset + 5] & 0xFF;
            settings.apply(id, value);
            offset += 6;
        }
        return settings;
    }

    public static String name(int id) {
        return switch (id) {
            case 1 -> "HEADER_TABLE_SIZE";
            case 2 -> "ENABLE_PUSH";
            case 3 -> "MAX_CONCURRENT_STREAMS";
            case 4 -> "INITIAL_WINDOW_SIZE";
            case 5 -> "MAX_FRAME_SIZE";
            case 6 -> "MAX_HEADER_LIST_SIZE";
            default -> "UNKNOWN(" + id + ")";
        };
    }

    public String toString() {
        return "Http2Settings{headerTableSize=" + this.headerTableSize + ", enablePush=" + this.enablePush + ", maxConcurrentStreams=" + this.maxConcurrentStreams + ", initialWindowSize=" + this.initialWindowSize + ", maxFrameSize=" + this.maxFrameSize + ", maxHeaderListSize=" + this.maxHeaderListSize + "}";
    }
}

