/*
 * Decompiled with CFR 0.152.
 */
package zeph.http2;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import zeph.http.HttpRequest;
import zeph.http.HttpResponse;
import zeph.http2.Http2Connection;
import zeph.http2.Http2Frame;
import zeph.http2.Http2FrameReader;
import zeph.http2.Http2Stream;

public class Http2ServerHandler
implements Http2Connection.StreamHandler {
    private final Http2Connection connection;
    private final Function<HttpRequest, HttpResponse> handler;
    private final int serverPort;
    private final boolean secure;
    private final List<PendingResponse> pendingResponses = new ArrayList<PendingResponse>();
    private final List<StreamingResponse> pendingStreamingResponses = new ArrayList<StreamingResponse>();
    private StreamingResponse activeStreaming = null;
    private final Http2Connection.StreamHandler streamHandler = this;

    public Http2ServerHandler(Function<HttpRequest, HttpResponse> handler, int serverPort, boolean secure) {
        this.connection = new Http2Connection();
        this.connection.setStreamHandler(this);
        this.handler = handler;
        this.serverPort = serverPort;
        this.secure = secure;
    }

    public Http2Connection getConnection() {
        return this.connection;
    }

    public void setupUpgradeStream(HttpRequest http1Request) {
        ArrayList<String[]> headers = new ArrayList<String[]>();
        headers.add(new String[]{":method", http1Request.getMethod().name()});
        headers.add(new String[]{":path", http1Request.getPath() + (String)(http1Request.getQueryString() != null ? "?" + http1Request.getQueryString() : "")});
        headers.add(new String[]{":scheme", this.secure ? "https" : "http"});
        String host = http1Request.getHeader("host");
        if (host != null) {
            headers.add(new String[]{":authority", host});
        }
        for (Map.Entry<String, String> entry : http1Request.getHeaders().entrySet()) {
            String name = entry.getKey().toLowerCase();
            if (name.equals("connection") || name.equals("upgrade") || name.equals("http2-settings") || name.equals("host") || name.equals("keep-alive") || name.equals("transfer-encoding")) continue;
            headers.add(new String[]{name, entry.getValue()});
        }
        this.connection.createUpgradeStream(headers);
    }

    private void processUpgradeStream() {
        Http2Stream stream = this.connection.getUpgradeStream();
        if (stream != null && stream.isRequestComplete() && this.streamHandler != null) {
            this.onRequest(stream);
        }
    }

    public byte[] processData(byte[] data) throws Http2FrameReader.Http2Exception {
        Http2Frame frame;
        boolean wasAwaitingPreface;
        ByteBuffer input = ByteBuffer.wrap(data);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(65536);
        boolean bl = wasAwaitingPreface = this.connection.getState() == Http2Connection.State.AWAITING_PREFACE;
        if (wasAwaitingPreface) {
            if (!this.connection.processPreface(input)) {
                return null;
            }
            if (this.connection.getUpgradeStream() == null) {
                ByteBuffer temp = ByteBuffer.allocate(128);
                this.connection.writeServerPreface(temp);
                temp.flip();
                byte[] preface = new byte[temp.remaining()];
                temp.get(preface);
                outputStream.write(preface, 0, preface.length);
            }
        }
        Http2FrameReader frameReader = this.connection.getFrameReader();
        while (input.hasRemaining() && (frame = frameReader.readFrame(input)) != null) {
            Http2Connection.State prevState = this.connection.getState();
            List<Http2Frame> responses = this.connection.processFrame(frame);
            for (Http2Frame resp : responses) {
                byte[] encoded = resp.encode();
                outputStream.write(encoded, 0, encoded.length);
            }
            if (prevState != Http2Connection.State.AWAITING_SETTINGS || this.connection.getState() != Http2Connection.State.OPEN) continue;
            this.processUpgradeStream();
        }
        this.writePendingResponses(outputStream);
        byte[] result = outputStream.toByteArray();
        return (byte[])(result.length > 0 ? result : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRequest(Http2Stream stream) {
        boolean hasContentLength;
        InputStream bodyStream;
        HttpResponse response;
        HttpRequest request = this.streamToRequest(stream);
        try {
            response = this.handler.apply(request);
        }
        catch (Exception e) {
            response = HttpResponse.serverError();
        }
        ArrayList<String[]> responseHeaders = new ArrayList<String[]>();
        responseHeaders.add(new String[]{":status", String.valueOf(response.getStatus())});
        Map<String, String> headers = response.getHeaders();
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            String name = entry.getKey().toLowerCase();
            if (name.equals("connection") || name.equals("transfer-encoding") || name.equals("keep-alive")) continue;
            responseHeaders.add(new String[]{name, entry.getValue()});
        }
        if (response.isStreaming() && (bodyStream = response.getBodyStream()) != null) {
            long contentLength = response.getContentLength();
            if (contentLength >= 0L) {
                responseHeaders.add(new String[]{"content-length", String.valueOf(contentLength)});
            }
            int bufferSize = this.connection.getRemoteSettings().getMaxFrameSize();
            List<StreamingResponse> list = this.pendingStreamingResponses;
            synchronized (list) {
                this.pendingStreamingResponses.add(new StreamingResponse(stream.getStreamId(), responseHeaders, bodyStream, bufferSize));
            }
            return;
        }
        byte[] body = response.getBodyBytes();
        if (body != null && body.length > 0 && !(hasContentLength = headers.keySet().stream().anyMatch(k -> k.equalsIgnoreCase("content-length")))) {
            responseHeaders.add(new String[]{"content-length", String.valueOf(body.length)});
        }
        List<PendingResponse> list = this.pendingResponses;
        synchronized (list) {
            this.pendingResponses.add(new PendingResponse(stream.getStreamId(), responseHeaders, body));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePendingResponses(ByteArrayOutputStream outputStream) {
        List<Object> list = this.pendingResponses;
        synchronized (list) {
            for (PendingResponse resp : this.pendingResponses) {
                try {
                    boolean hasBody = resp.body != null && resp.body.length > 0;
                    ByteBuffer headerBuf = ByteBuffer.allocate(16384);
                    this.connection.writeResponseHeaders(headerBuf, resp.streamId, resp.headers, !hasBody);
                    headerBuf.flip();
                    outputStream.write(headerBuf.array(), 0, headerBuf.limit());
                    if (!hasBody) continue;
                    this.writeDataFrames(outputStream, resp.streamId, resp.body, true);
                }
                catch (Http2FrameReader.Http2Exception e) {
                    this.writeRstStreamToOutput(outputStream, resp.streamId, e.getErrorCode());
                }
            }
            this.pendingResponses.clear();
        }
        list = this.pendingStreamingResponses;
        synchronized (list) {
            if (!this.pendingStreamingResponses.isEmpty() && this.activeStreaming == null) {
                StreamingResponse sr = this.pendingStreamingResponses.remove(0);
                try {
                    ByteBuffer headerBuf = ByteBuffer.allocate(16384);
                    this.connection.writeResponseHeaders(headerBuf, sr.streamId, sr.headers, false);
                    headerBuf.flip();
                    outputStream.write(headerBuf.array(), 0, headerBuf.limit());
                    sr.currentRead = sr.stream.read(sr.buffer);
                    if (sr.currentRead <= 0) {
                        ByteBuffer frameBuf = ByteBuffer.allocate(9);
                        this.connection.writeResponseData(frameBuf, sr.streamId, new byte[0], true);
                        frameBuf.flip();
                        outputStream.write(frameBuf.array(), 0, frameBuf.limit());
                        sr.stream.close();
                    } else {
                        int nextRead = sr.stream.read(sr.nextBuffer);
                        boolean isLast = nextRead <= 0;
                        byte[] chunk = sr.currentRead == sr.buffer.length ? sr.buffer : Arrays.copyOf(sr.buffer, sr.currentRead);
                        ByteBuffer frameBuf = ByteBuffer.allocate(chunk.length + 9);
                        this.connection.writeResponseData(frameBuf, sr.streamId, chunk, isLast);
                        frameBuf.flip();
                        outputStream.write(frameBuf.array(), 0, frameBuf.limit());
                        if (isLast) {
                            sr.stream.close();
                        } else {
                            byte[] temp = sr.buffer;
                            sr.buffer = sr.nextBuffer;
                            sr.nextBuffer = temp;
                            sr.currentRead = nextRead;
                            this.activeStreaming = sr;
                        }
                    }
                }
                catch (Exception e) {
                    System.err.println("HTTP/2 streaming error: " + e.getMessage());
                    e.printStackTrace();
                    this.writeRstStreamToOutput(outputStream, sr.streamId, 2);
                    try {
                        sr.stream.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public boolean hasPendingStreaming() {
        return this.activeStreaming != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] continueStreaming() {
        if (this.activeStreaming == null) {
            return null;
        }
        StreamingResponse sr = this.activeStreaming;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(sr.buffer.length + 9);
        try {
            int nextRead = sr.stream.read(sr.nextBuffer);
            boolean isLast = nextRead <= 0;
            byte[] chunk = sr.currentRead == sr.buffer.length ? sr.buffer : Arrays.copyOf(sr.buffer, sr.currentRead);
            ByteBuffer frameBuf = ByteBuffer.allocate(chunk.length + 9);
            this.connection.writeResponseData(frameBuf, sr.streamId, chunk, isLast);
            frameBuf.flip();
            outputStream.write(frameBuf.array(), 0, frameBuf.limit());
            if (isLast) {
                sr.stream.close();
                this.activeStreaming = null;
                List<StreamingResponse> list = this.pendingStreamingResponses;
                synchronized (list) {
                    if (!this.pendingStreamingResponses.isEmpty()) {
                        StreamingResponse next = this.pendingStreamingResponses.remove(0);
                        this.startStreamingResponse(outputStream, next);
                    }
                }
            } else {
                byte[] temp = sr.buffer;
                sr.buffer = sr.nextBuffer;
                sr.nextBuffer = temp;
                sr.currentRead = nextRead;
            }
            return outputStream.toByteArray();
        }
        catch (Exception e) {
            System.err.println("HTTP/2 streaming error: " + e.getMessage());
            e.printStackTrace();
            try {
                sr.stream.close();
            }
            catch (Exception isLast) {
                // empty catch block
            }
            this.activeStreaming = null;
            ByteArrayOutputStream errOutput = new ByteArrayOutputStream(32);
            this.writeRstStreamToOutput(errOutput, sr.streamId, 2);
            return errOutput.toByteArray();
        }
    }

    private void startStreamingResponse(ByteArrayOutputStream outputStream, StreamingResponse sr) {
        try {
            ByteBuffer headerBuf = ByteBuffer.allocate(16384);
            this.connection.writeResponseHeaders(headerBuf, sr.streamId, sr.headers, false);
            headerBuf.flip();
            outputStream.write(headerBuf.array(), 0, headerBuf.limit());
            sr.currentRead = sr.stream.read(sr.buffer);
            if (sr.currentRead <= 0) {
                ByteBuffer frameBuf = ByteBuffer.allocate(9);
                this.connection.writeResponseData(frameBuf, sr.streamId, new byte[0], true);
                frameBuf.flip();
                outputStream.write(frameBuf.array(), 0, frameBuf.limit());
                sr.stream.close();
            } else {
                this.activeStreaming = sr;
            }
        }
        catch (Exception e) {
            System.err.println("HTTP/2 streaming error: " + e.getMessage());
            this.writeRstStreamToOutput(outputStream, sr.streamId, 2);
            try {
                sr.stream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void writeRstStreamToOutput(ByteArrayOutputStream outputStream, int streamId, int errorCode) {
        ByteBuffer rstBuf = ByteBuffer.allocate(32);
        this.connection.writeRstStream(rstBuf, streamId, errorCode);
        rstBuf.flip();
        outputStream.write(rstBuf.array(), 0, rstBuf.limit());
    }

    private void writeDataFrames(ByteArrayOutputStream outputStream, int streamId, byte[] body, boolean endStream) throws Http2FrameReader.Http2Exception {
        int chunkSize;
        int maxFrameSize = this.connection.getRemoteSettings().getMaxFrameSize();
        for (int offset = 0; offset < body.length; offset += chunkSize) {
            byte[] chunk;
            boolean isLast;
            chunkSize = Math.min(maxFrameSize, body.length - offset);
            boolean bl = isLast = offset + chunkSize >= body.length;
            if (offset == 0 && chunkSize == body.length) {
                chunk = body;
            } else {
                chunk = new byte[chunkSize];
                System.arraycopy(body, offset, chunk, 0, chunkSize);
            }
            ByteBuffer frameBuf = ByteBuffer.allocate(chunkSize + 9);
            this.connection.writeResponseData(frameBuf, streamId, chunk, isLast && endStream);
            frameBuf.flip();
            outputStream.write(frameBuf.array(), 0, frameBuf.limit());
        }
    }

    private HttpRequest streamToRequest(Http2Stream stream) {
        HttpRequest request = new HttpRequest();
        String method = null;
        String path = null;
        String scheme = null;
        String authority = null;
        HashMap<String, String> headers = new HashMap<String, String>();
        for (String[] header : stream.getRequestHeaders()) {
            String name = header[0];
            String value = header[1];
            if (name.startsWith(":")) {
                switch (name) {
                    case ":method": {
                        method = value;
                        break;
                    }
                    case ":path": {
                        path = value;
                        break;
                    }
                    case ":scheme": {
                        scheme = value;
                        break;
                    }
                    case ":authority": {
                        authority = value;
                    }
                }
                continue;
            }
            headers.put(name, value);
        }
        if (method != null) {
            request.setMethod(method);
        }
        if (path != null) {
            int queryIdx = path.indexOf(63);
            if (queryIdx >= 0) {
                request.setPath(path.substring(0, queryIdx));
                request.setQueryString(path.substring(queryIdx + 1));
            } else {
                request.setPath(path);
            }
        }
        for (Map.Entry entry : headers.entrySet()) {
            request.addHeader((String)entry.getKey(), (String)entry.getValue());
        }
        if (authority != null) {
            request.setServerName(authority);
            headers.put("host", authority);
        } else if (headers.containsKey("host")) {
            request.setServerName((String)headers.get("host"));
        }
        request.setSecure(this.secure || "https".equals(scheme));
        request.setServerPort(this.serverPort);
        byte[] body = stream.getRequestBody();
        if (body != null && body.length > 0) {
            request.setBody(new ByteArrayInputStream(body));
        }
        request.setProtocol("HTTP/2.0");
        return request;
    }

    public boolean isOpen() {
        return this.connection.isOpen();
    }

    public byte[] close() {
        ByteBuffer output = ByteBuffer.allocate(128);
        this.connection.writeGoaway(output, 0, null);
        output.flip();
        byte[] result = new byte[output.remaining()];
        output.get(result);
        return result;
    }

    public byte[] ping() {
        ByteBuffer output = ByteBuffer.allocate(32);
        byte[] opaqueData = new byte[8];
        System.currentTimeMillis();
        long time = System.nanoTime();
        for (int i = 0; i < 8; ++i) {
            opaqueData[i] = (byte)(time >> i * 8);
        }
        this.connection.getFrameWriter().writePing(output, opaqueData);
        output.flip();
        byte[] result = new byte[output.remaining()];
        output.get(result);
        return result;
    }

    private static class StreamingResponse {
        final int streamId;
        final InputStream stream;
        byte[] buffer;
        byte[] nextBuffer;
        int currentRead = 0;
        boolean headersSent = false;
        List<String[]> headers;

        StreamingResponse(int streamId, List<String[]> headers, InputStream stream, int bufferSize) {
            this.streamId = streamId;
            this.headers = headers;
            this.stream = stream;
            this.buffer = new byte[bufferSize];
            this.nextBuffer = new byte[bufferSize];
        }
    }

    private record PendingResponse(int streamId, List<String[]> headers, byte[] body) {
    }
}

