/*
 * Decompiled with CFR 0.152.
 */
package zeph.http2;

import java.nio.ByteBuffer;
import java.util.List;
import zeph.http2.Http2Frame;
import zeph.http2.Http2FrameType;
import zeph.http2.Http2Settings;
import zeph.http2.hpack.HpackEncoder;

public class Http2FrameWriter {
    private final int maxFrameSize;
    private final HpackEncoder hpackEncoder;

    public Http2FrameWriter() {
        this(16384);
    }

    public Http2FrameWriter(int maxFrameSize) {
        this.maxFrameSize = maxFrameSize;
        this.hpackEncoder = new HpackEncoder();
    }

    public void writeConnectionPreface(ByteBuffer buf) {
        buf.put(Http2FrameType.CONNECTION_PREFACE);
    }

    public void writeFrame(ByteBuffer buf, Http2Frame frame) {
        byte[] encoded = frame.encode();
        buf.put(encoded);
    }

    public void writeSettings(ByteBuffer buf, Http2Settings settings) {
        this.writeFrame(buf, Http2Frame.settings(settings));
    }

    public void writeSettingsAck(ByteBuffer buf) {
        this.writeFrame(buf, Http2Frame.settingsAck());
    }

    public void writePing(ByteBuffer buf, byte[] opaqueData) {
        this.writeFrame(buf, Http2Frame.ping(opaqueData));
    }

    public void writePingAck(ByteBuffer buf, byte[] opaqueData) {
        this.writeFrame(buf, Http2Frame.pingAck(opaqueData));
    }

    public void writeGoaway(ByteBuffer buf, int lastStreamId, int errorCode) {
        this.writeFrame(buf, Http2Frame.goaway(lastStreamId, errorCode));
    }

    public void writeGoaway(ByteBuffer buf, int lastStreamId, int errorCode, String debugData) {
        this.writeFrame(buf, Http2Frame.goaway(lastStreamId, errorCode, debugData != null ? debugData.getBytes() : null));
    }

    public void writeRstStream(ByteBuffer buf, int streamId, int errorCode) {
        this.writeFrame(buf, Http2Frame.rstStream(streamId, errorCode));
    }

    public void writeWindowUpdate(ByteBuffer buf, int streamId, int windowSizeIncrement) {
        this.writeFrame(buf, Http2Frame.windowUpdate(streamId, windowSizeIncrement));
    }

    public void writeHeaders(ByteBuffer buf, int streamId, List<String[]> headers, boolean endStream) {
        byte[] headerBlock = this.hpackEncoder.encode(headers);
        this.writeHeaderBlock(buf, streamId, headerBlock, endStream);
    }

    public void writeHeaderBlock(ByteBuffer buf, int streamId, byte[] headerBlock, boolean endStream) {
        int payloadLen;
        int maxPayload = this.maxFrameSize;
        boolean first = true;
        for (int offset = 0; offset < headerBlock.length; offset += payloadLen) {
            int remaining = headerBlock.length - offset;
            payloadLen = Math.min(remaining, maxPayload);
            boolean last = offset + payloadLen >= headerBlock.length;
            byte[] payload = new byte[payloadLen];
            System.arraycopy(headerBlock, offset, payload, 0, payloadLen);
            if (first) {
                this.writeFrame(buf, Http2Frame.headers(streamId, payload, endStream, last));
                first = false;
                continue;
            }
            this.writeFrame(buf, Http2Frame.continuation(streamId, payload, last));
        }
    }

    public void writeData(ByteBuffer buf, int streamId, byte[] data, boolean endStream) {
        int payloadLen;
        int maxPayload = this.maxFrameSize;
        for (int offset = 0; offset < data.length; offset += payloadLen) {
            int remaining = data.length - offset;
            payloadLen = Math.min(remaining, maxPayload);
            boolean last = offset + payloadLen >= data.length;
            byte[] payload = new byte[payloadLen];
            System.arraycopy(data, offset, payload, 0, payloadLen);
            this.writeFrame(buf, Http2Frame.data(streamId, payload, endStream && last));
        }
        if (data.length == 0 && endStream) {
            this.writeFrame(buf, Http2Frame.data(streamId, new byte[0], true));
        }
    }

    public void setMaxHeaderTableSize(int maxSize) {
        this.hpackEncoder.setMaxTableSize(maxSize);
    }

    public HpackEncoder getHpackEncoder() {
        return this.hpackEncoder;
    }
}

