/*
 * Decompiled with CFR 0.152.
 */
package zeph.http2;

import java.nio.ByteBuffer;
import zeph.http2.Http2FrameType;
import zeph.http2.Http2Settings;

public class Http2Frame {
    private final int type;
    private final int flags;
    private final int streamId;
    private final byte[] payload;

    public Http2Frame(int type, int flags, int streamId, byte[] payload) {
        this.type = type;
        this.flags = flags;
        this.streamId = streamId;
        this.payload = payload != null ? payload : new byte[]{};
    }

    public int getType() {
        return this.type;
    }

    public int getFlags() {
        return this.flags;
    }

    public int getStreamId() {
        return this.streamId;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public int getLength() {
        return this.payload.length;
    }

    public boolean hasFlag(int flag) {
        return (this.flags & flag) != 0;
    }

    public boolean isEndStream() {
        return this.hasFlag(1);
    }

    public boolean isEndHeaders() {
        return this.hasFlag(4);
    }

    public boolean isAck() {
        return this.hasFlag(1);
    }

    public boolean isPadded() {
        return this.hasFlag(8);
    }

    public boolean hasPriority() {
        return this.hasFlag(32);
    }

    public byte[] encode() {
        byte[] buf = new byte[9 + this.payload.length];
        int length = this.payload.length;
        buf[0] = (byte)(length >> 16 & 0xFF);
        buf[1] = (byte)(length >> 8 & 0xFF);
        buf[2] = (byte)(length & 0xFF);
        buf[3] = (byte)this.type;
        buf[4] = (byte)this.flags;
        buf[5] = (byte)(this.streamId >> 24 & 0x7F);
        buf[6] = (byte)(this.streamId >> 16 & 0xFF);
        buf[7] = (byte)(this.streamId >> 8 & 0xFF);
        buf[8] = (byte)(this.streamId & 0xFF);
        System.arraycopy(this.payload, 0, buf, 9, this.payload.length);
        return buf;
    }

    public void encodeHeaderTo(ByteBuffer buf) {
        int length = this.payload.length;
        buf.put((byte)(length >> 16 & 0xFF));
        buf.put((byte)(length >> 8 & 0xFF));
        buf.put((byte)(length & 0xFF));
        buf.put((byte)this.type);
        buf.put((byte)this.flags);
        buf.put((byte)(this.streamId >> 24 & 0x7F));
        buf.put((byte)(this.streamId >> 16 & 0xFF));
        buf.put((byte)(this.streamId >> 8 & 0xFF));
        buf.put((byte)(this.streamId & 0xFF));
    }

    public static Http2Frame settings(Http2Settings settings) {
        return new Http2Frame(4, 0, 0, settings.encode());
    }

    public static Http2Frame settingsAck() {
        return new Http2Frame(4, 1, 0, null);
    }

    public static Http2Frame ping(byte[] opaqueData) {
        if (opaqueData == null || opaqueData.length != 8) {
            throw new IllegalArgumentException("PING opaque data must be 8 bytes");
        }
        return new Http2Frame(6, 0, 0, opaqueData);
    }

    public static Http2Frame pingAck(byte[] opaqueData) {
        if (opaqueData == null || opaqueData.length != 8) {
            throw new IllegalArgumentException("PING opaque data must be 8 bytes");
        }
        return new Http2Frame(6, 1, 0, opaqueData);
    }

    public static Http2Frame goaway(int lastStreamId, int errorCode) {
        return Http2Frame.goaway(lastStreamId, errorCode, null);
    }

    public static Http2Frame goaway(int lastStreamId, int errorCode, byte[] debugData) {
        int debugLen = debugData != null ? debugData.length : 0;
        byte[] payload = new byte[8 + debugLen];
        payload[0] = (byte)(lastStreamId >> 24 & 0x7F);
        payload[1] = (byte)(lastStreamId >> 16 & 0xFF);
        payload[2] = (byte)(lastStreamId >> 8 & 0xFF);
        payload[3] = (byte)(lastStreamId & 0xFF);
        payload[4] = (byte)(errorCode >> 24 & 0xFF);
        payload[5] = (byte)(errorCode >> 16 & 0xFF);
        payload[6] = (byte)(errorCode >> 8 & 0xFF);
        payload[7] = (byte)(errorCode & 0xFF);
        if (debugData != null) {
            System.arraycopy(debugData, 0, payload, 8, debugData.length);
        }
        return new Http2Frame(7, 0, 0, payload);
    }

    public static Http2Frame rstStream(int streamId, int errorCode) {
        byte[] payload = new byte[]{(byte)(errorCode >> 24 & 0xFF), (byte)(errorCode >> 16 & 0xFF), (byte)(errorCode >> 8 & 0xFF), (byte)(errorCode & 0xFF)};
        return new Http2Frame(3, 0, streamId, payload);
    }

    public static Http2Frame windowUpdate(int streamId, int windowSizeIncrement) {
        if (windowSizeIncrement <= 0 || windowSizeIncrement > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Window size increment must be 1-2147483647");
        }
        byte[] payload = new byte[]{(byte)(windowSizeIncrement >> 24 & 0x7F), (byte)(windowSizeIncrement >> 16 & 0xFF), (byte)(windowSizeIncrement >> 8 & 0xFF), (byte)(windowSizeIncrement & 0xFF)};
        return new Http2Frame(8, 0, streamId, payload);
    }

    public static Http2Frame headers(int streamId, byte[] headerBlock, boolean endStream, boolean endHeaders) {
        int flags = 0;
        if (endStream) {
            flags |= 1;
        }
        if (endHeaders) {
            flags |= 4;
        }
        return new Http2Frame(1, flags, streamId, headerBlock);
    }

    public static Http2Frame continuation(int streamId, byte[] headerBlock, boolean endHeaders) {
        int flags = endHeaders ? 4 : 0;
        return new Http2Frame(9, flags, streamId, headerBlock);
    }

    public static Http2Frame data(int streamId, byte[] data, boolean endStream) {
        int flags = endStream ? 1 : 0;
        return new Http2Frame(0, flags, streamId, data);
    }

    public String toString() {
        return "Http2Frame{type=" + Http2FrameType.name(this.type) + ", flags=0x" + Integer.toHexString(this.flags) + ", streamId=" + this.streamId + ", length=" + this.payload.length + "}";
    }
}

