/*
 * Decompiled with CFR 0.152.
 */
package zeph.http2;

public final class Http2Error {
    public static final int NO_ERROR = 0;
    public static final int PROTOCOL_ERROR = 1;
    public static final int INTERNAL_ERROR = 2;
    public static final int FLOW_CONTROL_ERROR = 3;
    public static final int SETTINGS_TIMEOUT = 4;
    public static final int STREAM_CLOSED = 5;
    public static final int FRAME_SIZE_ERROR = 6;
    public static final int REFUSED_STREAM = 7;
    public static final int CANCEL = 8;
    public static final int COMPRESSION_ERROR = 9;
    public static final int CONNECT_ERROR = 10;
    public static final int ENHANCE_YOUR_CALM = 11;
    public static final int INADEQUATE_SECURITY = 12;
    public static final int HTTP_1_1_REQUIRED = 13;

    private Http2Error() {
    }

    public static String name(int errorCode) {
        return switch (errorCode) {
            case 0 -> "NO_ERROR";
            case 1 -> "PROTOCOL_ERROR";
            case 2 -> "INTERNAL_ERROR";
            case 3 -> "FLOW_CONTROL_ERROR";
            case 4 -> "SETTINGS_TIMEOUT";
            case 5 -> "STREAM_CLOSED";
            case 6 -> "FRAME_SIZE_ERROR";
            case 7 -> "REFUSED_STREAM";
            case 8 -> "CANCEL";
            case 9 -> "COMPRESSION_ERROR";
            case 10 -> "CONNECT_ERROR";
            case 11 -> "ENHANCE_YOUR_CALM";
            case 12 -> "INADEQUATE_SECURITY";
            case 13 -> "HTTP_1_1_REQUIRED";
            default -> "UNKNOWN(" + errorCode + ")";
        };
    }
}

