/*
 * Decompiled with CFR 0.152.
 */
package zeph.http;

import java.util.HashMap;
import java.util.Map;

public enum HttpStatus {
    CONTINUE(100, "Continue"),
    SWITCHING_PROTOCOLS(101, "Switching Protocols"),
    OK(200, "OK"),
    CREATED(201, "Created"),
    ACCEPTED(202, "Accepted"),
    NO_CONTENT(204, "No Content"),
    PARTIAL_CONTENT(206, "Partial Content"),
    MOVED_PERMANENTLY(301, "Moved Permanently"),
    FOUND(302, "Found"),
    SEE_OTHER(303, "See Other"),
    NOT_MODIFIED(304, "Not Modified"),
    TEMPORARY_REDIRECT(307, "Temporary Redirect"),
    PERMANENT_REDIRECT(308, "Permanent Redirect"),
    BAD_REQUEST(400, "Bad Request"),
    UNAUTHORIZED(401, "Unauthorized"),
    FORBIDDEN(403, "Forbidden"),
    NOT_FOUND(404, "Not Found"),
    METHOD_NOT_ALLOWED(405, "Method Not Allowed"),
    NOT_ACCEPTABLE(406, "Not Acceptable"),
    REQUEST_TIMEOUT(408, "Request Timeout"),
    CONFLICT(409, "Conflict"),
    GONE(410, "Gone"),
    LENGTH_REQUIRED(411, "Length Required"),
    PAYLOAD_TOO_LARGE(413, "Payload Too Large"),
    URI_TOO_LONG(414, "URI Too Long"),
    UNSUPPORTED_MEDIA_TYPE(415, "Unsupported Media Type"),
    TOO_MANY_REQUESTS(429, "Too Many Requests"),
    INTERNAL_SERVER_ERROR(500, "Internal Server Error"),
    NOT_IMPLEMENTED(501, "Not Implemented"),
    BAD_GATEWAY(502, "Bad Gateway"),
    SERVICE_UNAVAILABLE(503, "Service Unavailable"),
    GATEWAY_TIMEOUT(504, "Gateway Timeout");

    private final int code;
    private final String reason;
    private final byte[] statusLineBytes;
    private static final Map<Integer, HttpStatus> BY_CODE;

    private HttpStatus(int code, String reason) {
        this.code = code;
        this.reason = reason;
        String line = "HTTP/1.1 " + code + " " + reason + "\r\n";
        this.statusLineBytes = line.getBytes();
    }

    public int getCode() {
        return this.code;
    }

    public String getReason() {
        return this.reason;
    }

    public byte[] getStatusLineBytes() {
        return this.statusLineBytes;
    }

    public static HttpStatus valueOf(int code) {
        HttpStatus status = BY_CODE.get(code);
        return status != null ? status : INTERNAL_SERVER_ERROR;
    }

    public static byte[] getStatusLineBytes(int code) {
        return HttpStatus.valueOf((int)code).statusLineBytes;
    }

    static {
        BY_CODE = new HashMap<Integer, HttpStatus>();
        for (HttpStatus status : HttpStatus.values()) {
            BY_CODE.put(status.code, status);
        }
    }
}

