/*
 * Decompiled with CFR 0.152.
 */
package zeph.http;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import zeph.buffer.DynamicBytes;
import zeph.http.HttpStatus;

public class HttpResponse {
    private int status = 200;
    private String[] headers = new String[16];
    private int headerCount = 0;
    private byte[] body;
    private InputStream bodyStream;
    private File bodyFile;
    private long contentLength = -1L;
    private byte[] cachedEncoded;
    private static final ThreadLocal<DynamicBytes> ENCODER = ThreadLocal.withInitial(() -> new DynamicBytes(512));
    private static final byte[] SERVER_HEADER = "Server: Zeph/0.1\r\n".getBytes();
    private static final byte[] CONTENT_LENGTH = "Content-Length: ".getBytes();
    private static final byte[] CONTENT_TYPE = "Content-Type: ".getBytes();
    private static final byte[] CONNECTION = "Connection: ".getBytes();
    private static final byte[] CRLF = "\r\n".getBytes();
    private static final byte[] TRANSFER_ENCODING_CHUNKED = "Transfer-Encoding: chunked\r\n".getBytes();

    public int getStatus() {
        return this.status;
    }

    public HttpResponse setStatus(int status) {
        this.status = status;
        return this;
    }

    public String getHeader(String name) {
        for (int i = 0; i < this.headerCount * 2; i += 2) {
            if (!name.equalsIgnoreCase(this.headers[i])) continue;
            return this.headers[i + 1];
        }
        return null;
    }

    public Map<String, String> getHeaders() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < this.headerCount * 2; i += 2) {
            map.put(this.headers[i], this.headers[i + 1]);
        }
        return map;
    }

    public byte[] getBodyBytes() {
        return this.body;
    }

    public HttpResponse setHeader(String name, String value) {
        for (int i = 0; i < this.headerCount * 2; i += 2) {
            if (!name.equalsIgnoreCase(this.headers[i])) continue;
            this.headers[i + 1] = value;
            return this;
        }
        int idx = this.headerCount * 2;
        if (idx >= this.headers.length) {
            String[] newHeaders = new String[this.headers.length * 2];
            System.arraycopy(this.headers, 0, newHeaders, 0, this.headers.length);
            this.headers = newHeaders;
        }
        this.headers[idx] = name;
        this.headers[idx + 1] = value;
        ++this.headerCount;
        return this;
    }

    public byte[] getBody() {
        return this.body;
    }

    public HttpResponse setBody(byte[] body) {
        this.body = body;
        return this;
    }

    public HttpResponse setBody(String body) {
        this.body = body.getBytes(StandardCharsets.UTF_8);
        return this;
    }

    public HttpResponse setBody(InputStream stream) {
        this.bodyStream = stream;
        this.body = null;
        this.bodyFile = null;
        return this;
    }

    public HttpResponse setBody(InputStream stream, long contentLength) {
        this.bodyStream = stream;
        this.contentLength = contentLength;
        this.body = null;
        this.bodyFile = null;
        return this;
    }

    public HttpResponse setBody(File file) {
        this.bodyFile = file;
        this.contentLength = file.length();
        this.body = null;
        this.bodyStream = null;
        return this;
    }

    public boolean isStreaming() {
        return this.bodyStream != null || this.bodyFile != null;
    }

    public InputStream getBodyStream() {
        if (this.bodyStream != null) {
            return this.bodyStream;
        }
        if (this.bodyFile != null) {
            try {
                return new FileInputStream(this.bodyFile);
            }
            catch (FileNotFoundException e) {
                return null;
            }
        }
        return null;
    }

    public long getContentLength() {
        if (this.contentLength >= 0L) {
            return this.contentLength;
        }
        if (this.body != null) {
            return this.body.length;
        }
        if (this.bodyFile != null) {
            return this.bodyFile.length();
        }
        return -1L;
    }

    public HttpResponse setContentType(String contentType) {
        return this.setHeader("Content-Type", contentType);
    }

    public byte[] encode() {
        if (this.cachedEncoded != null) {
            return this.cachedEncoded;
        }
        DynamicBytes buf = ENCODER.get();
        buf.reset();
        buf.append(HttpStatus.getStatusLineBytes(this.status));
        buf.append(SERVER_HEADER);
        int bodyLen = this.body != null ? this.body.length : 0;
        buf.append(CONTENT_LENGTH).appendInt(bodyLen).crlf();
        for (int i = 0; i < this.headerCount * 2; i += 2) {
            String key = this.headers[i];
            String value = this.headers[i + 1];
            if ("Content-Type".equalsIgnoreCase(key)) {
                buf.append(CONTENT_TYPE).append(value).crlf();
                continue;
            }
            if ("Connection".equalsIgnoreCase(key)) {
                buf.append(CONNECTION).append(value).crlf();
                continue;
            }
            buf.appendHeader(key, value);
        }
        buf.crlf();
        if (this.body != null && this.body.length > 0) {
            buf.append(this.body);
        }
        return buf.toByteArray();
    }

    public HttpResponse cache() {
        this.cachedEncoded = this.encode();
        return this;
    }

    public byte[] encodeHeaders() {
        DynamicBytes buf = ENCODER.get();
        buf.reset();
        buf.append(HttpStatus.getStatusLineBytes(this.status));
        buf.append(SERVER_HEADER);
        int bodyLen = this.body != null ? this.body.length : 0;
        buf.append(CONTENT_LENGTH).appendInt(bodyLen).crlf();
        for (int i = 0; i < this.headerCount * 2; i += 2) {
            String key = this.headers[i];
            String value = this.headers[i + 1];
            if ("Content-Type".equalsIgnoreCase(key)) {
                buf.append(CONTENT_TYPE).append(value).crlf();
                continue;
            }
            if ("Connection".equalsIgnoreCase(key)) {
                buf.append(CONNECTION).append(value).crlf();
                continue;
            }
            buf.appendHeader(key, value);
        }
        buf.crlf();
        return buf.toByteArray();
    }

    public byte[] encodeStreamingHeaders() {
        DynamicBytes buf = ENCODER.get();
        buf.reset();
        buf.append(HttpStatus.getStatusLineBytes(this.status));
        buf.append(SERVER_HEADER);
        long length = this.getContentLength();
        if (length >= 0L) {
            buf.append(CONTENT_LENGTH).appendLong(length).crlf();
        } else {
            buf.append(TRANSFER_ENCODING_CHUNKED);
        }
        for (int i = 0; i < this.headerCount * 2; i += 2) {
            String key = this.headers[i];
            String value = this.headers[i + 1];
            if ("Content-Length".equalsIgnoreCase(key) || "Transfer-Encoding".equalsIgnoreCase(key)) continue;
            if ("Content-Type".equalsIgnoreCase(key)) {
                buf.append(CONTENT_TYPE).append(value).crlf();
                continue;
            }
            if ("Connection".equalsIgnoreCase(key)) {
                buf.append(CONNECTION).append(value).crlf();
                continue;
            }
            buf.appendHeader(key, value);
        }
        buf.crlf();
        return buf.toByteArray();
    }

    public void reset() {
        this.status = 200;
        this.headerCount = 0;
        this.body = null;
        this.bodyStream = null;
        this.bodyFile = null;
        this.contentLength = -1L;
        this.cachedEncoded = null;
    }

    public static HttpResponse ok() {
        return new HttpResponse().setStatus(200);
    }

    public static HttpResponse ok(String body) {
        return new HttpResponse().setStatus(200).setContentType("text/plain; charset=utf-8").setBody(body);
    }

    public static HttpResponse json(String json) {
        return new HttpResponse().setStatus(200).setContentType("application/json; charset=utf-8").setBody(json);
    }

    public static HttpResponse html(String html) {
        return new HttpResponse().setStatus(200).setContentType("text/html; charset=utf-8").setBody(html);
    }

    public static HttpResponse notFound() {
        return new HttpResponse().setStatus(404).setContentType("text/plain; charset=utf-8").setBody("Not Found");
    }

    public static HttpResponse badRequest() {
        return new HttpResponse().setStatus(400).setContentType("text/plain; charset=utf-8").setBody("Bad Request");
    }

    public static HttpResponse serverError() {
        return new HttpResponse().setStatus(500).setContentType("text/plain; charset=utf-8").setBody("Internal Server Error");
    }

    public String toString() {
        return "HttpResponse{status=" + this.status + ", headers=" + this.headerCount + ", bodyLen=" + (this.body != null ? this.body.length : 0) + "}";
    }
}

