/*
 * Decompiled with CFR 0.152.
 */
package zeph.http;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import zeph.http.HttpMethod;
import zeph.http.HttpRequest;

public class HttpParser {
    private static final int STATE_REQUEST_LINE = 0;
    private static final int STATE_HEADERS = 1;
    private static final int STATE_BODY = 2;
    private static final int STATE_COMPLETE = 3;
    private static final int STATE_ERROR = -1;
    private static final int MAX_REQUEST_LINE = 8192;
    private static final int MAX_HEADER_SIZE = 8192;
    private static final int MAX_HEADERS = 100;
    private static final int MAX_BODY_SIZE = 0x800000;
    private int state = 0;
    private final HttpRequest request = new HttpRequest();
    private byte[] buffer = new byte[8192];
    private int bufferPos = 0;
    private int contentLength = -1;
    private int bodyBytesRead = 0;
    private byte[] bodyBuffer;
    private String errorMessage;

    public Result parse(byte[] data, int offset, int length) {
        this.ensureCapacity(this.bufferPos + length);
        System.arraycopy(data, offset, this.buffer, this.bufferPos, length);
        this.bufferPos += length;
        while (true) {
            switch (this.state) {
                case 0: {
                    Result r = this.parseRequestLine();
                    if (r != Result.COMPLETE) {
                        return r;
                    }
                    this.state = 1;
                    break;
                }
                case 1: {
                    Result r = this.parseHeaders();
                    if (r != Result.COMPLETE) {
                        return r;
                    }
                    this.contentLength = this.request.getContentLength();
                    if (this.contentLength > 0) {
                        if (this.contentLength > 0x800000) {
                            this.errorMessage = "Body too large";
                            this.state = -1;
                            return Result.ERROR;
                        }
                        this.bodyBuffer = new byte[this.contentLength];
                        this.state = 2;
                        break;
                    }
                    this.state = 3;
                    return Result.COMPLETE;
                }
                case 2: {
                    Result r = this.parseBody();
                    if (r != Result.COMPLETE) {
                        return r;
                    }
                    this.state = 3;
                    return Result.COMPLETE;
                }
                case 3: {
                    return Result.COMPLETE;
                }
                case -1: {
                    return Result.ERROR;
                }
            }
        }
    }

    private Result parseRequestLine() {
        int lineEnd = this.findCRLF(0);
        if (lineEnd < 0) {
            if (this.bufferPos > 8192) {
                this.errorMessage = "Request line too long";
                this.state = -1;
                return Result.ERROR;
            }
            return Result.NEED_MORE_DATA;
        }
        String line = new String(this.buffer, 0, lineEnd, StandardCharsets.US_ASCII);
        int firstSpace = line.indexOf(32);
        if (firstSpace < 0) {
            this.errorMessage = "Invalid request line";
            this.state = -1;
            return Result.ERROR;
        }
        int secondSpace = line.indexOf(32, firstSpace + 1);
        if (secondSpace < 0) {
            this.errorMessage = "Invalid request line";
            this.state = -1;
            return Result.ERROR;
        }
        String methodStr = line.substring(0, firstSpace);
        String uri = line.substring(firstSpace + 1, secondSpace);
        String version = line.substring(secondSpace + 1);
        try {
            this.request.setMethod(HttpMethod.parse(methodStr));
        }
        catch (IllegalArgumentException e) {
            this.errorMessage = "Unknown HTTP method: " + methodStr;
            this.state = -1;
            return Result.ERROR;
        }
        this.request.setUri(uri);
        this.request.setVersion(version);
        this.compact(lineEnd + 2);
        return Result.COMPLETE;
    }

    private Result parseHeaders() {
        int headerCount = 0;
        while (true) {
            int lineEnd;
            if ((lineEnd = this.findCRLF(0)) < 0) {
                if (this.bufferPos > 8192) {
                    this.errorMessage = "Headers too large";
                    this.state = -1;
                    return Result.ERROR;
                }
                return Result.NEED_MORE_DATA;
            }
            if (lineEnd == 0) {
                this.compact(2);
                return Result.COMPLETE;
            }
            String line = new String(this.buffer, 0, lineEnd, StandardCharsets.US_ASCII);
            int colonIdx = line.indexOf(58);
            if (colonIdx < 0) {
                this.errorMessage = "Invalid header line";
                this.state = -1;
                return Result.ERROR;
            }
            String name = line.substring(0, colonIdx).trim();
            String value = line.substring(colonIdx + 1).trim();
            this.request.setHeader(name, value);
            if (++headerCount > 100) {
                this.errorMessage = "Too many headers";
                this.state = -1;
                return Result.ERROR;
            }
            this.compact(lineEnd + 2);
        }
    }

    private Result parseBody() {
        int remaining = this.contentLength - this.bodyBytesRead;
        int available = this.bufferPos;
        int toCopy = Math.min(remaining, available);
        if (toCopy > 0) {
            System.arraycopy(this.buffer, 0, this.bodyBuffer, this.bodyBytesRead, toCopy);
            this.bodyBytesRead += toCopy;
            this.compact(toCopy);
        }
        if (this.bodyBytesRead >= this.contentLength) {
            this.request.setBody(this.bodyBuffer);
            return Result.COMPLETE;
        }
        return Result.NEED_MORE_DATA;
    }

    private int findCRLF(int start) {
        for (int i = start; i < this.bufferPos - 1; ++i) {
            if (this.buffer[i] != 13 || this.buffer[i + 1] != 10) continue;
            return i;
        }
        return -1;
    }

    private void compact(int consumed) {
        if (consumed > 0 && consumed <= this.bufferPos) {
            System.arraycopy(this.buffer, consumed, this.buffer, 0, this.bufferPos - consumed);
            this.bufferPos -= consumed;
        }
    }

    private void ensureCapacity(int required) {
        if (required > this.buffer.length) {
            int newSize = Math.max(this.buffer.length * 2, required);
            this.buffer = Arrays.copyOf(this.buffer, newSize);
        }
    }

    public HttpRequest getRequest() {
        return this.request;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public boolean isComplete() {
        return this.state == 3;
    }

    public boolean isError() {
        return this.state == -1;
    }

    public void reset() {
        this.state = 0;
        this.bufferPos = 0;
        this.contentLength = -1;
        this.bodyBytesRead = 0;
        this.bodyBuffer = null;
        this.errorMessage = null;
        this.request.reset();
    }

    public static enum Result {
        NEED_MORE_DATA,
        COMPLETE,
        ERROR;

    }
}

