/*
 * Decompiled with CFR 0.152.
 */
package zeph.core;

import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;

public class Connection
implements AutoCloseable {
    private static final int BUFFER_SIZE = 8192;
    private final int fd;
    private final long id;
    private final MemorySegment readBuffer;
    private final MemorySegment writeBuffer;
    private final Arena arena;
    private volatile boolean closed = false;
    private Object attachment;

    public Connection(int fd, long id, Arena parentArena) {
        this.fd = fd;
        this.id = id;
        this.arena = Arena.ofShared();
        this.readBuffer = this.arena.allocate(8192L);
        this.writeBuffer = this.arena.allocate(8192L);
    }

    public int getFd() {
        return this.fd;
    }

    public long getId() {
        return this.id;
    }

    public MemorySegment getReadBuffer() {
        return this.readBuffer;
    }

    public MemorySegment getWriteBuffer() {
        return this.writeBuffer;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public Object getAttachment() {
        return this.attachment;
    }

    public void setAttachment(Object attachment) {
        this.attachment = attachment;
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            this.arena.close();
        }
    }

    public String toString() {
        return "Connection{fd=" + this.fd + ", id=" + this.id + ", closed=" + this.closed + "}";
    }
}

