/*
 * Decompiled with CFR 0.152.
 */
package zeph.client;

import java.nio.charset.StandardCharsets;
import java.util.Map;

public class HttpClientResponse {
    private final int status;
    private final String statusMessage;
    private final Map<String, String> headers;
    private final byte[] body;
    private final Exception error;
    private final Map<String, Object> opts;

    public HttpClientResponse(int status, String statusMessage, Map<String, String> headers, byte[] body, Map<String, Object> opts) {
        this.status = status;
        this.statusMessage = statusMessage;
        this.headers = headers;
        this.body = body;
        this.error = null;
        this.opts = opts;
    }

    public HttpClientResponse(Exception error, Map<String, Object> opts) {
        this.status = -1;
        this.statusMessage = null;
        this.headers = null;
        this.body = null;
        this.error = error;
        this.opts = opts;
    }

    public int getStatus() {
        return this.status;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public String getHeader(String name) {
        if (this.headers == null) {
            return null;
        }
        return this.headers.get(name.toLowerCase());
    }

    public byte[] getBody() {
        return this.body;
    }

    public String getBodyAsString() {
        if (this.body == null) {
            return null;
        }
        return new String(this.body, StandardCharsets.UTF_8);
    }

    public Exception getError() {
        return this.error;
    }

    public boolean hasError() {
        return this.error != null;
    }

    public Map<String, Object> getOpts() {
        return this.opts;
    }

    public boolean isKeepAlive() {
        if (this.headers == null) {
            return false;
        }
        String connection = this.headers.get("connection");
        if (connection != null) {
            if (connection.toLowerCase().contains("close")) {
                return false;
            }
            if (connection.toLowerCase().contains("keep-alive")) {
                return true;
            }
        }
        return true;
    }

    public boolean isRedirect() {
        return this.status == 301 || this.status == 302 || this.status == 303 || this.status == 307 || this.status == 308;
    }

    public boolean isSuccess() {
        return this.status >= 200 && this.status < 300;
    }

    public boolean isClientError() {
        return this.status >= 400 && this.status < 500;
    }

    public boolean isServerError() {
        return this.status >= 500 && this.status < 600;
    }

    public String toString() {
        if (this.error != null) {
            return "HttpClientResponse{error=" + this.error.getMessage() + "}";
        }
        return "HttpClientResponse{status=" + this.status + ", bodyLength=" + (this.body != null ? this.body.length : 0) + "}";
    }
}

