/*
 * Decompiled with CFR 0.152.
 */
package zeph.client;

import java.io.ByteArrayOutputStream;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;

public class HttpClientRequest {
    private String method = "GET";
    private String url;
    private String host;
    private int port;
    private String path;
    private String queryString;
    private boolean secure;
    private Map<String, String> headers = new HashMap<String, String>();
    private byte[] body;
    private int timeout = 30000;
    private int keepalive = 120000;
    private boolean followRedirects = true;
    private int maxRedirects = 5;
    private boolean insecure = false;
    private String[] basicAuth;
    private Map<String, Object> opts;
    private static final byte[] CRLF = "\r\n".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] HEADER_SEP = ": ".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] SPACE = " ".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] HTTP_11 = " HTTP/1.1\r\n".getBytes(StandardCharsets.US_ASCII);

    public HttpClientRequest url(String url) {
        this.url = url;
        try {
            URI uri = URI.create(url);
            this.secure = "https".equalsIgnoreCase(uri.getScheme());
            this.host = uri.getHost();
            this.port = uri.getPort();
            if (this.port < 0) {
                this.port = this.secure ? 443 : 80;
            }
            this.path = uri.getRawPath();
            if (this.path == null || this.path.isEmpty()) {
                this.path = "/";
            }
            this.queryString = uri.getRawQuery();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid URL: " + url, e);
        }
        return this;
    }

    public HttpClientRequest method(String method) {
        this.method = method.toUpperCase();
        return this;
    }

    public HttpClientRequest header(String name, String value) {
        this.headers.put(name, value);
        return this;
    }

    public HttpClientRequest headers(Map<String, String> headers) {
        if (headers != null) {
            this.headers.putAll(headers);
        }
        return this;
    }

    public HttpClientRequest body(byte[] body) {
        this.body = body;
        return this;
    }

    public HttpClientRequest body(String body) {
        this.body = body != null ? body.getBytes(StandardCharsets.UTF_8) : null;
        return this;
    }

    public HttpClientRequest timeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    public HttpClientRequest keepalive(int keepalive) {
        this.keepalive = keepalive;
        return this;
    }

    public HttpClientRequest followRedirects(boolean follow) {
        this.followRedirects = follow;
        return this;
    }

    public HttpClientRequest maxRedirects(int max) {
        this.maxRedirects = max;
        return this;
    }

    public HttpClientRequest insecure(boolean insecure) {
        this.insecure = insecure;
        return this;
    }

    public HttpClientRequest basicAuth(String user, String password) {
        this.basicAuth = new String[]{user, password};
        return this;
    }

    public HttpClientRequest queryParams(Map<String, String> params) {
        if (params != null && !params.isEmpty()) {
            boolean first;
            StringBuilder sb = new StringBuilder();
            boolean bl = first = this.queryString == null || this.queryString.isEmpty();
            if (!first) {
                sb.append(this.queryString).append("&");
            }
            for (Map.Entry<String, String> entry : params.entrySet()) {
                if (!first) {
                    sb.append("&");
                }
                sb.append(URLEncoder.encode(entry.getKey(), StandardCharsets.UTF_8)).append("=").append(URLEncoder.encode(entry.getValue(), StandardCharsets.UTF_8));
                first = false;
            }
            this.queryString = sb.toString();
        }
        return this;
    }

    public HttpClientRequest formParams(Map<String, String> params) {
        if (params != null && !params.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (Map.Entry<String, String> entry : params.entrySet()) {
                if (!first) {
                    sb.append("&");
                }
                sb.append(URLEncoder.encode(entry.getKey(), StandardCharsets.UTF_8)).append("=").append(URLEncoder.encode(entry.getValue(), StandardCharsets.UTF_8));
                first = false;
            }
            this.body = sb.toString().getBytes(StandardCharsets.UTF_8);
            this.headers.put("Content-Type", "application/x-www-form-urlencoded");
        }
        return this;
    }

    public HttpClientRequest opts(Map<String, Object> opts) {
        this.opts = opts;
        return this;
    }

    public String getMethod() {
        return this.method;
    }

    public String getUrl() {
        return this.url;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getPath() {
        return this.path;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public byte[] getBody() {
        return this.body;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int getKeepalive() {
        return this.keepalive;
    }

    public boolean isFollowRedirects() {
        return this.followRedirects;
    }

    public int getMaxRedirects() {
        return this.maxRedirects;
    }

    public boolean isInsecure() {
        return this.insecure;
    }

    public String[] getBasicAuth() {
        return this.basicAuth;
    }

    public Map<String, Object> getOpts() {
        return this.opts;
    }

    public String getPoolKey() {
        return this.host + ":" + this.port + (this.secure ? ":s" : "");
    }

    public byte[] encode() {
        ByteArrayOutputStream out = new ByteArrayOutputStream(512);
        try {
            out.write(this.method.getBytes(StandardCharsets.US_ASCII));
            out.write(SPACE);
            out.write(this.path.getBytes(StandardCharsets.US_ASCII));
            if (this.queryString != null && !this.queryString.isEmpty()) {
                out.write(63);
                out.write(this.queryString.getBytes(StandardCharsets.US_ASCII));
            }
            out.write(HTTP_11);
            this.writeHeader(out, "Host", this.getHostHeader());
            if (this.body != null && this.body.length > 0) {
                this.writeHeader(out, "Content-Length", String.valueOf(this.body.length));
            }
            if (!this.headers.containsKey("User-Agent") && !this.headers.containsKey("user-agent")) {
                this.writeHeader(out, "User-Agent", "Zeph/1.0");
            }
            if (this.keepalive > 0) {
                this.writeHeader(out, "Connection", "keep-alive");
            } else {
                this.writeHeader(out, "Connection", "close");
            }
            if (this.basicAuth != null) {
                String credentials = this.basicAuth[0] + ":" + this.basicAuth[1];
                String encoded = Base64.getEncoder().encodeToString(credentials.getBytes(StandardCharsets.UTF_8));
                this.writeHeader(out, "Authorization", "Basic " + encoded);
            }
            for (Map.Entry<String, String> entry : this.headers.entrySet()) {
                String key = entry.getKey().toLowerCase();
                if (key.equals("host") || key.equals("content-length") || key.equals("connection") || key.equals("authorization")) continue;
                this.writeHeader(out, entry.getKey(), entry.getValue());
            }
            if (!this.headers.containsKey("Accept") && !this.headers.containsKey("accept")) {
                this.writeHeader(out, "Accept", "*/*");
            }
            out.write(CRLF);
            if (this.body != null && this.body.length > 0) {
                out.write(this.body);
            }
            return out.toByteArray();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to encode request", e);
        }
    }

    private void writeHeader(ByteArrayOutputStream out, String name, String value) throws Exception {
        out.write(name.getBytes(StandardCharsets.US_ASCII));
        out.write(HEADER_SEP);
        out.write(value.getBytes(StandardCharsets.US_ASCII));
        out.write(CRLF);
    }

    private String getHostHeader() {
        if (this.secure && this.port == 443 || !this.secure && this.port == 80) {
            return this.host;
        }
        return this.host + ":" + this.port;
    }

    public String toString() {
        return this.method + " " + this.url;
    }

    public static HttpClientRequest get(String url) {
        return new HttpClientRequest().method("GET").url(url);
    }

    public static HttpClientRequest post(String url) {
        return new HttpClientRequest().method("POST").url(url);
    }

    public static HttpClientRequest put(String url) {
        return new HttpClientRequest().method("PUT").url(url);
    }

    public static HttpClientRequest delete(String url) {
        return new HttpClientRequest().method("DELETE").url(url);
    }

    public static HttpClientRequest head(String url) {
        return new HttpClientRequest().method("HEAD").url(url);
    }
}

