/*
 * Decompiled with CFR 0.152.
 */
package zeph.client;

import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import zeph.client.HttpResponseParser;
import zeph.http2.Http2ClientHandler;
import zeph.http2.Http2Settings;
import zeph.ssl.SslHandler;

public class HttpClientConnection
implements AutoCloseable {
    private final long id;
    private int fd;
    private final String host;
    private final int port;
    private final boolean secure;
    private volatile State state;
    private volatile long lastUsedTime;
    private volatile long createdTime;
    private SslHandler sslHandler;
    private MemorySegment readBuffer;
    private MemorySegment writeBuffer;
    private MemorySegment sockAddr;
    private int protocol = 1;
    private Http2ClientHandler http2Handler;
    private int workerIndex = -1;
    private HttpResponseParser responseParser;
    private Object currentRequest;
    private static final int DEFAULT_BUFFER_SIZE = 65536;
    private static final int HTTP2_WINDOW_SIZE = 0x1000000;

    public HttpClientConnection(long id, String host, int port, boolean secure) {
        this.id = id;
        this.host = host;
        this.port = port;
        this.secure = secure;
        this.state = State.CONNECTING;
        this.lastUsedTime = this.createdTime = System.currentTimeMillis();
        this.fd = -1;
    }

    public void initBuffers(Arena arena) {
        if (this.readBuffer == null) {
            this.readBuffer = arena.allocate(65536L, 64L);
        }
        if (this.writeBuffer == null) {
            this.writeBuffer = arena.allocate(65536L, 64L);
        }
        if (this.responseParser == null) {
            this.responseParser = new HttpResponseParser();
        }
    }

    public void initSsl(SslHandler handler) {
        this.sslHandler = handler;
    }

    public long getId() {
        return this.id;
    }

    public int getFd() {
        return this.fd;
    }

    public void setFd(int fd) {
        this.fd = fd;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
        if (state == State.IDLE || state == State.IN_USE) {
            this.lastUsedTime = System.currentTimeMillis();
        }
    }

    public long getLastUsedTime() {
        return this.lastUsedTime;
    }

    public void touch() {
        this.lastUsedTime = System.currentTimeMillis();
    }

    public long getCreatedTime() {
        return this.createdTime;
    }

    public SslHandler getSslHandler() {
        return this.sslHandler;
    }

    public MemorySegment getReadBuffer() {
        return this.readBuffer;
    }

    public MemorySegment getWriteBuffer() {
        return this.writeBuffer;
    }

    public MemorySegment getSockAddr() {
        return this.sockAddr;
    }

    public void setSockAddr(MemorySegment sockAddr) {
        this.sockAddr = sockAddr;
    }

    public int getProtocol() {
        return this.protocol;
    }

    public void setProtocol(int protocol) {
        this.protocol = protocol;
    }

    public boolean isHttp2() {
        return this.protocol == 2;
    }

    public Http2ClientHandler getHttp2Handler() {
        return this.http2Handler;
    }

    public void setHttp2Handler(Http2ClientHandler handler) {
        this.http2Handler = handler;
    }

    public void initHttp2() {
        this.initHttp2(null);
    }

    public void initHttp2(Http2ClientHandler.StreamCompleteListener listener) {
        this.protocol = 2;
        Http2Settings settings = new Http2Settings();
        settings.setInitialWindowSize(0x1000000);
        settings.setEnablePush(false);
        this.http2Handler = new Http2ClientHandler(settings);
        if (listener != null) {
            this.http2Handler.setStreamCompleteListener(listener);
        }
    }

    public int getWorkerIndex() {
        return this.workerIndex;
    }

    public void setWorkerIndex(int workerIndex) {
        this.workerIndex = workerIndex;
    }

    public HttpResponseParser getResponseParser() {
        return this.responseParser;
    }

    public Object getCurrentRequest() {
        return this.currentRequest;
    }

    public void setCurrentRequest(Object currentRequest) {
        this.currentRequest = currentRequest;
    }

    public String getPoolKey() {
        return this.host + ":" + this.port + (this.secure ? ":s" : "");
    }

    public boolean isAlive() {
        return this.fd >= 0 && (this.state == State.IDLE || this.state == State.IN_USE);
    }

    public boolean isIdleTooLong(long maxIdleMs) {
        if (this.state != State.IDLE) {
            return false;
        }
        return System.currentTimeMillis() - this.lastUsedTime > maxIdleMs;
    }

    public void reset() {
        if (this.responseParser != null) {
            this.responseParser.reset();
        }
        this.currentRequest = null;
        this.state = State.IDLE;
        this.touch();
    }

    public int getBufferSize() {
        return 65536;
    }

    @Override
    public void close() {
        this.state = State.CLOSED;
        if (this.sslHandler != null) {
            try {
                this.sslHandler.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.sslHandler = null;
        }
        this.fd = -1;
    }

    public String toString() {
        return "HttpClientConnection{id=" + this.id + ", host='" + this.host + "', port=" + this.port + ", secure=" + this.secure + ", state=" + String.valueOf((Object)this.state) + ", fd=" + this.fd + "}";
    }

    public static enum State {
        CONNECTING,
        HANDSHAKING,
        IDLE,
        IN_USE,
        CLOSING,
        CLOSED;

    }
}

