/*
 * Decompiled with CFR 0.152.
 */
package zeph.client;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import zeph.client.HttpClientConnectionPool;
import zeph.client.HttpClientRequest;
import zeph.client.HttpClientResponse;
import zeph.client.HttpClientWorker;
import zeph.ssl.SslConfig;

public class HttpClient
implements AutoCloseable {
    private final HttpClientConnectionPool pool;
    private final SslConfig sslConfig;
    private final HttpClientWorker[] workers;
    private final Thread[] workerThreads;
    private final AtomicInteger workerIndex = new AtomicInteger(0);
    private final AtomicBoolean running = new AtomicBoolean(true);
    private static final int DEFAULT_WORKERS = Math.max(2, Runtime.getRuntime().availableProcessors() / 2);
    private static final int DEFAULT_RING_SIZE = 256;

    public HttpClient() throws Exception {
        this(new HttpClientOptions());
    }

    public HttpClient(HttpClientOptions options) throws Exception {
        this.pool = new HttpClientConnectionPool(options.getMaxConnectionsPerHost(), options.getMaxTotalConnections(), options.getIdleTimeout(), options.getConnectionTimeout());
        this.sslConfig = SslConfig.forClient();
        int numWorkers = options.getWorkers();
        int ringSize = options.getRingSize();
        this.workers = new HttpClientWorker[numWorkers];
        this.workerThreads = new Thread[numWorkers];
        for (int i = 0; i < numWorkers; ++i) {
            this.workers[i] = new HttpClientWorker(i, this.pool, this.sslConfig, ringSize);
            this.workerThreads[i] = new Thread((Runnable)this.workers[i], "zeph-client-worker-" + i);
            this.workerThreads[i].setDaemon(true);
            this.workerThreads[i].start();
        }
    }

    public CompletableFuture<HttpClientResponse> request(HttpClientRequest request) {
        if (!this.running.get()) {
            CompletableFuture<HttpClientResponse> future = new CompletableFuture<HttpClientResponse>();
            future.completeExceptionally(new IllegalStateException("Client is closed"));
            return future;
        }
        CompletableFuture<HttpClientResponse> future = new CompletableFuture<HttpClientResponse>();
        HttpClientWorker.InFlightRequest inFlight = new HttpClientWorker.InFlightRequest(request, future);
        int idx = Math.abs(this.workerIndex.getAndIncrement() % this.workers.length);
        this.workers[idx].submit(inFlight);
        if (request.getTimeout() > 0) {
            future = future.orTimeout(request.getTimeout(), TimeUnit.MILLISECONDS);
        }
        return future;
    }

    public CompletableFuture<HttpClientResponse> get(String url) {
        return this.request(HttpClientRequest.get(url));
    }

    public CompletableFuture<HttpClientResponse> post(String url, byte[] body) {
        return this.request(HttpClientRequest.post(url).body(body));
    }

    public CompletableFuture<HttpClientResponse> post(String url, String body) {
        return this.request(HttpClientRequest.post(url).body(body));
    }

    public CompletableFuture<HttpClientResponse> put(String url, byte[] body) {
        return this.request(HttpClientRequest.put(url).body(body));
    }

    public CompletableFuture<HttpClientResponse> delete(String url) {
        return this.request(HttpClientRequest.delete(url));
    }

    public CompletableFuture<HttpClientResponse> head(String url) {
        return this.request(HttpClientRequest.head(url));
    }

    public HttpClientConnectionPool.Stats getPoolStats() {
        return this.pool.getStats();
    }

    @Override
    public void close() {
        if (!this.running.compareAndSet(true, false)) {
            return;
        }
        for (HttpClientWorker httpClientWorker : this.workers) {
            if (httpClientWorker == null) continue;
            httpClientWorker.stop();
        }
        for (Runnable runnable : this.workerThreads) {
            if (runnable == null) continue;
            try {
                ((Thread)runnable).join(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.pool.close();
    }

    public static class HttpClientOptions {
        private int workers = DEFAULT_WORKERS;
        private int ringSize = 256;
        private int maxConnectionsPerHost = 20;
        private int maxTotalConnections = 200;
        private long idleTimeout = 60000L;
        private long connectionTimeout = 30000L;

        public int getWorkers() {
            return this.workers;
        }

        public HttpClientOptions workers(int workers) {
            this.workers = workers;
            return this;
        }

        public int getRingSize() {
            return this.ringSize;
        }

        public HttpClientOptions ringSize(int ringSize) {
            this.ringSize = ringSize;
            return this;
        }

        public int getMaxConnectionsPerHost() {
            return this.maxConnectionsPerHost;
        }

        public HttpClientOptions maxConnectionsPerHost(int max) {
            this.maxConnectionsPerHost = max;
            return this;
        }

        public int getMaxTotalConnections() {
            return this.maxTotalConnections;
        }

        public HttpClientOptions maxTotalConnections(int max) {
            this.maxTotalConnections = max;
            return this;
        }

        public long getIdleTimeout() {
            return this.idleTimeout;
        }

        public HttpClientOptions idleTimeout(long timeout) {
            this.idleTimeout = timeout;
            return this;
        }

        public long getConnectionTimeout() {
            return this.connectionTimeout;
        }

        public HttpClientOptions connectionTimeout(long timeout) {
            this.connectionTimeout = timeout;
            return this;
        }
    }
}

